local MakePlayerCharacter = require "prefabs/player_common"

local assets = 
{
	Asset("ANIM", "anim/walrus_shiny_build_01.zip"),	
}
local prefabs = {	
    }
	
local start_inv = {
	--"walrushat",
}

SetSharedLootTable( 'walrusplayer',
{
	{'meat',			 1.00},
	{'walrushat',		 0.50},
})

local function RestoreNightvision(inst)

	inst:DoTaskInTime(3, function(inst) 
	inst.Light:Enable(false)
	inst.Light:SetRadius(0)
	inst.Light:SetFalloff(.5)
	inst.Light:SetIntensity(.6)
	inst.Light:SetColour(245/255,40/255,0/255)
	end, inst)
end

local function RemovePenalty(inst)
	inst.components.health:DeltaPenalty(-1.00) --Removes health penalty when reviving
	inst.components.health:DoDelta(20000, false) --Returns heals to max health upon reviving
end

local function getwildposition(inst)
    local ground = TheWorld
    local centers = {}
    for i, node in ipairs(ground.topology.nodes) do
        if ground.Map:IsPassableAtPoint(node.x, 0, node.y) then
            table.insert(centers, {x = node.x, z = node.y})
        end
    end
    if #centers > 0 then
        local pos = centers[math.random(#centers)]
        return Point(pos.x, 0, pos.z)
    else
        return inst:GetPosition()
    end
end

local function PvPTeleport(inst)
if inst.mobteleported == nil or inst.mobteleported == false then
	local ground = TheWorld
	local pt = getwildposition(inst)--Point(inst.Transform:GetWorldPosition())
      if pt.y <= .1 then
         pt.y = 0
         inst.Physics:Stop()
         inst.Physics:Teleport(pt.x,pt.y,pt.z)
		 inst.mobteleported = true
      end
	end
end

------------------------------------------------------
local function OnLoad(inst, data)
	if data ~= nil then
		inst.mobteleported = data.mobteleported or false
		inst.isshiny = data.isshiny or 0
	end
end

local function OnSave(inst, data)
	data.mobteleported = inst.mobteleported or false
	data.isshiny = inst.isshiny or 0
end

local function setSkin(inst)
	if not inst:HasTag("playerghost") then
		local mobskin = inst.components.skinner.skin_name
		local getshiny = (mobskin ~= inst.prefab and mobskin ~= "") and string.gsub(mobskin, inst.prefab.."_", "" ) --will return false if no skin is equipped.
		if SKIN_RARITY_COLORS.ModMade ~= nil then
			if getshiny ~= false then
				inst.isshiny = getshiny --used for other purposes
				inst.AnimState:SetBuild("walrus_shiny_build_0"..inst.isshiny)
			end		
		end
	end	
end

local function setChar(inst)
		if not inst:HasTag("playerghost") then
		inst.AnimState:SetBank("walrus")
		inst.AnimState:SetBuild("walrus_build")
		inst:SetStateGraph("SGwalrusplayer")
		end
		if MOBPVPMODE == "Enable" then
		PvPTeleport(inst)
		end
		inst.components.health:SetMaxHealth(250)
		inst.components.sanity:SetMax(200)
end


local NIGHTVISION_COLOURCUBES =
{
    day = "images/colour_cubes/insane_day_cc.tex",
    dusk = "images/colour_cubes/insane_dusk_cc.tex",
    night = "images/colour_cubes/purple_moon_cc.tex",
    full_moon = "images/colour_cubes/purple_moon_cc.tex",
}

local function SetNightVision(inst, enable)
    if TheWorld.state.isnight or TheWorld:IsCave() then
        inst.components.playervision:ForceNightVision(true)
        inst.components.playervision:SetCustomCCTable(NIGHTVISION_COLOURCUBES)
    else
        inst.components.playervision:ForceNightVision(false)
        inst.components.playervision:SetCustomCCTable(nil)
    end
end

local common_postinit = function(inst) 
	--inst.soundsname = "wilson"
	
	inst.soundgroup = "mctusk"
	
	inst.MiniMapEntity:SetIcon( "walrusplayer.tex" )

	inst:DoTaskInTime(0, function()
		if ThePlayer then
			inst:EnableMovementPrediction(false)
		end 
	end)
end

local function Equip(inst)
    local head = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HEAD) or nil
	if head then
	inst.AnimState:Show("HEAD")
	--head.Transform:SetScale(.5,.5,.5)
	end 	
end

local function UnEquip(inst)
	inst.AnimState:Show("HAT")
end

local function DontTriggerCreep(inst)
    inst.components.locomotor.runspeed = (4)
end


local master_postinit = function(inst)
    inst.components.health:SetMaxHealth(300)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(175)
	--inst:AddComponent("healthRegenerate")
	inst.components.combat.playerdamagepercent = MOBPVP
	inst.components.combat.pvp_damagemod = 1 --disables second pvp override.
    --inst.components.combat:SetAttackPeriod(TUNING.HOUND_ATTACK_PERIOD)
	inst.components.combat:SetRange(TUNING.WORM_ATTACK_DIST)
    inst.components.locomotor.runspeed = (4)
	inst.components.combat:SetDefaultDamage(30)
	--inst.components.combat:SetHurtSound("dontstarve/creatures/hound/hit")
	--inst.components.temperature.hurtrate = 0
    inst.components.temperature.inherentinsulation = -TUNING.INSULATION_SMALL
	inst.AnimState:SetBank("walrus")
	inst.AnimState:SetBuild("walrus_build")	
	inst.OnSetSkin = function(skin_name)
    inst.AnimState:SetBuild("walrus_build")
	inst:SetStateGraph("SGwalrusplayer")
	
	inst:ListenForEvent("ms_respawnedfromghost", DontTriggerCreep)
    DontTriggerCreep(inst)

	
	end
	inst:SetStateGraph("SGwalrusplayer")
	inst.components.talker:IgnoreAll()
	inst.components.locomotor:SetShouldRun(true)
	
	MakeMediumBurnableCharacter(inst, "pig_torso")
    --MakeMediumFreezableCharacter(inst, "pig_torso")
	
	------Tags and Vars------
	inst:AddTag("character")
    inst:AddTag("walrus")
	inst:AddTag("walrusplayer")
	inst:AddTag("houndfriend")
	inst:AddTag("special_atk1")
	
	inst.soundgroup = "mctusk"
	inst.ghostbuild = "ghost_monster_build"
	inst.mobteleported = false
	inst.isshiny = 0
	--------------------------
	
	inst.AnimState:Show("HAT")
	
	MakeCharacterPhysics(inst, 50, .5)
    inst.DynamicShadow:SetSize(2.5, 1.5)
	inst.Transform:SetScale(1.5, 1.5, 1.5)
    inst.Transform:SetFourFaced()
	
	--inst.components.temperature.maxtemp = 60
	inst.components.temperature.mintemp = 20
	inst.components.temperature.hurtrate = 3
	inst.components.moisture:SetInherentWaterproofness(0.35)
	
	inst:ListenForEvent("equip", Equip)
	inst:ListenForEvent("unequip", UnEquip)
	
	MakeMediumBurnableCharacter(inst, "pig_torso")
    
	
	------------------
    inst.OnSave = OnSave
	inst.OnLoad = OnLoad
    ------------------

	
  	local light = inst.entity:AddLight() 
  	inst.Light:Enable(false)
  	inst.Light:SetRadius(0)
  	inst.Light:SetFalloff(0.6)
  	inst.Light:SetIntensity(0.6)
  	inst.Light:SetColour(180/255,195/255,255/255)
	
	--inst.components.talker.colour = Vector3(127/255, 0/255, 0/255)
	inst:ListenForEvent("respawnfromghost", RestoreNightvision)
	
	inst:AddComponent("shedder")
	inst.components.shedder.shedItemPrefab = "blowdart_pipe"
	inst.components.shedder.shedHeight = 0.5
	inst.components.shedder:StartShedding(480 * 2)

    inst:DoTaskInTime(0, setChar)
	if SKIN_RARITY_COLORS.ModMade ~= nil then
	inst:DoTaskInTime(3, setSkin)
	end
    inst:ListenForEvent("respawnfromghost", function()
		inst:DoTaskInTime(3, function()  inst.components.health:SetInvincible(false)
            if inst.components.playercontroller ~= nil then
				inst.components.playercontroller:EnableMapControls(true)
				inst.components.playercontroller:Enable(true)
			end
			inst.components.inventory:Show()
			inst:ShowActions(true)
            inst:ShowHUD(true)
            inst:SetCameraDistance()
			inst.sg:RemoveStateTag("busy")
            SerializeUserSession(inst) 
		end)
        inst:DoTaskInTime(5, setChar)
		inst:DoTaskInTime(5.1, setSkin)
		inst:DoTaskInTime(6, DontTriggerCreep)
		inst:DoTaskInTime(6, RemovePenalty)
		inst:DoTaskInTime(10, RestoreNightvision)
    end)
	
	
    return inst
end

if SKIN_RARITY_COLORS.ModMade ~= nil then
AddModCharacterSkin("walrusplayer", 1, {normal_skin = "deerclops_shiny_build_01", ghost_skin = "ghost_monster_build"}, {"deerclops_shiny_build_01", "ghost_monster_build"}, {"DEERPLAYER", "FORMAL"})
end

return MakePlayerCharacter("walrusplayer", prefabs, assets, common_postinit, master_postinit, start_inv)
