local MakePlayerCharacter = require "prefabs/player_common"

local assets = 
{
	Asset("ANIM", "anim/wspider_queen_build.zip"),
	Asset("ANIM", "anim/wspider_queen_shiny_build_01.zip"),
    Asset("ANIM", "anim/spider_queen.zip"),
    Asset("ANIM", "anim/spider_queen_2.zip"),
	--Asset("ANIM", "anim/ghost_waxwell_build.zip"),
}
local prefabs =
{
    "monstermeat",
    "silk",
    "spiderhat",
    "spidereggsack",
}
local start_inv = {
	"silk",
	"silk",
	"spidereggsack",
	"spidergland",
	"spidergland",
	--"bedroll_furry",
	--"featherfan",
}



local NIGHT2VISION_COLOURCUBES =
{
    day = "images/colour_cubes/mole_vision_on_cc.tex",
    dusk = "images/colour_cubes/mole_vision_on_cc.tex",
    night = "images/colour_cubes/mole_vision_on_cc.tex",
    full_moon = "images/colour_cubes/mole_vision_on_cc.tex",
}

local FIXEDVISION_COLOURCUBES =
{
    day = "images/colour_cubes/purple_moon_cc.tex",
    dusk = "images/colour_cubes/purple_moon_cc.tex",
    night = "images/colour_cubes/purple_moon_cc.tex",
    full_moon = "images/colour_cubes/purple_moon_cc.tex",
}

local function SetNightVision(inst, enable)
    if TheWorld.state.isnight or TheWorld:HasTag("cave") then
        inst.components.playervision:ForceNightVision(true)
		if MOBVISION == "Enable" then
        inst.components.playervision:SetCustomCCTable(NIGHT2VISION_COLOURCUBES)
		else
		inst.components.playervision:SetCustomCCTable(FIXEDVISION_COLOURCUBES)
		end
    else
        inst.components.playervision:ForceNightVision(false)
        inst.components.playervision:SetCustomCCTable(nil)
    end
end

SetSharedLootTable( 'wspiderqueen',
{
	{'monstermeat',			 1.00},
	{'monstermeat',			 1.00},
	{'monstermeat',			 1.00},
	{'monstermeat',			 1.00},
	{'spidergland',			 	 1.00},
	{'spidergland',			 	 1.00},
	{'spidergland',			 	 1.00},
	{'spidergland',			 	 1.00},
	{'spiderhat',		 1.00},
})

local function CanShareTarget(dude)
    return dude:HasTag("spider")
        and not dude:IsInLimbo()
        and not (dude.components.health:IsDead() or dude:HasTag("player"))
end

local function OnAttacked(inst, data)
        inst.components.combat:SetTarget(data.attacker)
        inst.components.combat:ShareTarget(data.attacker, 30, CanShareTarget, 5)
 end

 local function getwildposition(inst)
    local ground = TheWorld
    local centers = {}
    for i, node in ipairs(ground.topology.nodes) do
        if ground.Map:IsPassableAtPoint(node.x, 0, node.y) then
            table.insert(centers, {x = node.x, z = node.y})
        end
    end
    if #centers > 0 then
        local pos = centers[math.random(#centers)]
        return Point(pos.x, 0, pos.z)
    else
        return inst:GetPosition()
    end
end
 
 local function PvPTeleport(inst)
if inst.mobteleported == nil or inst.mobteleported == false then
	local ground = TheWorld
	local pt = getwildposition(inst)--Point(inst.Transform:GetWorldPosition())
      if pt.y <= .1 then
         pt.y = 0
         inst.Physics:Stop()
         inst.Physics:Teleport(pt.x,pt.y,pt.z)
		 inst.mobteleported = true
      end
	end
end

------------------------------------------------------
 local function OnLoad(inst, data)
	if data ~= nil then
		inst.mobteleported = data.mobteleported or false
		inst.isshiny = data.isshiny or 0
	end
end

local function OnSave(inst, data)
	data.mobteleported = inst.mobteleported or false
	data.isshiny = inst.isshiny or 0
end

local function setSkin(inst)
	if not inst:HasTag("playerghost") then
		local mobskin = inst.components.skinner.skin_name
		local getshiny = (mobskin ~= inst.prefab and mobskin ~= "") and string.gsub(mobskin, inst.prefab.."_", "" ) --will return false if no skin is equipped.
		if SKIN_RARITY_COLORS.ModMade ~= nil then
			if getshiny ~= false then
				inst.isshiny = getshiny --used for other purposes
				inst.AnimState:SetBuild("wspider_queen_shiny_build_0"..inst.isshiny)
			end		
		end
	end	
end

local function setChar(inst)
	if not inst:HasTag("playerghost") then
    inst.AnimState:SetBank("spider_queen")
    inst.AnimState:SetBuild("wspider_queen_build")
    inst:SetStateGraph("SGqueenspiderplayer")
	end
	if MOBPVPMODE == "Enable" then
		PvPTeleport(inst)
	end
	inst.components.hunger:Pause()
	inst.components.sanity.ignore = true
end

local function BabyCount(inst)
    return inst.components.leader.numfollowers
end

local function MakeBaby(inst)
    local angle = inst.Transform:GetRotation()/DEGREES
    local prefab = (inst.components.combat.target and math.random() < .333) and "spider_dropper" or "spider_dropper"
    local spider = inst.components.lootdropper:SpawnLootPrefab(prefab)
    local rad = spider.Physics:GetRadius()+inst.Physics:GetRadius()+.25;
    local pt = Vector3(inst.Transform:GetWorldPosition())
    if spider then
        spider.Transform:SetPosition(pt.x + rad*math.cos(angle), pt.y, pt.z + rad*math.sin(angle))
        spider.sg:GoToState("taunt")
        inst.components.leader:AddFollower(spider)
		if inst.isshiny ~= 0 then
			spider.AnimState:SetBuild("spider_white_shiny_build_0"..inst.isshiny)
		end
        if inst.components.combat.target then
            spider.components.combat:SetTarget(inst.components.combat.target)
        end
    end
end

local function MaxBabies(inst)
    local pt = Vector3(inst.Transform:GetWorldPosition())
    local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, TUNING.SPIDERQUEEN_NEARBYPLAYERSDIST, {"player"}, {"playerghost"})
    local spiders = #ents * 20

    return 8
end

local function AdditionalBabies(inst)
    local pt = Vector3(inst.Transform:GetWorldPosition())
    local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, TUNING.SPIDERQUEEN_NEARBYPLAYERSDIST, {"player"}, {"playerghost"})
    local addspiders = #ents * 0.5

    return RoundBiasedUp(addspiders)
end

local function OnNewTarget(inst, data)
    if inst.components.sleeper:IsAsleep() then
        inst.components.sleeper:WakeUp()
    end
end

local function EquipHat(inst) --If a hat removes the head, this fixes that.
    local head = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HEAD) or nil
	if head ~= nil then
		inst.AnimState:Show("HEAD")
	end 
end

local function CalcSanityAura(inst, observer)
	if inst.components.combat.target then
		return -TUNING.SANITYAURA_HUGE
	end

	return -TUNING.SANITYAURA_HUGE
end

local function DontTriggerCreep(inst)
    inst.components.locomotor.runspeed = (TUNING.SPIDERQUEEN_WALKSPEED)
	inst.components.locomotor:SetSlowMultiplier( 1 )
    inst.components.locomotor:SetTriggersCreep(false)
    inst.components.locomotor.pathcaps = { ignorecreep = true }
end

local function RestoreNightvision(inst)

	inst:DoTaskInTime(3, function(inst) 
	inst.Light:Enable(true)
	inst.Light:SetRadius(0)
	inst.Light:SetFalloff(0.1)
	inst.Light:SetIntensity(.1)
	inst.Light:SetColour(245/255,40/255,0/255)
	SetNightVision(inst, true)
	end, inst)
end

local common_postinit = function(inst) 
	inst.soundsname = "wilson"

	inst.MiniMapEntity:SetIcon( "wqueenspiderplayer.tex" )

	inst:DoTaskInTime(0, function()
   if ThePlayer then
      inst:EnableMovementPrediction(false)
   end
   
   
end)
inst:WatchWorldState( "isday", function() SetNightVision(inst) end)
inst:WatchWorldState( "isdusk", function() SetNightVision(inst) end)
inst:WatchWorldState( "isnight", function() SetNightVision(inst)  end)

SetNightVision(inst, true)
end
	
local function RemovePenalty(inst)
	inst.components.health:DeltaPenalty(-1.00) --Removes health penalty when reviving
	--inst.components.health:DoDelta(20000, false) --Returns heals to max health upon reviving
end


local master_postinit = function(inst)
    inst.components.health:SetMaxHealth(1400)
	--inst:AddComponent("healthRegenerate")
    inst.components.combat:SetAttackPeriod(TUNING.SPIDERQUEEN_ATTACKPERIOD)
	inst.components.combat.playerdamagepercent = MOBPVP
	inst.components.combat:SetRange(TUNING.SPIDERQUEEN_ATTACKRANGE)
	inst.components.locomotor.walkspeed = (TUNING.SPIDERQUEEN_WALKSPEED)
    inst.components.locomotor.runspeed = (TUNING.SPIDERQUEEN_WALKSPEED)
	inst.components.locomotor.fasteronroad = false
	inst.components.combat:SetDefaultDamage(40*2)
	--inst.components.combat:SetHurtSound("dontstarve/creatures/hound/hit")
	--inst.components.health.fire_damage_scale = TUNING.WILLOW_FIRE_DAMAGE
	inst.components.temperature.hurtrate = 1
    inst.components.temperature.inherentinsulation = -TUNING.INSULATION_SMALL
	inst.AnimState:SetBank("spider_queen")
	inst.AnimState:SetBuild("wspider_queen_build")	
	inst.OnSetSkin = function(skin_name)
    inst.AnimState:SetBuild("wspider_queen_build")
	inst:SetStateGraph("SGqueenspiderplayer")
	--SetNightVision(inst, true)
	
	
	
	inst:ListenForEvent("ms_respawnedfromghost", DontTriggerCreep)
    DontTriggerCreep(inst)
	
	
	
	end
	inst:SetStateGraph("SGwqueenspiderplayer")
	inst.components.locomotor:SetShouldRun(true)
	inst.components.talker:IgnoreAll()
	inst.components.hunger:Pause()
	inst.components.sanity.ignore = true
	
	inst:AddComponent("locomotor")
    inst.components.locomotor:SetSlowMultiplier( 1 )
    inst.components.locomotor:SetTriggersCreep(false)
    inst.components.locomotor.pathcaps = { ignorecreep = true }	
	
	inst:AddComponent("incrementalproducer")
    inst.components.incrementalproducer.countfn = BabyCount
    inst.components.incrementalproducer.producefn = MakeBaby
    inst.components.incrementalproducer.maxcountfn = MaxBabies
    inst.components.incrementalproducer.incrementfn = AdditionalBabies
    inst.components.incrementalproducer.incrementdelay = TUNING.SPIDERQUEEN_GIVEBIRTHPERIOD
	
	--inst:AddTag("spider")
	inst:AddTag("spiderwhisperer")
	inst:AddTag("monster") 
	inst:RemoveTag("character")
	inst:AddTag("epic")
    inst:AddTag("largecreature")
    inst:AddTag("spiderqueen")

	inst.hit_recovery = 3
	
	inst.taunt = true
	inst.mobsleep = true
	inst.mobplayer = true
	inst.specialatk2 = true
	inst.isshiny = 0
	inst.ghostbuild = "ghost_monster_build"
	inst.mobteleported = false
	
	inst.OnSave = OnSave
	inst.OnLoad = OnLoad
	
	MakeCharacterPhysics(inst, 1000, 1)
    inst.DynamicShadow:SetSize(7, 3)
    inst.Transform:SetFourFaced()

	inst:AddComponent("leader")
	
	inst:AddComponent("sanityaura")
	
	inst.components.temperature.maxtemp = 60
	inst.components.temperature.mintemp = 20
	
	inst.poisonimmune = true
	
	inst.components.sanityaura.aurafn = CalcSanityAura
    
    inst:AddComponent("lootdropper")
	inst.components.lootdropper:SetChanceLootTable("wspiderqueen")
	
	inst:ListenForEvent("attacked", OnAttacked)
	inst:ListenForEvent("equip", EquipHat)
	
	inst:AddComponent("shedder")
	inst.components.shedder.shedItemPrefab = "spidergland"
	inst.components.shedder.shedHeight = 0.5
	inst.components.shedder:StartShedding(240)
	
	--inst.components.playervision.nightvision = true
	--inst.components.playervision:ForceNightVision(true)
    --inst.components.playervision:SetCustomCCTable(NIGHT2VISION_COLOURCUBES)
	
	inst.components.eater:SetDiet({ FOODTYPE.MEAT }, { FOODTYPE.MEAT })
    inst.components.eater:SetCanEatHorrible()

    inst.components.eater.strongstomach = true -- can eat monster meat!
	
    --inst:AddComponent("periodicspawner")
    --inst.components.periodicspawner:SetPrefab("silk")
    --inst.components.periodicspawner:SetRandomTimes(5, 10)
    --inst.components.periodicspawner:SetDensityInRange(20, 2)
    --inst.components.periodicspawner:SetMinimumSpacing(8)
    --inst.components.periodicspawner:Start()
	
	MakeLargeBurnableCharacter(inst, "body")
    MakeLargeFreezableCharacter(inst, "body")
    --inst.components.burnable.flammability = TUNING.SPIDER_FLAMMABILITY
    
	
	------------------
    
    ------------------

	
  	local light = inst.entity:AddLight()
  	inst.Light:Enable(true)
  	inst.Light:SetRadius(0)
  	inst.Light:SetFalloff(0.1)
  	inst.Light:SetIntensity(0.1)
  	inst.Light:SetColour(180/255,195/255,150/255)

	--Not needed since it has nightvision for all times of day.
  	--inst:WatchWorldState( "isday", function() ActivateNightVision (inst, true) end)
  	--inst:WatchWorldState( "isdusk", function() ActivateNightVision (inst, true) end)
  	--inst:WatchWorldState( "isnight", function() ActivateNightVision (inst, true)  end)
	--SetBeaverMode(inst, true)
	
	inst.components.talker.colour = Vector3(127/255, 0/255, 0/255)
	inst:ListenForEvent("respawnfromghost", RestoreNightvision)

    inst:DoTaskInTime(0, setChar)
	inst:DoTaskInTime(3, setSkin)
    inst:ListenForEvent("respawnfromghost", function()
		inst:DoTaskInTime(3, function()  inst.components.health:SetInvincible(false)
            if inst.components.playercontroller ~= nil then
				inst.components.playercontroller:EnableMapControls(true)
				inst.components.playercontroller:Enable(true)
			end
			inst.components.inventory:Show()
			inst:ShowActions(true)
            inst:ShowHUD(true)
            inst:SetCameraDistance()
			inst.sg:RemoveStateTag("busy")
            SerializeUserSession(inst) 
		end)
        inst:DoTaskInTime(5, setChar)
		inst:DoTaskInTime(5.1, setSkin)
		inst:DoTaskInTime(6, RemovePenalty)
		inst:DoTaskInTime(6, DontTriggerCreep)
		inst:DoTaskInTime(10, RestoreNightvision)
    end)
	
    return inst
	
end

if SKIN_RARITY_COLORS.ModMade ~= nil then
AddModCharacterSkin("wqueenspiderplayer", 1, {normal_skin = "deerclops_shiny_build_01", ghost_skin = "ghost_monster_build"}, {"deerclops_shiny_build_01", "ghost_monster_build"}, {"DEERPLAYER", "FORMAL"})
end

return MakePlayerCharacter("wqueenspiderplayer", prefabs, assets, common_postinit, master_postinit, start_inv)
