--[[
Hint for admins of dedicated servers. Copy & paste it to your modoverrides.lua:

["workshop-522365312"] = { --Disable Characters Mod
	enabled = true,
	configuration_options =
	{
		wilson = false, -- false means "Enabled"
		willow = true, -- true maens "Disabled"
		wolfgang = false,
		wendy = false,
		wx78 = false,
		wickerbottom = false,
		woodie = false,
		wes = false,
		wathgrithr = true,
		webber = false,
		waxwell = false, --Note that prefab name is "waxwell", not "maxwell".
		
		remove_all_starting_inventory = false, --true means "remove ALL items"
		remove_lighter = false, --true means remove lighter
		remove_spear = false,
		remove_helmet = false,
		remove_eggs = false,
		
		--DISABLING MOD CHARACTERS:--
		--Use comma to list a few custom characters inside the quotes.
		--Don't forget about comma after each option (i.e. after quotes).
		user_character = "asuna", -- This is text string of custom character prefab. "asuna" is just an example.
		cheat_admin = false, -- false means "No". Use it to test that the mod works fine, or change it to true.
		
		--How to find prefab name? 1) Open modmain.lua of the character's mod. 2) Find the text: AddModCharacter(prefab_name).
		--Example: AddModCharacter("wren","FEMALE") -- "wren" is the prefab name.
		
		--SOME DISABLED CHARACTERS MAY BE PREMIUM CHARACTERS:--
		--Reserved characters: ,;@=-
		-- ";" separator between user data
		-- "=" separator between user identifier and user options
		-- "," separator between user options (characters)
		-- "@" separator between user name and user id.
		-- user name is optional.
		-- "-" means character is not allowed for user.
		premium_character = "Star@KU_7jBnfOI2=wx78,-wilson"
		-- Example: Star can join as WX-78 but can't join as Wilson.
	}
},


----- OR -----
Another SIMPLE way to list all standard and modded characters:

["workshop-522365312"] = { --Disable Characters Mod
	enabled = true,
	configuration_options =
	{
		cheat_admin = false,
		user_character = "asuna, willow, wathgrithr",
	}
},


--]]


--IF YOU ARE HOST, NOT ADMIN OF DEDICATED SERVER:--
CUSTOM_CHAR = "Disabled" --Change this value to character prefab if you like. For example "asuna" or "bender" or "asuna,bender".
--NB: This is not character name. However usually character name is equal to character prefab.
--Examples:
--CUSTOM_CHAR = "asuna"
--CUSTOM_CHAR = "asuna, musha"
--CUSTOM_CHAR = "musha, walter, whandler, wanda, grell"
--Don't copy the line. The line should be only one. Just replace the word "Disabled" with a list of your custom character prefabs.

--How to get exact prefab name of a character?
--Open modmain.lua of character mod and find text "AddModCharacter".
--Example: AddModCharacter("wren","FEMALE") -- "wren" is the prefab name.

local CUSTOM_PREMIUM = "" --Special option for premium users.


--Note that if you edit modinfo.lua directly, it will be overwritten after next update of the mod.
--I hope I won't update the mod but it may be necessary. 


name = "Disable Characters"
description = "Will disable standard characters."
forumthread = ""
author = "star"
version = "0.08"
api_version = 10

dont_starve_compatible = false
reign_of_giants_compatible = false
dst_compatible = true

all_clients_require_mod = true
client_only_mod = false
server_filter_tags = {"disabled"}

icon_atlas = "preview.xml"
icon = "preview.tex"

priority = -900.00522365312
--Так как мы меняем стартовый инвентарь, то надо быть НИЖЕ всех остальных персонажей.
--Обычно они имеют приоритет 0.


DST_CHARACTERLIST =
{
    "wilson", "willow", "wolfgang", "wendy", "wx78", "wickerbottom", "woodie", "wes", "wathgrithr", "webber", "waxwell",
}
DST_CHARACTERNAMES =
{
    "Wilson", "Willow", "Wolfgang", "Wendy", "WX-78", "Wickerbottom", "Woodie", "Wes", "Wigfrid", "Webber", "Maxwell",
}

common_options = {
	{description = "Enabled", data = false},
	{description = "Disabled", data = true},
}
configuration_options = {nil,nil,nil,   nil,nil,nil,   nil,nil,nil,} --x9
for i=1,#DST_CHARACTERLIST do
	configuration_options[i] = {
		name = DST_CHARACTERLIST[i],
		label = DST_CHARACTERNAMES[i],
		hover = "Allow this character?",
		options = common_options,
		default = false,
	}
end

local optionsYesNo = {
	{description = "Yes", data = true},
	{description = "No", data = false},
}

configuration_options[#DST_CHARACTERLIST+1] = {
	name = "cheat_admin",
	label = "Cheater Admin",
	hover = "Admin will be able to use disabled characters.",
	options = optionsYesNo,
	default = false,
}


configuration_options[#DST_CHARACTERLIST+2] = {
	name = "user_character",
	label = "User Character",
	hover = "Works only for dedicated servers.\nHosts should change CUSTOM_CHAR variable in modinfo.lua directly.",
	options = {
		{description = CUSTOM_CHAR == "Disabled" and "No" or CUSTOM_CHAR, data = CUSTOM_CHAR},
	},
	default = CUSTOM_CHAR,
}



local more_settings = {
	{
		name = "remove_all_starting_inventory",
		label = "Remove All Items",
		hover = "Remove any starting inventory.\n Other inventory options won't take effect.",
		options = optionsYesNo,
		default = false,
	},
	{
		name = "remove_lighter",
		label = "Remove Lighter",
		--hover = "",
		options = optionsYesNo,
		default = false,
	},
	{
		name = "remove_spear",
		label = "Remove Wigfrid Spear",
		--hover = "",
		options = optionsYesNo,
		default = false,
	},
	{
		name = "remove_helmet",
		label = "Remove Wigfrid Helmet",
		--hover = "",
		options = optionsYesNo,
		default = false,
	},
	{
		name = "remove_eggs",
		label = "Remove Spider Eggs",
		--hover = "",
		options = optionsYesNo,
		default = false,
	},
	{
		name = "premium_character",
		label = "Premium",
		hover = "Works only for dedicated servers.",
		options = {
			{description = "No", data = CUSTOM_PREMIUM },
		},
		default = CUSTOM_PREMIUM,
	}
}


for i=1,#more_settings do
	configuration_options[#DST_CHARACTERLIST+2+i] = more_settings[i]
end




