PrefabFiles = {
	"charlie",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/charlie.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/charlie.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/charlie.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/charlie.xml" ),

    Asset( "IMAGE", "bigportraits/charlie.tex" ),
    Asset( "ATLAS", "bigportraits/charlie.xml" ),
	
	Asset( "IMAGE", "images/map_icons/charlie.tex" ),
	Asset( "ATLAS", "images/map_icons/charlie.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_charlie.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_charlie.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_charlie.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_charlie.xml" ),
	
	Asset("SOUNDPACKAGE", "sound/charlie.fev"),
    Asset("SOUND", "sound/charlie.fsb"),
	
}

RemapSoundEvent( "dontstarve/characters/charlie/death_voice", "charlie/characters/charlie/death_voice" )
RemapSoundEvent( "dontstarve/characters/charlie/hurt", "charlie/characters/charlie/hurt" )
RemapSoundEvent( "dontstarve/characters/charlie/talk_LP", "charlie/characters/charlie/talk_LP" )

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

-- The character select screen lines
GLOBAL.STRINGS.CHARACTER_TITLES.charlie = "The Assistant"
GLOBAL.STRINGS.CHARACTER_NAMES.charlie = "Charlie"
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.charlie = "*Looking for the magician.\n*The darkness she fears also strengthens her."
GLOBAL.STRINGS.CHARACTER_QUOTES.charlie = "\"Hello?\""

-- Custom speech strings
GLOBAL.STRINGS.CHARACTERS.CHARLIE = require "speech_charlie"

-- The character's name as appears in-game 
GLOBAL.STRINGS.NAMES.CHARLIE = "Charlie"

-- The default responses of examining the character
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.CHARLIE = 
{
	GENERIC = "It's Charlie!",
	ATTACKER = "That Charlie looks shifty...",
	MURDERER = "Murderer!",
	REVIVER = "Charlie, friend of ghosts.",
	GHOST = "Charlie could use a heart.",
}

-- Let the game know character is male, female, or robot
table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "charlie")


AddMinimapAtlas("images/map_icons/charlie.xml")
AddModCharacter("charlie")
