local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/charlie.zip" ),
        Asset( "ANIM", "anim/ghost_charlie_build.zip" ),
}
local prefabs = {}
local start_inv = {
	-- Custom starting items
}
local function updatedamage(inst, phase)
    if phase == "day" then
        inst.components.combat.damagemultiplier = 0.75
    elseif phase == "night" then
        inst.components.combat.damagemultiplier = 1.25
    elseif phase == "dusk" then
        inst.components.combat.damagemultiplier = 1
    end

end

local function applydarkvision(inst)
	if inst.components.playervision then
		if inst.darkvision:value() then
			inst.components.playervision:ForceNightVision(true)
		else
			inst.components.playervision:ForceNightVision(false)
		end
	end
end

local function registerdarkvisionlistener(inst)
	inst:ListenForEvent("darkvisiondirty", applydarkvision)
end

local function initializedarkvision(inst)
	inst.darkvision = net_bool(inst.GUID, "player.darkvision", "darkvisiondirty")
	inst.darkvision:set(false)
	inst:DoTaskInTime(0, registerdarkvisionlistener)
end

local common_postinit = function(inst)
initializedarkvision(inst)
-- Minimap icon
	inst.MiniMapEntity:SetIcon( "charlie.tex" )
end

local function OnTalk(inst) --Plays the grue sound instead of Charlie's voice
	if inst.darkvision:value() then
	inst.SoundEmitter:PlaySound("dontstarve/charlie/warn")
	end
end

--Calculates the sanity drain aura for shadow form
local function CalcSanityAura(inst)
    return inst.components.combat.target ~= nil and -TUNING.SANITYAURA_HUGE or -TUNING.SANITYAURA_LARGE
end

--Calculate the sanity drain aura in human form
local function CalcSanityAuraDay(inst)
    return 0
end

local function ShadowFormController(inst)
	local x, y, z = inst.Transform:GetWorldPosition()
	if inst.LightWatcher:GetLightValue() < (0.1) then
		--Constantly Spawns while dark
		SpawnPrefab("cane_ancient_fx").Transform:SetPosition(x, y, z)
		
		--Shadow Form
		if inst.LightWatcher:GetLightValue() < (0.1) and not inst.darkvision:value() then
			SpawnPrefab("shadow_shield1").Transform:SetPosition(x, y, z)
			inst.darkvision:set(true)
			inst.components.combat.damagemultiplier = 1.5
			inst.components.sanity.night_drain_mult = 3
			inst.AnimState:SetMultColour(0, 0, 0, .5)
			inst.soundsname = ""
			inst.DynamicShadow:Enable(false)
			
			--Impliments the Aura
			inst.components.sanityaura.aurafn = CalcSanityAura
			inst.components.sanityaura.aura = -TUNING.SANITYAURA_LARGE
		end
	--Human Form
    elseif inst.LightWatcher:GetLightValue() > (0.1) and inst.darkvision:value() then
        SpawnPrefab("shadow_shield1").Transform:SetPosition(x, y, z)
		inst.darkvision:set(false)
		updatedamage(inst, TheWorld.state.phase)
		inst.components.sanity.night_drain_mult = 1.5
		inst.AnimState:SetMultColour(1, 1, 1, 1)
		inst.soundsname = "charlie"
		inst.DynamicShadow:Enable(true)
		
		--Impliments the Aura
		inst.components.sanityaura.aurafn = CalcSanityAuraDay
		inst.components.sanityaura.aura = nil
    end
end


local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "charlie"
	-- Stats	
	inst:WatchWorldState("phase", updatedamage)
	updatedamage(inst, TheWorld.state.phase)
	inst:ListenForEvent("hungerdelta", ShadowFormController)
	inst:ListenForEvent("ontalk", OnTalk)
	inst:ListenForEvent("emote", OnTalk)
	inst:AddComponent("sanityaura")
	
	--Initiate the sanity drain Aura
	inst.components.sanityaura.aurafn = CalcSanityAuraDay
	inst.components.sanityaura.aura = nil
	
inst.components.health:SetMaxHealth(125)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(150)
inst.components.sanity.night_drain_mult = 1.25


end

return MakePlayerCharacter("charlie", prefabs, assets, common_postinit, master_postinit, start_inv)