PrefabFiles = {
	"wayrra",
	"orbstaff",
	"sanityorb",
	"orbstafffire",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/wayrra.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/wayrra.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/wayrra.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/wayrra.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/wayrra_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/wayrra_silho.xml" ),

    Asset( "IMAGE", "bigportraits/wayrra.tex" ),
    Asset( "ATLAS", "bigportraits/wayrra.xml" ),
	
	Asset( "IMAGE", "images/map_icons/wayrra.tex" ),
	Asset( "ATLAS", "images/map_icons/wayrra.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_wayrra.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_wayrra.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_wayrra.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_wayrra.xml" ),
	
	Asset("ATLAS", "images/inventoryimages/sanityorb.xml"),
	Asset("IMAGE", "images/inventoryimages/sanityorb.tex"),
	
	Asset( "IMAGE", "images/map_icons/orbstaff.tex" ),
	Asset( "ATLAS", "images/map_icons/orbstaff.xml" ),
}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local Recipe = GLOBAL.Recipe
local RECIPETABS = GLOBAL.RECIPETABS
local TECH = GLOBAL.TECH
local resolvefilepath = GLOBAL.resolvefilepath

-- The character select screen lines
STRINGS.CHARACTER_TITLES.wayrra = "The Arctic Fox"
STRINGS.CHARACTER_NAMES.wayrra = "Wayrra"
STRINGS.CHARACTER_DESCRIPTIONS.wayrra = "*Has warm fur\n*Loves spiders... for dinner\n*Darkness? No, thank you"
STRINGS.CHARACTER_QUOTES.wayrra = "\"C'mon it's not THAT cold!\""

-- Custom speech strings
STRINGS.CHARACTERS.WAYRRA = require "speech_wayrra"

-- Custom items
STRINGS.NAMES.ORBSTAFF = "Fox Tribe Orb Staff"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ORBSTAFF = "Magical looking staff with orbs."

STRINGS.NAMES.SANITYORB = "Green Orb of Sanity"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SANITYORB = "It makes me feel good."

-- The character's name as appears in-game 
STRINGS.NAMES.WAYRRA = "Wayrra"

-- The default responses of examining the character
STRINGS.CHARACTERS.GENERIC.DESCRIBE.WAYRRA = 
{
	GENERIC = "It's Wayrra!",
	ATTACKER = "What a sly fox!",
	MURDERER = "You're evil!",
	REVIVER = "Wayrra, the ghost whisperer.",
	GHOST = "Wayrra could use a heart.",
}

-- Let the game know character is male, female, or robot
table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "wayrra")

-- Quick check if RoG is enabled
local rogEnabled = function()
	return GLOBAL.IsDLCEnabled(GLOBAL.REIGN_OF_GIANTS)
end

--custom recipe
	local sanityorb_recipe = Recipe("sanityorb", {Ingredient("livinglog", 1), Ingredient("crow", 1), Ingredient("nightmarefuel", 3)}, RECIPETABS.MAGIC, TECH.NONE, "sanityorb_placer", nil, nil, nil, nil, "sanityorb_builder")
	sanityorb_recipe.sortkey = -8812221
	sanityorb_recipe.atlas = resolvefilepath("images/inventoryimages/sanityorb.xml")
	STRINGS.RECIPE_DESC.SANITYORB = "It has some good energy."
	
-- Function to make beefalo hostile to character
local makeBeefaloHostile = function (prefab)
    if prefab.components.combat then
        local targetfn_orig = prefab.components.combat.targetfn
        local targetfn_new = function(inst)
            local target = nil
            -- First retarget normally
            if targetfn_orig then target = targetfn_orig(inst) end
            -- If no target found, target Wayrra
            if target == nil then
                target = GLOBAL.FindEntity(inst, GLOBAL.TUNING.BEEFALO_TARGET_DIST, function(guy)
                    return not guy:HasTag("beefalo") and
                            inst.components.combat:CanTarget(guy) and
                            not guy:HasTag("wall")
                            and guy.prefab == "wayrra"
                end)
            end
            return target
        end
        prefab.components.combat.targetfn = targetfn_new
    end
end
 
AddPrefabPostInit("beefalo", makeBeefaloHostile)
AddMinimapAtlas("images/map_icons/wayrra.xml")
AddMinimapAtlas("images/map_icons/orbstaff.xml")
AddModCharacter("wayrra")

