local assets=
{
    Asset("ANIM", "anim/orbstaff.zip"),
    Asset("ANIM", "anim/swap_orbstaff.zip"),
 
    Asset("ATLAS", "images/inventoryimages/orbstaff.xml"),
    Asset("IMAGE", "images/inventoryimages/orbstaff.tex"),
}

local prefabs = 
{
	"orbstafffire",
	"ice_projectile",
	"staffcastfx",
}

--ICE Staff functions
local function onattack_blue(inst, attacker, target)

    if attacker and attacker.components.sanity then
        attacker.components.sanity:DoDelta(-5)
    end
    
    if target.components.freezable then
        target.components.freezable:AddColdness(1)
        target.components.freezable:SpawnShatterFX()
    end
    if target.components.sleeper and target.components.sleeper:IsAsleep() then
        target.components.sleeper:WakeUp()
    end
    if target.components.burnable and target.components.burnable:IsBurning() then
        target.components.burnable:Extinguish()
    end
    if target.components.combat then
        target.components.combat:SuggestTarget(attacker)
        if target.sg and not target.sg:HasStateTag("frozen") and target.sg.sg.states.hit then
            target.sg:GoToState("hit")
        end
    end
end

 --Orb Staff basics and Light
local function OnEquip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_orbstaff", "swap_orbstaff")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
	--light
	inst.fire = SpawnPrefab( "orbstafffire" )
    local follower = inst.fire.entity:AddFollower()
    follower:FollowSymbol( owner.GUID, "swap_object", 0, -110, 1 )
end

local function OnUnequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
	--light
	inst.fire:Remove()
    inst.fire = nil
end

local function fn()
 
    local inst = CreateEntity()
	inst.entity:AddNetwork()
	inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "orbstaff.tex" )
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
     
    anim:SetBank("orbstaff")
    anim:SetBuild("orbstaff")
    anim:PlayAnimation("idle")
 	inst:AddTag("sharp")
	
if not TheWorld.ismastersim then
	return inst
end

	inst.entity:SetPristine()
 
    inst:AddComponent("inspectable")
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(0)
    inst.components.weapon:SetRange(8, 12)
    inst.components.weapon:SetOnAttack(onattack_blue)
    inst.components.weapon:SetProjectile("ice_projectile")
     
    inst:AddComponent("characterspecific")
    inst.components.characterspecific:SetOwner("wayrra")
     
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "orbstaff"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/orbstaff.xml"
      
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
  --owner in DST
	--inst:DoTaskInTime(0, function() if not GetPlayer() or GetPlayer().prefab ~= "wayrra" then inst:Remove() end end)
    return inst
end
return  Prefab("common/inventory/orbstaff", fn, assets, prefabs)