require "prefabutil"

local assets =
{
	Asset("ANIM", "anim/sanityorb.zip"),
}

--from Dwarf Star stafflight.lua
local function kill_light(inst)
    inst.AnimState:PlayAnimation("disappear")
    inst:DoTaskInTime(0.6, function() inst.SoundEmitter:KillAllSounds() inst:Remove() end)  
	
	local ash = SpawnPrefab("ash")
	ash.Transform:SetPosition(inst.Transform:GetWorldPosition())	
end

local function resumestar(inst, time)
    if inst.death then
        inst.death:Cancel()
        inst.death = nil
    end
    inst.death = inst:DoTaskInTime(time, kill_light)
    inst.timeleft = time
end

local function onsave(inst, data)
    data.timealive = inst:GetTimeAlive()
    data.init_time = inst.init_time
end

local function onload(inst, data)
        if data.timealive and data.init_time then
            inst.init_time = data.init_time
            local timeleft = (inst.init_time or 120) - data.timealive
            if timeleft > 0 then
            resumestar(inst, timeleft)
        else
            kill_light(inst)
        end
    end
end
--the end of Dwarf star code
local function onhammered(inst, worker)
        SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
        inst:Remove()
        inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
end

local function updatelight(inst)
 
    inst.Light:Enable(true)
    inst.Light:SetRadius(1)
    inst.Light:SetFalloff(.8)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(0,255/255,0)
    inst.AnimState:PlayAnimation("idle")
    inst.lighton = true

end

local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()        
    inst.entity:AddNetwork() --networking
    inst.entity:AddLight()
    inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
    inst.AnimState:SetRayTestOnBB(true)

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("sanityorb")
    inst.AnimState:SetBuild("sanityorb")
    inst.AnimState:PlayAnimation("idle")
	
--DST part
	if not TheWorld.ismastersim then
		return inst
	end

	inst.entity:SetPristine()
	
	MakeObstaclePhysics(inst, .1)    
	
    inst:AddComponent("inspectable")
	
	inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(2)
    inst.components.workable:SetOnFinishCallback(onhammered)
	
	--burn
	inst:AddComponent("burnable")
	inst.components.burnable:SetBurnTime(10) 
	
	--sanity aura
	inst:AddComponent("sanityaura")
    inst.components.sanityaura.aura = TUNING.SANITYAURA_MED
	
	inst:AddComponent("characterspecific")
    inst.components.characterspecific:SetOwner("wayrra")
	
    --stafflight part
	inst.init_time = 120
    inst.death = inst:DoTaskInTime(inst.init_time, kill_light)

    inst.OnLoad = onload
    inst.OnSave = onsave

    inst:DoPeriodicTask(2, function() updatelight(inst) end)

    return inst
end

return Prefab("common/objects/sanityorb", fn, assets),
    MakePlacer( "common/sanityorb_placer", "sanityorb", "sanityorb", "idle" )