
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/wayrra.zip" ),
        Asset( "ANIM", "anim/ghost_wayrra_build.zip" ),
}
local prefabs = {
"orbstaff",
"sanityorb",
}

local start_inv = {
	-- Custom starting items
	"orbstaff",
	"monstermeat",
	"monstermeat",
	"monstermeat",
	"monstermeat",
	"monstermeat",
}

local common_postinit = function(inst) 
	inst.soundsname = "wendy"
end

-- This initializes for the host and clients
local master_postinit = function(inst)
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "wayrra.tex" )
	
	-- Stats	
	inst.components.health:SetMaxHealth(140)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(210)
	inst:AddTag("sanityorb_builder") 
	--Thick Fur 
	inst.components.temperature.inherentinsulation = 125 
	inst.components.temperature.inherentsummerinsulation = 0
	
	--Food
	local eater = inst.components.eater
	eater:SetCarnivore(true)
	eater.ignoresspoilage = true

	--Food penalty
	inst.components.eater.Eat_orig = inst.components.eater.Eat
function inst.components.eater:Eat( food )
	if self:CanEat(food) then
		if food.components.edible.sanityvalue < 0 then
		food.components.edible.sanityvalue = 1
	end
		if food.components.edible.healthvalue < 0 then
		food.components.edible.healthvalue = 3
	end
end
return inst.components.eater:Eat_orig(food)
end
	
	-- Disallow talking when saying an empty string
	local talker = inst.components.talker
	talker.Say_wayrra_redirect = talker.Say
	function talker:Say(script, time, noanim)
		if script == "" then return end
		talker:Say_wayrra_redirect(script, time, noanim)
	end
	
	--sanity from killing spiders
 local function onkilled(victim,inst)
        if victim and victim.prefab then
        if victim.prefab == "spider" then
            inst.components.sanity:DoDelta(TUNING.SANITY_SMALL*0.5)
        end
        end
    end
 
    inst:ListenForEvent( "killed", function(inst,data) onkilled(data.victim,inst) end )
end

return MakePlayerCharacter("wayrra", prefabs, assets, common_postinit, master_postinit, start_inv)
