local easing = require("easing")
local WarfarinSneak = Class(function(self, inst)
    self.inst = inst

	self.max = 100
    self.current = 0

	self.inst:DoPeriodicTask(4/10, function() self:DoSneak() end)
end)

function WarfarinSneak:DoSneak()
    local oldpercent = self.current/self.max
		if self.inst.sg:HasStateTag("treehugger") then
	self.current = 100
        self.inst:AddTag("shadow")
        self.inst.AnimState:SetMultColour(0, 0, 0, 0)
		else
		if not self.inst:HasTag("warfarinwaving") then

	local pt = Vector3(self.inst.Transform:GetWorldPosition())

	local ents = nil
	local fires = nil
	local cover = nil
	local tree = nil
	local sneak = nil

	local colour = 1
	local opacity = 1

	self.current = 1

	if GetClock():IsDusk() and not GetWorld():IsCave() then
	ents = TheSim:FindEntities(pt.x,pt.y,pt.z, 3, {"hostile"}, {"tree"})
	fires = TheSim:FindEntities(pt.x,pt.y,pt.z, TUNING.LEIF_REAWAKEN_RADIUS/3, {"fire"})
	cover = TheSim:FindEntities(pt.x,pt.y,pt.z, 2, {"cover"})
	tree = TheSim:FindEntities(pt.x,pt.y,pt.z, 1.5, {"tree"}, {"stump"})
	sneak = TheSim:FindEntities(pt.x,pt.y,pt.z, 2, {"sneak"})
	colour = .2
	opacity = .4
	self.current = 65

	elseif GetClock():IsNight() or GetWorld():IsCave() then
	ents = TheSim:FindEntities(pt.x,pt.y,pt.z, 1, {"hostile"}, {"tree"})
	fires = TheSim:FindEntities(pt.x,pt.y,pt.z, TUNING.LEIF_REAWAKEN_RADIUS/3, {"fire"})
	cover = TheSim:FindEntities(pt.x,pt.y,pt.z, 3, {"cover"})
	tree = TheSim:FindEntities(pt.x,pt.y,pt.z, 2.5, {"tree"}, {"stump"})
	sneak = TheSim:FindEntities(pt.x,pt.y,pt.z, 2, {"sneak"})
	colour = .1
	opacity = .2
	self.current = 100

	elseif GetClock():IsDay() and not GetWorld():IsCave() then
	ents = TheSim:FindEntities(pt.x,pt.y,pt.z, 4, {"hostile"}, {"tree"})
	fires = TheSim:FindEntities(pt.x,pt.y,pt.z, TUNING.LEIF_REAWAKEN_RADIUS/5, {"fire"})
	cover = TheSim:FindEntities(pt.x,pt.y,pt.z, 1, {"cover"})
	tree = TheSim:FindEntities(pt.x,pt.y,pt.z, 1, {"tree"}, {"stump"})
	sneak = TheSim:FindEntities(pt.x,pt.y,pt.z, 1, {"sneak"})
	colour = .4
	opacity = .6
	self.current = 20
			end

	if #tree > 0 or #sneak > 0 or #cover > 0 then
	if #ents > 0 or #fires > 0 or self.inst.sg:HasStateTag("attack") then
        self.inst:RemoveTag("shadow")
        self.inst.AnimState:SetMultColour(1, 1, 1, 1)
	self.current = 1
	else
	self.current = self.current
        self.inst:AddTag("shadow")
        self.inst.components.colourtweener:StartTween({colour,colour,colour,opacity}, 0.7)
		end
		else
	self.current = 1
        self.inst:RemoveTag("shadow")
        self.inst.AnimState:SetMultColour(1, 1, 1, 1)
		end
	end
    local pt = self.inst:GetPosition()

	local seen = TheSim:FindEntities(pt.x,pt.y,pt.z, 20)
    for k,v in pairs(seen) do
        if v.components.combat and v.components.combat.target and  v.components.combat.target == self.inst then
        self.inst:RemoveTag("shadow")
        self.inst.AnimState:SetMultColour(1, 1, 1, 1)
	self.current = 1
		end
	end
    end
    self.current = self.current
    
  self.inst:PushEvent("warfarinsneakdelta", {oldpercent = oldpercent, newpercent = self.current/self.max})
end

function WarfarinSneak:GetPercent()
    return self.current / self.max
end

return WarfarinSneak