local assets =
{
	Asset("ANIM", "anim/warfarinbow_arrow.zip"),
	Asset("ANIM", "anim/warfarinbow_arrow2.zip"),
	Asset("ANIM", "anim/warfarinblooddrop.zip"),
	Asset("ANIM", "anim/bee_mine_maxwell.zip"),
	Asset("ANIM", "anim/faithesong.zip"),
}

local function OnIgniteFn(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/blackpowder_fuse_LP", "hiss")
end

local function OnExplodeFn(inst)
    local pos = Vector3(inst.Transform:GetWorldPosition())
    inst.SoundEmitter:KillSound("hiss")
    inst.SoundEmitter:PlaySound("dontstarve/common/blackpowder_explo")

    local explode = SpawnPrefab("explode_small")
    local pos = inst:GetPosition()
    explode.Transform:SetPosition(pos.x, pos.y, pos.z)

    --local explode = PlayFX(pos,"explode", "explode", "small")
    explode.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
    explode.AnimState:SetLightOverride(1)
end


local function commonfn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
	local light = inst.entity:AddLight()
    inst.Transform:SetFourFaced()
    anim:SetBank("nightmare_watch")
    anim:SetBuild("warfarinbow_arrow")
    anim:PlayAnimation("idle_1")
	inst.Transform:SetScale(0, 0, 0)
    
	inst.persists = false
		
    inst:AddTag("FX")
    inst:AddTag("NOCLICK")

    anim:SetFinalOffset(1)
    return inst
end

local function splode()
	local inst = commonfn()

	MakeSmallBurnable(inst, 0.8+math.random()*1)
    MakeSmallPropagator(inst)

    inst:AddComponent("explosive")
    inst.components.explosive:SetOnExplodeFn(OnExplodeFn)
    inst.components.explosive:SetOnIgniteFn(OnIgniteFn)
    inst.components.explosive.explosivedamage = 200
	return inst
end

local function KeepTarget(isnt, target)
    return true
end

local function blood()
	local inst = commonfn()


    inst.AnimState:SetBank("splash")
    inst.AnimState:SetBuild("splash")
    inst.AnimState:PlayAnimation("splash")
    inst.AnimState:SetMultColour(1,0,0,1)
	inst.Transform:SetScale(1, 1, 1)

        inst:ListenForEvent("animover", function() inst:Remove() end)

	return inst
end

local function blooddrop()
	local inst = commonfn()

    inst.AnimState:SetBank("poop")
    inst.AnimState:SetBuild("warfarinblooddrop")
    inst.AnimState:PlayAnimation("dump")
    inst.AnimState:PushAnimation("idle")
    inst.AnimState:SetMultColour(1,0,0,1)
	inst:AddComponent("colourtweener")
	inst.Transform:SetScale(1, 1, 1)
    inst:DoTaskInTime(6, function() 
	inst.components.colourtweener:StartTween({0,0,0, 0}, 3)
	end)

    inst:DoTaskInTime(9, function() 
inst:Remove() end)

	return inst
end

local function DoTheGas(inst)
    local pt = inst:GetPosition()
    local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, 5)
    for k,v in pairs(ents) do

        if v and v.components.health and not v:HasTag("wall") and not v:HasTag("companion") and not v.components.health:IsDead() 
        and v ~= GetPlayer() and v.components.combat then
        	v.components.combat:GetAttacked(inst, 8)
		GetPlayer().components.health:DoDelta(2)
    	end
    end
end

local function CalcSanityAura(inst, observer)
		return -TUNING.SANITYAURA_LARGE
end

local function maskgas()
	local inst = commonfn()
    inst.AnimState:SetBank("tornado")
    inst.AnimState:SetBuild("tornado")
    inst.AnimState:PlayAnimation("tornado_pre")
    inst.AnimState:PushAnimation("tornado_loop")
    inst.AnimState:SetMultColour(0.1,0.05,0,1)
	inst.Transform:SetScale(2, 1, 2)
	inst.SoundEmitter:PlaySound("dontstarve/kingaura/aura", "gas")
			inst.SoundEmitter:SetVolume("gas",3)

inst:DoPeriodicTask(1, function()
    if not inst:HasTag("short") then
		DoTheGas(inst)
		end
		end)

inst:DoPeriodicTask(0.5, function()
	local pos = Vector3(inst.Transform:GetWorldPosition())
			pos.y = pos.y -2 + math.random()*3
			pos.x = pos.x -2 + math.random()*3
			local fart = SpawnPrefab("small_puff")
			fart.Transform:SetPosition(pos:Get()) 
			fart.Transform:SetScale(2, 2, 2)
    			fart.AnimState:SetMultColour(0.2,0.1,0,1)
		end)

    inst:DoTaskInTime(10, function() 
    inst.AnimState:PlayAnimation("tornado_pst")
        inst:ListenForEvent("animover", function() inst:Remove() end)
end)


	return inst
end

local function maskgasshort()
	local inst = maskgas()

	inst:AddTag("short")

inst:DoPeriodicTask(0.7, function()
		DoTheGas(inst)
		end)

    inst:DoTaskInTime(2.6, function() 
    inst.AnimState:PlayAnimation("tornado_pst")
        inst:ListenForEvent("animover", function() inst:Remove() end)
end)


	return inst
end

local function webtrap()
	local inst = commonfn()
	inst.Transform:SetScale(1, 1, 1)
    inst.AnimState:SetBank("bee_mine_maxwell")
    inst.AnimState:SetBuild("bee_mine_maxwell")
    inst.AnimState:PlayAnimation("explode")
		inst.entity:AddGroundCreepEntity()
    inst:DoTaskInTime(0.1, function()
        inst.SoundEmitter:PlaySound("dontstarve/common/trap_teeth_trigger")
	end)
    inst:DoTaskInTime(0.3, function()
	inst.GroundCreepEntity:SetRadius( 3 ) 
			SpawnPrefab("die_fx").Transform:SetPosition(inst:GetPosition():Get()) 
    local pt = inst:GetPosition()
    local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, 6)
    for k,v in pairs(ents) do

         if v ~= GetPlayer() and v.sg and v.sg.sg.states.hit and v.components.locomotor and not v.components.health:IsDead() and not v:HasTag("isinstasis") and not v:HasTag("companion") and
		 not (v.components.follower and v.components.follower.leader == GetPlayer()) then
            v.sg:GoToState("hit")
		v.components.locomotor.runspeed = v.components.locomotor.runspeed/9.99
		v.components.locomotor.walkspeed = v.components.locomotor.walkspeed/9.99
    v:DoTaskInTime(3, function() 
		v.components.locomotor.runspeed = v.components.locomotor.runspeed*9.99
		v.components.locomotor.walkspeed = v.components.locomotor.walkspeed*9.99
			end)
			end
		end
	end)

    inst:DoTaskInTime(4, function() 
 inst:Remove() end)

	return inst
end

local function soundboom()
	local inst = commonfn()


    inst.AnimState:SetBank("dragonfly_ring_fx")
    inst.AnimState:SetBuild("dragonfly_ring_fx")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:SetMultColour(0,0,0,1)
   inst.AnimState:SetLightOverride(1)
    inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
	inst.Transform:SetScale(1.4, 1.4, 1.4)

        inst:ListenForEvent("animover", function() inst:Remove() end)

	return inst
end

local function soundboom2()
	local inst = soundboom()


    inst.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
    inst.AnimState:SetLayer( LAYER_BACKGROUND )
    inst.AnimState:SetSortOrder( 3 )

	return inst
end

local function faithesong()
	local inst = commonfn()


    inst.AnimState:SetBank("blocker_sanity_fx")
    inst.AnimState:SetBuild("faithesong")
    inst.AnimState:PlayAnimation("lower")
	inst.Transform:SetScale(1, 1, 1)

        inst:ListenForEvent("animover", function() inst:Remove() end)

	return inst
end

local function gunfire()
	local inst = commonfn()

    inst.AnimState:SetBank("explode")
    inst.AnimState:SetBuild("explode")
    inst.AnimState:PlayAnimation("small")
    inst.AnimState:SetMultColour(1,1,1,1)
   inst.AnimState:SetLightOverride(1)
    inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
	inst.Transform:SetScale(0.2, 0.2, 0.2)

        inst.entity:AddLight()
    inst.Light:Enable(true)
    inst.Light:SetRadius(2)
    inst.Light:SetFalloff(1)
    inst.Light:SetIntensity(.9)
    inst.Light:SetColour(235/255,121/255,12/255)
    local i = .9

    local dt = 1/20
    local sound = true
    inst:DoPeriodicTask(dt, function() 
        inst.Light:SetIntensity(i)
        i =i - dt*2
    end)


        inst:ListenForEvent("animover", function() inst:Remove() end)

	return inst
end

local function stasis()
	local inst = commonfn()
    inst.AnimState:SetBank("tornado")
    inst.AnimState:SetBuild("tornado")
    inst.AnimState:PlayAnimation("tornado_pre")
    inst.AnimState:PushAnimation("tornado_loop")
    inst.AnimState:SetMultColour(0,0.0,0,0.6)
	inst.Transform:SetScale(1, 1, 1)

    inst:DoTaskInTime(3, function() 
    inst.AnimState:PlayAnimation("tornado_pst")
        inst:ListenForEvent("animover", function() inst:Remove() end)
end)


	return inst
end

local function stasisboom()
	local inst = commonfn()
    inst.AnimState:SetBank("explode")
    inst.AnimState:SetBuild("explode")
    inst.AnimState:PlayAnimation("small")
    inst.AnimState:SetMultColour(0,0,0,1)
	inst.Transform:SetScale(3, 3, 3)
        inst:ListenForEvent("animover", function() inst:Remove() end)

	return inst
end

local function bleed()
	local inst = commonfn()

    inst:AddTag("shadow")
    inst:AddTag("notarget")
    inst:AddTag("notraptrigger")

    inst:AddComponent("combat")
    inst.components.combat:SetKeepTargetFunction(KeepTarget)
    inst.components.combat:SetAttackPeriod(1000)

    inst.components.combat:SetDefaultDamage(6)
    inst.components.combat.canbeattackedfn = function() return false end
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(400)

    inst:SetStateGraph("SGshadowtentacle")

    inst:DoTaskInTime(0.1, function() 
if inst.components.combat.target then
	inst.components.combat.target:AddComponent("colourtweener")
	inst.components.combat.target.components.colourtweener:StartTween({.5,.4,.4, 1}, 1)
	end
	end)

    inst:DoTaskInTime(1, function()
if inst.components.combat.target and inst.components.combat.target.components.colourtweener then
	inst.components.combat.target.components.colourtweener:StartTween({.8,.4,.4, 1}, 1)
	end
inst:DoPeriodicTask(2, function() 
if inst.components.combat.target and inst.components.combat.target.components.colourtweener then
	inst.components.combat.target.components.colourtweener:StartTween({.8,.4,.4, 1}, 1)
   SpawnPrefab("warfarin_blooddrop").Transform:SetPosition(inst.components.combat.target:GetPosition():Get())
	end
end)
	end)

    inst:DoTaskInTime(2, function()
if inst.components.combat.target then
	inst.components.combat.target:AddComponent("colourtweener")
	inst.components.combat.target.components.colourtweener:StartTween({.5,.4,.4, 1}, 1)
	inst.components.combat.target.components.health:DoDelta(-3)
   SpawnPrefab("warfarin_blood").Transform:SetPosition(inst:GetPosition():Get())
   SpawnPrefab("warfarin_blooddrop").Transform:SetPosition(inst.components.combat.target:GetPosition():Get())
	end
	end)

    inst:DoTaskInTime(4, function() 
if inst.components.combat.target then
	inst.components.combat.target:AddComponent("colourtweener")
	inst.components.combat.target.components.colourtweener:StartTween({.5,.4,.4, 1}, 1)
	inst.components.combat.target.components.health:DoDelta(-6)
   SpawnPrefab("warfarin_blood").Transform:SetPosition(inst:GetPosition():Get())
   SpawnPrefab("warfarin_blooddrop").Transform:SetPosition(inst.components.combat.target:GetPosition():Get())
	end
	end)

    inst:DoTaskInTime(6, function() 
if inst.components.combat.target then
	inst.components.combat.target:AddComponent("colourtweener")
	inst.components.combat.target.components.colourtweener:StartTween({.5,.4,.4, 1}, 1)
	inst.components.combat.target.components.health:DoDelta(-9)
   SpawnPrefab("warfarin_blood").Transform:SetPosition(inst:GetPosition():Get())
   SpawnPrefab("warfarin_blooddrop").Transform:SetPosition(inst.components.combat.target:GetPosition():Get())
	end
	end)

    inst:DoTaskInTime(8, function()
if inst.components.combat.target then
	inst.components.combat.target:AddComponent("colourtweener")
	inst.components.combat.target.components.colourtweener:StartTween({.5,.4,.4, 1}, 1)
	inst.components.combat.target.components.health:DoDelta(-12)
   SpawnPrefab("warfarin_blood").Transform:SetPosition(inst:GetPosition():Get())
   SpawnPrefab("warfarin_blooddrop").Transform:SetPosition(inst.components.combat.target:GetPosition():Get())
	end
	end)


    inst:DoTaskInTime(10, function()
if inst.components.combat.target then
	inst.components.combat.target:AddComponent("colourtweener")
	inst.components.combat.target.components.colourtweener:StartTween({.5,.4,.4, 1}, 1)
	inst.components.combat.target.components.health:DoDelta(-15)
   SpawnPrefab("warfarin_blood").Transform:SetPosition(inst:GetPosition():Get())
   SpawnPrefab("warfarin_blooddrop").Transform:SetPosition(inst.components.combat.target:GetPosition():Get())
	end
	end)

    inst:DoTaskInTime(12, function()
if inst.components.combat.target then
	inst.components.combat.target:AddComponent("colourtweener")
	inst.components.combat.target.components.colourtweener:StartTween({.5,.4,.4, 1}, 1)
	inst.components.combat.target.components.health:DoDelta(-18)
   SpawnPrefab("warfarin_blood").Transform:SetPosition(inst:GetPosition():Get())
   SpawnPrefab("warfarin_blooddrop").Transform:SetPosition(inst.components.combat.target:GetPosition():Get())
	end
	end)

    inst:DoTaskInTime(13.1, function() 
if inst.components.combat.target and inst.components.combat.target.components.colourtweener then
	inst.components.combat.target.components.colourtweener:StartTween({1,1,1,1}, 1)
	end
	end)

    inst:DoTaskInTime(14, function() 
inst:Remove() end)
	return inst
end

return Prefab( "common/fx/warfarinsplode", splode, assets),
	Prefab( "common/fx/warfarin_blood", blood, assets),
	Prefab( "common/fx/warfarin_blooddrop", blooddrop, assets),
	Prefab( "common/fx/warfarin_gas", maskgas, assets),
	Prefab( "common/fx/warfarin_gasshort", maskgasshort, assets),
	Prefab( "common/fx/warfarin_webtrap", webtrap, assets),
	Prefab( "common/fx/warfarin_soundboom", soundboom, assets),
	Prefab( "common/fx/warfarin_soundboom2", soundboom2, assets),
	Prefab( "common/fx/warfarin_bleed", bleed, assets),
	Prefab( "common/fx/warfarin_muzzleflash", gunfire, assets),
	Prefab( "common/fx/warfarin_faithesong", faithesong, assets),
	Prefab( "common/fx/warfarin_stasis", stasis, assets),
	Prefab( "common/fx/warfarin_stasisboom", stasisboom, assets)
