local assets=
{
	Asset("ANIM", "anim/warfarin_arrows1.zip"),
	Asset("ANIM", "anim/warfarin_arrows2.zip"),
	Asset("ANIM", "anim/swap_warfarin_bow.zip"),
}
    
local prefabs =
{
}


local function commonfn()
	local inst = CreateEntity()
	local trans = inst .entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
    
    inst:AddTag("bow")
    inst:AddTag("wararrow")
    inst:AddTag("warwep")

    return inst
end

local function normal()
	local inst = commonfn()
    
    inst.AnimState:SetBank("blow_dart")
    inst.AnimState:SetBuild("warfarin_arrows1")
    inst.AnimState:PlayAnimation("idle_pipe")
    
	inst.Transform:SetScale(1.2, 1.2, 1.2)


    inst:AddTag("normbow")
    inst:AddTag("sharp")

    inst:AddComponent("inspectable")
    
    inst:AddComponent("stackable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/warfarinarrow_normal.xml"
    
	return inst
end

---------------------------------------------------------------------

local function rock()
	local inst = commonfn()
    
    inst.AnimState:SetBank("blow_dart")
    inst.AnimState:SetBuild("warfarin_arrows1")
    inst.AnimState:PlayAnimation("idle_purple")
    inst.AnimState:SetRayTestOnBB(true);
    
	inst.Transform:SetScale(1.2, 1.2, 1.2)

    inst:AddTag("rockbow")
    

    inst:AddComponent("inspectable")
    
    inst:AddComponent("stackable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/warfarinarrow_rock.xml"

	return inst
end

-------------------------------------------------------

local function water()
	local inst = commonfn()
	if IsDLCEnabled(REIGN_OF_GIANTS) then
    
    inst.AnimState:SetBank("blow_dart")
    inst.AnimState:SetBuild("warfarin_arrows1")
     inst.AnimState:PlayAnimation("idle_red")
    inst.AnimState:SetRayTestOnBB(true);
    
	inst.Transform:SetScale(1.2, 1.2, 1.2)


    inst:AddTag("waterbow")
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("stackable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/warfarinarrow_water.xml"

		end
	return inst
end

-------------------------------------------------

local function explo()
	local inst = commonfn()
    
    inst.AnimState:SetBank("blow_dart")
    inst.AnimState:SetBuild("warfarin_arrows2")
    inst.AnimState:PlayAnimation("idle_red")
    inst.AnimState:SetRayTestOnBB(true);
    
	inst.Transform:SetScale(1.2, 1.2, 1.2)

    inst:AddTag("normbow")

    inst:AddComponent("inspectable")
    
    inst:AddComponent("stackable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/warfarinarrow_fire.xml"

	return inst
end

------------------------
local function sharp()
	local inst = commonfn()
    
    inst.AnimState:SetBank("blow_dart")
    inst.AnimState:SetBuild("warfarin_arrows2")
    inst.AnimState:PlayAnimation("idle_pipe")
    inst.AnimState:SetRayTestOnBB(true);
    
	inst.Transform:SetScale(1.2, 1.2, 1.2)

    inst:AddTag("normbow")
    inst:AddTag("sharp")

    inst:AddComponent("inspectable")
    
    inst:AddComponent("stackable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/warfarinarrow_spike.xml"
    

	return inst
end

return Prefab( "common/inventory/warfarinarrow_normal", normal, assets), 
	Prefab( "common/inventory/warfarinarrow_rock", rock, assets),
	Prefab( "common/inventory/warfarinarrow_fire", explo, assets),
	Prefab( "common/inventory/warfarinarrow_spike", sharp, assets),
	Prefab( "common/inventory/warfarinarrow_water", water, assets)  
