local assets=
{
	Asset("ANIM", "anim/warfarin_arrows1.zip"),
	Asset("ANIM", "anim/warfarin_arrows2.zip"),
	Asset("ANIM", "anim/warfarin_arrows2.zip"),
	Asset("ANIM", "anim/liar_Arrow.zip"),
	Asset("ANIM", "anim/warfaringrenade.zip"),
}

local survivechance = 0.15

local function OnHit(inst, owner, target)
    local impactfx = SpawnPrefab("impact")
    if impactfx then
	    local follower = impactfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
        impactfx:FacePoint(inst.Transform:GetWorldPosition())
    end
    if target.components.combat then
    if target.components.health then
		target.components.health:DoDelta(-100)
		end
        target.components.combat:SuggestTarget(GetPlayer())
        if target.sg and target.sg.sg.states.hit and not target.components.health:IsDead() then
            target.sg:GoToState("hit")
        end
    end
   if math.random() < survivechance then
    local arrow = SpawnPrefab("warfarinarrow_normal")
	if not target.components.health:IsDead() then
	if target.components.inventory then
	target.components.inventory:GiveItem(arrow)
		else
	target:AddComponent("inventory")
	target.components.inventory:GiveItem(arrow)
		end
		else
		arrow.Transform:SetPosition(inst:GetPosition():Get())
		end
	end
	inst:Remove()
end

----------------------------------------------------------------------

local function OnHitrock(inst, owner, target)
    local impactfx = SpawnPrefab("impact")
    if impactfx then
	    local follower = impactfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
        impactfx:FacePoint(inst.Transform:GetWorldPosition())
    end
    if target.components.combat then
    if target.components.health then
		target.components.health:DoDelta(-20)
		end
        target.components.combat:SuggestTarget(GetPlayer())
        if target.sg and target.sg.sg.states.hit and not target.components.health:IsDead() then
            target.sg:GoToState("hit")
        end
    end
    if target:HasTag("wall") then
	local pt = Vector3(inst.Transform:GetWorldPosition())
	local ents = TheSim:FindEntities(pt.x,pt.y,pt.z, TUNING.LEIF_REAWAKEN_RADIUS, {"monster"})
	for k,v in pairs(ents) do

		v.components.combat:SuggestTarget(target)
	end
	local pt = Vector3(inst.Transform:GetWorldPosition())
	local ents = TheSim:FindEntities(pt.x,pt.y,pt.z, TUNING.LEIF_REAWAKEN_RADIUS, {"wallerhit"})
	for k,v in pairs(ents) do

		v.components.combat:SuggestTarget(target)
	end
	end
    if target:HasTag("haywall") then
        inst.SoundEmitter:PlaySound("dontstarve/common/destroy_straw")
    elseif target:HasTag("woodwall") then
        inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
    elseif target:HasTag("stonewall") then
        inst.SoundEmitter:PlaySound("dontstarve/common/destroy_stone")
    elseif target:HasTag("ruinswall") then
        inst.SoundEmitter:PlaySound("dontstarve/common/destroy_metal")
	end
	inst:Remove()
end


------------------------------------------------------

local function OnHitwater(inst, owner, target)
if IsDLCEnabled(REIGN_OF_GIANTS) then
    if target.components.burnable then
        if target.components.burnable:IsBurning() then
            target.components.burnable:Extinguish()
        elseif target.components.burnable:IsSmoldering() then
            target.components.burnable:SmotherSmolder()
        end
    end
    if target.components.combat then
    if target.components.health then
		if target:HasTag("dragonfly") then
        target.components.combat:SuggestTarget(GetPlayer())
		target.components.health:DoDelta(-150)
		else
		target.components.health:DoDelta(-1)
			end
		end
        if target.sg and target.sg.sg.states.hit and not target.components.health:IsDead() then
            target.sg:GoToState("hit")
        end
    end
	if target.components.combat then
    local impactfx = SpawnPrefab("splash_ocean")
	    local follower = impactfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
        impactfx:FacePoint(inst.Transform:GetWorldPosition())
else
                    SpawnPrefab("splash_ocean").Transform:SetPosition(inst:GetPosition():Get())
	end
	inst:Remove()
	end
end

-------------------------------------------------

local function OnHitex(inst, owner, target)
    local impactfx = SpawnPrefab("warfarinsplode")
    if impactfx then
	    local follower = impactfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
        impactfx:FacePoint(inst.Transform:GetWorldPosition())
            impactfx.components.burnable:Ignite(true)
	end
    if target.components.combat then
    if target.components.health then
		target.components.health:DoDelta(-85)
		end
        target.components.combat:SuggestTarget(GetPlayer())
        if target.sg and target.sg.sg.states.hit and not target.components.health:IsDead() then
            target.sg:GoToState("hit")
        end
    end
    if target.components.burnable then   
            target.components.burnable:Ignite(true)
    end
	inst:Remove()
end

------------------------

local function OnHitspike(inst, owner, target)
    local impactfx = SpawnPrefab("impact")
    if impactfx then
	    local follower = impactfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
        impactfx:FacePoint(inst.Transform:GetWorldPosition())
    end
	GetPlayer().components.kramped:OnNaughtyAction(2)
    if target.components.combat then
        target.components.combat:SuggestTarget(GetPlayer())
    if target.components.health then
		target.components.health:DoDelta(-160)
		end
        if target.sg and target.sg.sg.states.hit and not target.components.health:IsDead() then
            target.sg:GoToState("hit")
        end
    end
    local blood = SpawnPrefab("warfarin_bleed")
	    local follower = blood.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
        blood:FacePoint(inst.Transform:GetWorldPosition())
	blood.components.combat:SetTarget(target)
	inst:Remove()
end


------

local function common()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
        inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
    RemovePhysicsColliders(inst)
    
    inst.AnimState:SetBank("blow_dart")
    inst.AnimState:SetBuild("warfarin_arrows1")
    inst.AnimState:PlayAnimation("dart_pipe")
    inst.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
	inst.Transform:SetScale(1.4, 1.4, 1.4)
    
    inst:AddTag("projectile")
    
    inst:AddComponent("projectile")
        inst.components.projectile:SetSpeed(47)
    inst.components.projectile:SetOnHitFn(OnHit)

    return inst
end

local function normal()
    local inst = common()

    inst.AnimState:SetBank("blow_dart")
    inst.AnimState:PlayAnimation("dart_pipe")

    inst.components.projectile:SetSpeed(47)
    inst.components.projectile:SetOnHitFn(OnHit)

    return inst
end

local function rock()
    local inst = common()

    inst.AnimState:PlayAnimation("dart_purple")

    inst.components.projectile:SetSpeed(30)
    inst.components.projectile:SetOnHitFn(OnHitrock)

    return inst
end

local function water()
    local inst = common()
    inst.AnimState:PlayAnimation("dart_red")

    inst.components.projectile:SetOnHitFn(OnHitwater)

    return inst
end
local burnchance = 0.2

local function fire()
    local inst = common()
    inst.AnimState:SetBuild("warfarin_arrows2")
    inst.AnimState:PlayAnimation("dart_red")
	inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
    inst.components.projectile:SetSpeed(30)
    --inst.components.projectile:SetOnThrownFn(OnThrownex)
    inst.components.projectile:SetOnHitFn(OnHitex)

    if math.random() < burnchance then
                    SpawnPrefab("explode_small").Transform:SetPosition(inst:GetPosition():Get())
	inst.SoundEmitter:PlaySound("dontstarve/common/powderkeg_explo")
			inst.SoundEmitter:PlaySound("dontstarve/characters/warfarin/hurt")
        GetPlayer().components.health:DoFireDamage(2, nil, true)
        GetPlayer():PushEvent("burnt")
		end
    return inst
end

local function spike()
    local inst = common()
    inst.AnimState:SetBuild("warfarin_arrows2")
    inst.AnimState:PlayAnimation("dart_pipe")

    inst.components.projectile:SetSpeed(30)
    inst.components.projectile:SetOnHitFn(OnHitspike)
    return inst
end

local function BigBoom(inst)
    local pt = inst:GetPosition()
    local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, 5)
    for k,v in pairs(ents) do

        if v and v.components.health and not v.components.health:IsDead() 
        and v ~= GetPlayer() and v.components.combat then
        	v.components.combat:GetAttacked(inst, inst.damage)
		SpawnPrefab("statue_transition").Transform:SetPosition(v:GetPosition():Get())
		SpawnPrefab("statue_transition_2").Transform:SetPosition(v:GetPosition():Get())
                v.SoundEmitter:PlaySound("dontstarve/common/meteor_impact")
    	end
    end
                inst.SoundEmitter:PlaySound("dontstarve/wilson/use_gemstaff")
                local bewm = SpawnPrefab("warfarin_soundboom")
		SpawnPrefab("warfarin_soundboom").Transform:SetPosition(inst:GetPosition():Get())
		SpawnPrefab("warfarin_soundboom2").Transform:SetPosition(inst:GetPosition():Get())
end

local function Syphon(inst)
		    local trail = SpawnPrefab("statue_transition_2")
	    local follower = trail.entity:AddFollower()
    follower:FollowSymbol( inst.GUID, "liararrow", 0, 0, 0 )
	inst.SoundEmitter:PlaySound("dontstarve/common/meteor_spawn")
    local pt = inst:GetPosition()
    local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, 4)
    for k,v in pairs(ents) do

        if v and v.components.health and not v:HasTag("wall") and not v:HasTag("donotsyphon") and not v.components.health:IsDead() 
        and v ~= GetPlayer() and v.components.combat then
        	v.components.combat:GetAttacked(inst, 10)
		inst.damage = inst.damage + 25
	v:AddTag("donotsyphon")
		SpawnPrefab("statue_transition").Transform:SetPosition(v:GetPosition():Get())
	GetPlayer().components.sanity:DoDelta(-1)
    	end
    end
end

local function OnHitLiar(inst, owner, target)
		if inst.damage >= 220 then
	BigBoom(inst)
	else
    local impactfx = SpawnPrefab("impact")
    if impactfx then
	    local follower = impactfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
        impactfx:FacePoint(inst.Transform:GetWorldPosition())
    end
    if target.components.combat then
        target.components.combat:SuggestTarget(GetPlayer())
    if target.components.health then
		target.components.health:DoDelta(-inst.damage)
		SpawnPrefab("statue_transition").Transform:SetPosition(target:GetPosition():Get())
		SpawnPrefab("statue_transition_2").Transform:SetPosition(target:GetPosition():Get())

		end
        if target.sg and target.sg.sg.states.hit and not target.components.health:IsDead() then
            target.sg:GoToState("hit")
        end
    end
end
	target:RemoveTag("donotsyphon")
	local pt = Vector3(inst.Transform:GetWorldPosition())
    local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, 50, {"donotsyphon"})
    for k,v in pairs(ents) do
		v:RemoveTag("donotsyphon")
	end
	inst:Remove()
end

local function liar()
    local inst = common()
	inst.damage = 100
    inst.AnimState:SetBank("liar_arrow")
    inst.AnimState:SetBuild("liar_arrow")
    inst.AnimState:PlayAnimation("fly", true)
	inst.Transform:SetScale(1, 1, 1)
inst:DoPeriodicTask(0.3, function()
		Syphon(inst)
		end)

    inst.components.projectile:SetSpeed(20)
    inst.components.projectile:SetOnHitFn(OnHitLiar)
    return inst
end

local function OnHitB(inst, owner, target)
    local impactfx = SpawnPrefab("impact")
    if impactfx then
	    local follower = impactfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
        impactfx:FacePoint(inst.Transform:GetWorldPosition())
    end
    if target.components.combat then
        target.components.combat:SuggestTarget(GetPlayer())
    if target.components.health then
		if target:HasTag("isinstasis") then
        	target.components.combat:GetAttacked(inst, 100)
			else
        	target.components.combat:GetAttacked(inst, 60)
			end
        end
    end
    inst:Remove()
end

local function bullet()
    local inst = common()
    inst.AnimState:SetBank("projectile")
    inst.AnimState:SetBuild("staff_projectile")
    inst.AnimState:PlayAnimation("ice_spin_loop", true)
    inst.Transform:SetScale(0.1, 0.1, 0.1)
    inst.components.projectile:SetSpeed(1000)

    inst.components.projectile:SetOnHitFn(OnHitB)
    return inst
end

local function Stasis(inst)
    local pt = inst:GetPosition()
    local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, 6)
    for k,v in pairs(ents) do
        if v and v.components.health and not v:HasTag("wall") and not v:HasTag("isinstasis") and not v:HasTag("epic") and not v.components.health:IsDead() 
        and v ~= GetPlayer() and v.sg then
	if v:HasTag("faithe") then
		v.components.health:DoDelta(100)
        v.sg:GoToState "sing"
		else
        v.sg:GoToState "hit"
                	v.Physics:Stop()
        v.sg:Stop()
		v:AddTag("isinstasis")
		SpawnPrefab("statue_transition").Transform:SetPosition(v:GetPosition():Get())
            inst.SoundEmitter:PlaySound("dontstarve/common/freezecreature")
		SpawnPrefab("warfarin_stasis").Transform:SetPosition(v:GetPosition():Get())
if v.components.follower and v.components.follower.leader == GetPlayer() then
            v.components.health:SetInvincible(true)
		end
	v:DoTaskInTime(0.15, function() 
		v.AnimState:Pause()
	end)
	v:DoTaskInTime(3, function() 
		v.SoundEmitter:PlaySound("dontstarve/common/teleportato/teleportato_under")
		SpawnPrefab("warfarin_soundboom2").Transform:SetPosition(v:GetPosition():Get())
                	v.Physics:Stop()
        v.sg:Start()
	v.AnimState:Resume()
	if v.components.health:IsDead() then
            v.sg:GoToState("death")
		else
            v.sg:GoToState("hit")
    if v.components.combat then
if not (v.components.follower and v.components.follower.leader == GetPlayer()) then
        v.components.combat:SuggestTarget(GetPlayer())
		end
            v.components.health:SetInvincible(false)
	v:RemoveTag("isinstasis")

			end
		end
			end)
		end
    	end
    end
		SpawnPrefab("warfarin_soundboom2").Transform:SetPosition(inst:GetPosition():Get())
		SpawnPrefab("warfarin_stasisboom").Transform:SetPosition(inst:GetPosition():Get())
		inst.SoundEmitter:PlaySound("dontstarve/charlie/attack")
		inst.SoundEmitter:PlaySound("dontstarve/common/teleportato/teleportato_pulled")
    inst:Remove()
end

local function grenade()
    local inst = common()  
    inst.AnimState:SetBank("warfaringrenade")
    inst.AnimState:SetBuild("warfaringrenade")  
    inst.Transform:SetScale(1, 1, 1)
    inst.AnimState:PlayAnimation("grenade", true)
    inst.AnimState:SetOrientation( ANIM_ORIENTATION.Default )
	inst:RemoveComponent("projectile")
	inst:AddComponent("complexprojectile")
	inst.components.complexprojectile:SetOnHit(Stasis)
	--inst.components.complexprojectile.hoizontalSpeed = 9000
	inst.components.complexprojectile.yOffset = 0.6
	inst.components.complexprojectile.maxRange = 30
	inst.components.complexprojectile.gravity = -6.81
    return inst
end

return 
Prefab( "common/inventory/warfarinbow_projectile", normal, assets), 
       Prefab("common/inventory/warfarinbow_projectile_rock", rock, assets), 
       Prefab("common/inventory/warfarinbow_projectile_water", water, assets), 
       Prefab("common/inventory/warfarinbow_projectile_fire", fire, assets), 
       Prefab("common/inventory/warfarinbow_projectile_spike", spike, assets),
       Prefab("common/inventory/warfarinbow_projectile_liar", liar, assets),
       Prefab("common/inventory/warfarinbullet", bullet, assets),
       Prefab("common/inventory/warfaringrenade", grenade, assets)
