
local MakePlayerCharacter = require "prefabs/player_common"
local assets = {
        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wendy.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/wei.zip" ), --character anim
}
local prefabs = { "beardhair","sparks","spear_wathgrithr","sakura_ghost_flower"	
	 } --no special items in mod

local start_inv = 
{
		"ss",	
	"bb",
	"sakura_ghost_flower",
	"meat",
--starts with fishing rod
}

local function updatestats(inst)

    if GetClock():IsDusk() then
		 local names = {"wilson","wendy","wes","wickerbottom","willow","wolfgang","wx78"}
    inst.animname = names[math.random(#names)]
  inst.AnimState:SetBuild(inst.animname)
    SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
    



		
		
	end
	end







local function dorainsparks(inst, dt)

    if (inst.components.moisture and inst.components.moisture:GetMoisture() > 0) then
    	inst.spark_time = inst.spark_time - dt

    	if inst.spark_time <= 0 then
    		
    		--GetClock():DoLightningLighting()
    		inst.spark_time = 3+math.random()*2

    		local pos = Vector3(inst.Transform:GetWorldPosition())
    		local damage = nil

    		-- Raining, no moisture-giving equipment on head, and moisture is increasing. Pro-rate damage based on waterproofness.
    		if GetSeasonManager():IsRaining() and inst.components.inventory:GetEquippedMoistureRate(EQUIPSLOTS.HEAD) <= 0 and inst.components.moisture:GetDelta() > 0 then
	    		local waterproofmult = (inst.components.moisture and inst.components.moisture.sheltered and inst.components.inventory) and (1 - (inst.components.inventory:GetWaterproofness() + inst.components.moisture.shelter_waterproofness)) or (inst.components.inventory and (1 - inst.components.inventory:GetWaterproofness()) or 1)
	    		damage = waterproofmult > 0 and math.min(TUNING.WX78_MIN_MOISTURE_DAMAGE, TUNING.WX78_MAX_MOISTURE_DAMAGE * waterproofmult) or 0
	    		inst.components.health:DoDelta(damage, false, "rain")
				pos.y = pos.y + 1 + math.random()*1.5
	    	else -- We have moisture-giving equipment on our head or it is not raining and we are just passively wet (but drying off). Do full damage.
	    		if inst.components.moisture:GetDelta() >= 0 then -- Moisture increasing (wearing something moisturizing)
	    			inst.components.health:DoDelta(TUNING.WX78_MAX_MOISTURE_DAMAGE, false, "water")
	    		else -- Drying damage
	    			inst.components.health:DoDelta(TUNING.WX78_MOISTURE_DRYING_DAMAGE, false, "water")
	    		end
				pos.y = pos.y + .25 + math.random()*2
	    	end
			
			if not damage or (damage and damage < 0) then
				local spark = SpawnPrefab("sparks")
				spark.Transform:SetPosition(pos:Get())
			end
    	end
    end

end

local fn = function(inst)
inst:RemoveTag("poisonable")
	inst.components.health.vulnerabletopoisondamage = false
	inst.components.health.poison_damage_scale = 0
inst.components.eater.ignoresspoilage = true
inst.components.talker.special_speech = true
 inst.components.eater:SetCarnivore(true)
    inst.components.combat:AddDamageModifier("wendy", TUNING.WENDY_DAMAGE_MULT)
inst.components.combat.damagemultiplier = 0.75

inst.components.health.fire_damage_scale = 0.5

	inst:AddTag("monster")	


inst.components.builder.science_bonus = 1
inst:AddTag("insomniac")
         inst.spark_time = 3
inst:DoPeriodicTask(1/10, function() dorainsparks(inst, 1/10) end)
	inst.soundsname = "wendy"
	inst.MiniMapEntity:SetIcon( "wei.tex" )
	
	inst.components.health:SetMaxHealth(75)
	inst.components.hunger:SetMax(120)
	inst.components.sanity:SetMax(100)
	inst.components.locomotor.walkspeed = 6
	inst.components.locomotor.runspeed = 7	

 inst:AddComponent("beard")
    inst.components.beard.onreset = function()
        inst.AnimState:ClearOverrideSymbol("beard")
    end
    inst.components.beard.prize = "beardhair"
    
    --tune the beard economy...
	local beard_days = {4, 8, 16}
	local beard_bits = {1, 3,  9}
    
    inst.components.beard:AddCallback(beard_days[1], function()
        inst.AnimState:OverrideSymbol("beard", "beard", "beard_short")
        inst.components.beard.bits = beard_bits[1]
    end)
    
    inst.components.beard:AddCallback(beard_days[2], function()
        inst.AnimState:OverrideSymbol("beard", "beard", "beard_medium")
        inst.components.beard.bits = beard_bits[2]
    end)
    
    inst.components.beard:AddCallback(beard_days[3], function()
        inst.AnimState:OverrideSymbol("beard", "beard", "beard_long")
        inst.components.beard.bits = beard_bits[3]
    end)

        
     
        inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE)


        inst:ListenForEvent( "dusktime", function() updatestats(inst) end , GetWorld())

	
	updatestats(inst)
     
	
end

return MakePlayerCharacter("wei", prefabs, assets, fn, start_inv)