    local assets =
{
    Asset("ANIM", "anim/loongytorch.zip"),
    Asset("SOUND", "sound/common.fsb"),
}

    local prefabs = 
{
    "tikitorchflame",
}

local function onhammered(inst, worker)
    inst.components.lootdropper:DropLoot()
    SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
    inst:Remove()
    inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
end	

local function onhit(inst,worker)
  inst.AnimState:PlayAnimation("hit")
  inst.AnimState:PushAnimation("idle", true)
end

local function updateloongytorch(inst)
    if not inst.components.burnable:IsBurning() then
    inst.components.burnable:Ignite()
    inst.components.burnable:SetFXLevel(3)
    end
end

local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()

    anim:SetBank("loongytorch")
    anim:SetBuild("loongytorch")
    anim:PlayAnimation("idle", true)
    inst:AddTag("campfire")
       
    local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon( "loongytorch.tex" )

    MakeObstaclePhysics(inst, 0.33)

    inst:AddComponent("inspectable")

    inst:AddComponent("cooker")

    inst:AddComponent("burnable")
    inst.components.burnable:AddBurnFX("loongytorchflame", Vector3(0,-350, 0), "fire_marker")

    inst:AddComponent("sanityaura")
    inst.components.sanityaura.aura = TUNING.SANITYAURA_SMALL
       
    inst:AddTag("structure")
    inst:AddTag("FX")

    inst:AddComponent("lootdropper")

    inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(4)
    inst.components.workable:SetOnFinishCallback(onhammered)
    inst.components.workable:SetOnWorkCallback(onhit)

    inst:DoPeriodicTask(1, function() updateloongytorch(inst) 
end)
    return inst
end

return Prefab( "common/loongytorch", fn, assets, prefabs),
     MakePlacer("common/loongytorch_placer", "loongytorch", "loongytorch", "idle")