local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local STRINGS = GLOBAL.STRINGS
local Recipe = GLOBAL.Recipe
local require = GLOBAL.require
local SpawnPrefab = GLOBAL.SpawnPrefab
local ACTIONS = GLOBAL.ACTIONS
local Action = GLOBAL.Action
local TECH = GLOBAL.TECH
local GetPlayer = GLOBAL.GetPlayer
local Vector3 = GLOBAL.Vector3
local resolvefilepath = GLOBAL.resolvefilepath

PrefabFiles = {
	"kula",
	"lf",
	"qmb",
	"yyy",
	"ground_l_breaking",
}

STRINGS.NAMES.LF = "御币"
STRINGS.RECIPE_DESC.LF = "抗妖纸片。"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.LF = "你可以拍十万？" 

STRINGS.NAMES.YYY = "阴阳玉"
STRINGS.RECIPE_DESC.YYY = "灵梦的信仰。"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.YYY = "它可以卖几千。" 

STRINGS.NAMES.QMB = "驱魔杖"
STRINGS.RECIPE_DESC.QMB = "一个祝福杆。"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.QMB = "不要用它来抓你的背。" 

-- strings! Any "kula" below would have to be replaced by the prefab name of your character.

-- First up, the character select screen lines 
-- note: these are lower-case character name
STRINGS.CHARACTER_TITLES.kula = "乐芙兰"
STRINGS.CHARACTER_NAMES.kula = "乐芙兰"
STRINGS.CHARACTER_DESCRIPTIONS.kula = "*传送术\n*形态切换\n*升级解锁科技与技能"
STRINGS.CHARACTER_QUOTES.kula = "\"我将尽我所能\""

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name
STRINGS.CHARACTERS.kula = {}

STRINGS.CHARACTERS.kula.ANNOUNCE_BOOMERANG  = "无聊儿童玩具."
STRINGS.CHARACTERS.kula.ANNOUNCE_CHARLIE  = "我看不见?"
STRINGS.CHARACTERS.kula.ANNOUNCE_CHARLIE_ATTACK = "不要乱摸!"

STRINGS.CHARACTERS.kula.ANNOUNCE_COLD  = "我很冷."
STRINGS.CHARACTERS.kula.ANNOUNCE_CRAFTING_FAIL  = "我不可以?"
STRINGS.CHARACTERS.kula.ANNOUNCE_DUSK = "我想回家."
STRINGS.CHARACTERS.kula.ANNOUNCE_HUNGRY  = "我现在想吃点东西."
STRINGS.CHARACTERS.kula.ANNOUNCE_HUNT_BEAST_NEARBY = "是你. "
STRINGS.CHARACTERS.kula.ANNOUNCE_HUNT_LOST_TRAIL  = "我现在去哪里?"
STRINGS.CHARACTERS.kula.ANNOUNCE_INV_FULL  = "它不适合. "
STRINGS.CHARACTERS.kula.ANNOUNCE_KNOCKEDOUT  = "哦... "
STRINGS.CHARACTERS.kula.ANNOUNCE_NODANGERSLEEP  = "周围有妖怪."
STRINGS.CHARACTERS.kula.ANNOUNCE_NOHUNGERSLEEP  = "我应该先吃."
STRINGS.CHARACTERS.kula.ANNOUNCE_NODAYSLEEP  = "忘记做白日梦!"
STRINGS.CHARACTERS.kula.ANNOUNCE_NO_TRAP  = "哈哈. "
STRINGS.CHARACTERS.kula.ANNOUNCE_PECKED  = "不要寻求死亡! "
STRINGS.CHARACTERS.kula.ANNOUNCE_QUAKE = " 这可能是天使做的. "
STRINGS.CHARACTERS.kula.ANNOUNCE_RESEARCH  = "我学到了一些新东西. "
STRINGS.CHARACTERS.kula.ANNOUNCE_TORCH_OUT  = "呵呵?"
STRINGS.CHARACTERS.kula.ANNOUNCE_WORMHOLE  = "那里有粘性的液体."

STRINGS.CHARACTERS.kula.ANNOUNCE_EAT = {}
STRINGS.CHARACTERS.kula.ANNOUNCE_EAT.GENERIC  = "难吃."
STRINGS.CHARACTERS.kula.ANNOUNCE_EAT.PAINFULL = "吃点正常的，好的?"
STRINGS.CHARACTERS.kula.ANNOUNCE_EAT.SPOILED = "我很快就把它吐出来!"
STRINGS.CHARACTERS.kula.ANNOUNCE_EAT.STALE  = "它开始变坏."

STRINGS.CHARACTERS.kula.BATTLECRY = {}
STRINGS.CHARACTERS.kula.BATTLECRY.GENERIC  = "打破它!"
STRINGS.CHARACTERS.kula.BATTLECRY.PIG = "我喜欢猪肉."
STRINGS.CHARACTERS.kula.BATTLECRY.PREY  = "不要以为我这么做只是因为你很小. "
STRINGS.CHARACTERS.kula.BATTLECRY.SPIDER  = "蜘蛛妖怪!"
STRINGS.CHARACTERS.kula.BATTLECRY.SPIDER_WARRIOR  = "你是一个比较麻烦的类别."
STRINGS.CHARACTERS.kula.BATTLECRY.HOUND  = "猪妖!"
STRINGS.CHARACTERS.kula.BATTLECRY.LEIF  = "这是一个精灵?"

-- Description
STRINGS.CHARACTERS.kula.DESCRIBE = {}
STRINGS.CHARACTERS.kula.DESCRIBE.ROBIN = "春天不是很好."
STRINGS.CHARACTERS.kula.DESCRIBE.SLURPER  = "我如何驱散它?"
STRINGS.CHARACTERS.kula.DESCRIBE.ORANGEAMULET  = "玛丽莎会更感兴趣."
STRINGS.CHARACTERS.kula.DESCRIBE.YELLOWSTAFF  = "玛丽莎会更感兴趣."
STRINGS.CHARACTERS.kula.DESCRIBE.YELLOWGEM  = "黄玉价值十万日元? "
STRINGS.CHARACTERS.kula.DESCRIBE.ORANGEGEM  = "价值十万日元的橙色宝石?"
STRINGS.CHARACTERS.kula.DESCRIBE.STAFFLIGHT  = "阴阳球不吸引它"
STRINGS.CHARACTERS.kula.DESCRIBE.ANCIENT_ALTAR  = "它让我想起…"
STRINGS.CHARACTERS.kula.DESCRIBE.CAVE_BANANA  = "它看起来像正常的香蕉。"
STRINGS.CHARACTERS.kula.DESCRIBE.ROCKY  = "那是什么?"
STRINGS.CHARACTERS.kula.DESCRIBE.EVERGREEN = "我希望这不是一个令人讨厌的怪物."

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/kula.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/kula.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/kula.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/kula.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/kula_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/kula_silho.xml" ),

    Asset( "IMAGE", "bigportraits/kula.tex" ),
    Asset( "ATLAS", "bigportraits/kula.xml" ),

    Asset( "IMAGE", "images/kula1.tex"),
    Asset( "ATLAS", "images/kula1.xml"),

    Asset( "IMAGE", "images/kulatab.tex"),
    Asset( "ATLAS", "images/kulatab.xml"),

    Asset( "IMAGE", "images/inventoryimages/lf.tex"),
    Asset( "ATLAS", "images/inventoryimages/lf.xml"),

    Asset( "IMAGE", "images/inventoryimages/qmb.tex"),
    Asset( "ATLAS", "images/inventoryimages/qmb.xml"),

    Asset( "IMAGE", "images/inventoryimages/yyy.tex"),
    Asset( "ATLAS", "images/inventoryimages/yyy.xml"),

    Asset( "IMAGE", "images/avatars/avatar_kula.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_kula.xml" ),
    
    Asset( "IMAGE", "images/avatars/avatar_ghost_kula.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_kula.xml" ),
    	Asset("SOUNDPACKAGE", "sound/zg_ch_willow.fev"),
    Asset("SOUND", "sound/zg_ch_willow.fsb"),
	Asset("SOUNDPACKAGE", "sound/zg_player_willow.fev"),
    Asset("SOUND", "sound/zg_player_willow.fsb"),

    	Asset("SOUNDPACKAGE", "sound/zg_ch1_luffy.fev"),
    Asset("SOUND", "sound/zg_ch1_luffy.fsb"),
    	--老奶奶
	Asset("SOUNDPACKAGE", "sound/zg_player_wickerbottom.fev"),
    Asset("SOUND", "sound/zg_player_wickerbottom.fsb"),
    --巫婆
	Asset("SOUNDPACKAGE", "sound/zg_ch_wicker.fev"),
    Asset("SOUND", "sound/zg_ch_wicker.fsb"),

    	--温蒂
	Asset("SOUNDPACKAGE", "sound/zg_player_wendy.fev"),
    Asset("SOUND", "sound/zg_player_wendy.fsb"),
    	--女武神
	Asset("SOUNDPACKAGE", "sound/zg_ch_wigfrid.fev"),
    Asset("SOUND", "sound/zg_ch_wigfrid.fsb"),
}

--温蒂
RemapSoundEvent( "dontstarve/zg/wendy/call", "zg_ch_wendy/zg_ch_wendy/call" )
RemapSoundEvent( "dontstarve/zg/wendy/hit", "zg_ch_wendy/zg_ch_wendy/hit" )
RemapSoundEvent( "dontstarve/zg/wendy/die", "zg_ch_wendy/zg_ch_wendy/die" )
RemapSoundEvent( "dontstarve/zg/wendy/atk", "zg_ch_wendy/zg_ch_wendy/atk" )

RemapSoundEvent( "dontstarve/zg/wigfrid/call", "zg_ch_wigfrid/zg_ch_wigfrid/call" )
RemapSoundEvent( "dontstarve/zg/wigfrid/hit", "zg_ch_wigfrid/zg_ch_wigfrid/hit" )

RemapSoundEvent( "dontstarve/zg/willow/call", "zg_ch_willow/zg_ch_willow/call" )
RemapSoundEvent( "dontstarve/zg/willow/hit", "zg_ch_willow/zg_ch_willow/hit" )
RemapSoundEvent( "dontstarve/zg/willow/die", "zg_ch_willow/zg_ch_willow/die" )
RemapSoundEvent( "dontstarve/zg/willow/pound", "zg_ch_willow/zg_ch_willow/pound" )
RemapSoundEvent( "dontstarve/zg/willow/fireatk", "zg_ch_willow/zg_ch_willow/fireatk" )

RemapSoundEvent( "dontstarve/zg/ch_luffy/call", "zg_ch1_luffy/zg_ch1_luffy/call" )
RemapSoundEvent( "dontstarve/zg/ch_luffy/hit", "zg_ch1_luffy/zg_ch1_luffy/hit" )


RemapSoundEvent( "dontstarve/zg/wicker/call", "zg_ch_wicker/zg_ch_wicker/call" )
RemapSoundEvent( "dontstarve/zg/wicker/hit", "zg_ch_wicker/zg_ch_wicker/hit" )
RemapSoundEvent( "dontstarve/zg/wicker/die", "zg_ch_wicker/zg_ch_wicker/die" )
RemapSoundEvent( "dontstarve/zg/wicker/ice", "zg_ch_wicker/zg_ch_wicker/ice" )
RemapSoundEvent( "dontstarve/zg/wicker/shoot", "zg_ch_wicker/zg_ch_wicker/shoot" )
RemapSoundEvent( "dontstarve/zg/wicker/call2", "zg_ch_wicker/zg_ch_wicker/call2" )

local CUSTOM_RECIPETABS = GLOBAL.CUSTOM_RECIPETABS
CUSTOM_RECIPETABS.kulaTABS = { str = "kulaTABS", sort = 999, icon = "kulatab.tex", icon_atlas = resolvefilepath("images/kulatab.xml") }
STRINGS.TABS.kulaTABS = "Spiritual Power"

	local lf = Recipe("lf", {Ingredient("papyrus", 1), Ingredient("nitre", 1)}, CUSTOM_RECIPETABS.kulaTABS, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0}, nil, nil, nil, 3)
	lf.atlas = "images/inventoryimages/lf.xml"
	local qmb = Recipe("qmb", {Ingredient("twigs", 2), Ingredient("rope", 1), Ingredient("papyrus", 1)}, CUSTOM_RECIPETABS.kulaTABS, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
	qmb.atlas = "images/inventoryimages/qmb.xml"
	local yyy = Recipe("yyy", {Ingredient("redgem", 1), Ingredient("nightmarefuel", 2), Ingredient("flint", 4)}, CUSTOM_RECIPETABS.kulaTABS, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
	yyy.atlas = "images/inventoryimages/yyy.xml"

AddClassPostConstruct("widgets/crafttabs", function(class)
    if class.owner:HasTag("kulabuilder") then
        local v = CUSTOM_RECIPETABS.kulaTABS
        local k = #class.tab_order + 1
        local tab_bg = 
        {
            normal = "tab_normal.tex",
            selected = "tab_selected.tex",
            highlight = "tab_highlight.tex",
            bufferedhighlight = "tab_place.tex",
            overlay = "tab_researchable.tex",
        }
        
        class.tabs.spacing = 750/k
        local tab = class.tabs:AddTab(STRINGS.TABS[v.str], resolvefilepath("images/hud.xml"), v.icon_atlas or resolvefilepath("images/hud.xml"), v.icon, tab_bg.normal, tab_bg.selected, tab_bg.highlight, tab_bg.bufferedhighlight, tab_bg.overlay,
            
            function() --select fn
                if not class.controllercraftingopen then
                    
                    if class.craft_idx_by_tab[k] then
                        class.crafting.idx = class.craft_idx_by_tab[k]
                    end

                    class.crafting:SetFilter( 
                        function(recipe)
                            local rec = GLOBAL.AllRecipes[recipe]
                            return rec and rec.tab == v
                        end)
                
                                                                            
                    class.crafting:Open()
                end
            end, 

            function() --deselect fn
                class.craft_idx_by_tab[k] = class.crafting.idx
                class.crafting:Close()
            end)
        tab.filter = v
        tab.icon = v.icon
        tab.icon_atlas = v.icon_atlas or resolvefilepath("images/hud.xml")
        tab.tabname = STRINGS.TABS[v.str]
        class.tabbyfilter[v] = tab
        
        table.insert(class.tab_order, tab)
    end
end)

AddModCharacter("kula")

AddMinimapAtlas("images/kula1.xml")