local assets=
{ 
    Asset("ANIM", "anim/fedora.zip"),
    Asset("ANIM", "anim/fedora_swap.zip"), 

    Asset("ATLAS", "images/inventoryimages/fedora.xml"),
    Asset("IMAGE", "images/inventoryimages/fedora.tex"),
}

local prefabs = 
{
}

    local function OnEquip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_hat", "fedora", "swap_hat")
		
		if inst.components.fueled then
			inst.components.fueled:StartConsuming()
		end
		
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAT_HAIR")
		
		if owner:HasTag("player") then
			owner.AnimState:Show("HEAD")
			owner.AnimState:Hide("HEAD_HAT")
		end
    end
 
    local function OnUnequip(inst, owner)
	
	
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")
		
		if owner:HasTag("player") then
	        owner.AnimState:Show("HEAD")
			owner.AnimState:Hide("HEAD_HAT")
		end
    end
 
 local function fn(Sim) 
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	
	
    MakeInventoryPhysics(inst)
 
    inst:AddTag("hat")
	
	    if not TheWorld.ismastersim then
        return inst
    end
	
	inst.entity:SetPristine()
	
    inst.AnimState:SetBank("fedora")
    inst.AnimState:SetBuild("fedora")
    inst.AnimState:PlayAnimation("idle")
	
	MakeHauntableLaunch(inst)
 
    inst:AddComponent("inspectable")
     
	inst:AddComponent("waterproofer")
    inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_SMALL) 
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "fedora"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/fedora.xml"
	 
    inst:AddComponent("equippable")
	inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
	inst.components.equippable.dapperness = TUNING.DAPPERNESS_SMALL
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	
	
 
    return inst
end

return  Prefab("common/inventory/fedora", fn, assets, prefabs)