
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
}
local prefabs = {
	"fedora",
	"glove"}

-- Custom starting items
local start_inv = {
	"fedora",
	"glove"
}

-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when reviving from ghost (optional)
	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "freddy_speed_mod", 1.5)
end

local function onbecameghost(inst)
	-- Remove speed modifier when becoming a ghost
   inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "freddy_speed_mod")
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
        onbecameghost(inst)
    else
        onbecamehuman(inst)
    end
end

local function freddynightvision(inst)
    if TheWorld.state.isday or TheWorld.state.isfullmoon or TheWorld.state.isdusk then
    inst.components.playervision:ForceNightVision(false)
    else
        if TheWorld.state.isnight and not TheWorld.state.isfullmoon then
        inst.components.playervision:ForceNightVision(true)
        end
    end
end


-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "freddy.tex" )
	
	-- NightVision
	inst.task = inst:DoPeriodicTask(5, freddynightvision, nil, inst)
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "maxwell"
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
	inst.components.health:SetMaxHealth(150)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(80)
	
	-- Health Regen
	inst.components.health:StartRegen(1, 10)
	
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	
	-- Monster
	inst:AddTag("monster")
	inst.components.locomotor.triggerscreep = false
	
	-- Sanity Fx
	inst:AddComponent("sanityaura")
    inst.components.sanityaura.aura = -TUNING.SANITYAURA_SMALL
	
	inst.components.sanity.custom_rate_fn = function(inst)
		local light_delta = 0
		if TheWorld.state.isday then
			light_delta = TUNING.SANITY_NIGHT_MID
		elseif TheWorld.state.isnight then
			light_delta = TUNING.DAPPERNESS_MED
		end
		return light_delta
	end

	inst.components.sanity.night_drain_mult = 0


	inst.OnLoad = onload
    inst.OnNewSpawn = onload
	
end

return MakePlayerCharacter("freddy", prefabs, assets, common_postinit, master_postinit, start_inv)
