local assets=
{ 
    Asset("ANIM", "anim/glove.zip"),
    Asset("ANIM", "anim/swap_glove.zip"), 

    Asset("ATLAS", "images/inventoryimages/glove.xml"),
    Asset("IMAGE", "images/inventoryimages/glove.tex"),
}

local prefabs = 
{
	"freddy"
}

local function fn(colour)

    local function OnEquip(inst, owner) 
        --owner.AnimState:OverrideSymbol("swap_object", "swap_gloves", "purplestaff")
        owner.AnimState:OverrideSymbol("swap_object", "swap_glove", "glove")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
    end

    local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end

    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
	inst.entity:AddNetwork()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("glove")
    anim:SetBuild("glove")
    anim:PlayAnimation("idle")
	
	if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("inventoryitem")
	
    inst.components.inventoryitem.imagename = "glove"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/glove.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	
	inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(51)
	
	inst:AddComponent("inspectable")

    return inst
end

return  Prefab("common/inventory/glove", fn, assets, prefabs)