--[[You can use MakeSword to make a weapon with it own name and damage]]--
local function MakeSword(gladius, damage)
    local assets =
    {
        Asset("ANIM", "anim/gladius.zip"),
        Asset("ANIM", "anim/swap_gladius.zip"),
        Asset("IMAGE", "images/inventoryimages/gladius.tex"),
        Asset("ATLAS", "images/inventoryimages/gladius.xml"),
    }

    local function onequip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_gladius", "swap_gladius")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
    end

    local function onunequip(inst, owner)
        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
    end

    local function DoNothingNow(inst)
    end

    local function fn()
        local inst = CreateEntity()

        inst.entity:AddTransform()
        inst.entity:AddAnimState()
        inst.entity:AddNetwork()

        MakeInventoryPhysics(inst)

        inst.AnimState:SetBank("gladius")
        inst.AnimState:SetBuild("gladius")
        inst.AnimState:PlayAnimation("idle")

        inst.entity:SetPristine()
		
		inst:AddTag("sharp")
		inst:AddTag("mower")

        if not TheWorld.ismastersim then
            return inst
        end

        inst:AddComponent("weapon")
        inst.components.weapon:SetDamage(56) --the code is used to set damage
        inst.components.weapon:SetOnAttack(DoNothingNow) -- you can set a function (which can give the char san, for example ) when weapon is used
    
	inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(1.5 * TUNING.SPEAR_USES)
    inst.components.finiteuses:SetUses(1.5 * TUNING.SPEAR_USES)

    inst.components.finiteuses:SetOnFinished(inst.Remove)

        inst:AddComponent("inspectable")

        inst:AddComponent("inventoryitem")
        inst.components.inventoryitem.atlasname = "images/inventoryimages/gladius.xml"
        inst.components.inventoryitem.imagename = "gladius"

        inst:AddComponent("equippable")
        inst.components.equippable:SetOnEquip(onequip)
        inst.components.equippable:SetOnUnequip(onunequip)
		

        MakeHauntableLaunch(inst)

        return inst
    end
    return Prefab( "common/inventory/gladius", fn, assets) 
end

--what you need to change in this file is here
return MakeSword("gladius",20)