
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
}
local prefabs = {}

-- Custom starting items
local start_inv = { 
"gladius",

}

-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when reviving from ghost (optional)
	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "volta_speed_mod", 1)
end

local function onbecameghost(inst)
	-- Remove speed modifier when becoming a ghost
   inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "volta_speed_mod")
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
        onbecameghost(inst)
    else
        onbecamehuman(inst)
    end
end


-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "volta.tex" )
	inst:AddTag("centurion")
end

local function sanityfunction(inst, observer)
    if observer:HasTag("keeper") then
return TUNING.SANITYAURA_SMALL
end
end 
-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)

inst:AddComponent("sanityaura")
    inst.components.sanityaura.aurafn = sanityfunction 
	
	-- choose which sounds this character will play
	inst.soundsname = "volta"
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
	inst.components.health:SetMaxHealth(250) 
	inst.components.hunger:SetMax(200) -- 
	inst.components.sanity:SetMax(200)--His max Sanity?
	
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE --How fast he gets Hungry
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
	
	
end

return MakePlayerCharacter("volta", prefabs, assets, common_postinit, master_postinit, start_inv)
