
GLOBAL.TUNING.LANG = GetModConfigData("lan")
GLOBAL.TUNING.DODGE = GetModConfigData("dodge")
GLOBAL.TUNING.BOMBDAMAGE = GetModConfigData("bombdamage")
GLOBAL.TUNING.BOMBCHARGE = GetModConfigData("bombcharge")

PrefabFiles = {
	"renko", "hat_renko", "renko_none", "merry", "merry_none", "hat_merry", "bomb", "bomb_sinkhole", "medkit", "air_freshener", "slice", "sukima"
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/renko.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/renko.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/renko.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/renko.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/renko_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/renko_silho.xml" ),

    Asset( "IMAGE", "bigportraits/renko.tex" ),
    Asset( "ATLAS", "bigportraits/renko.xml" ),
	
	Asset( "IMAGE", "images/map_icons/renko.tex" ),
	Asset( "ATLAS", "images/map_icons/renko.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_renko.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_renko.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_renko.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_renko.xml" ),
	
	Asset( "IMAGE", "bigportraits/renko_none.tex" ),
    Asset( "ATLAS", "bigportraits/renko_none.xml" ),
	
	Asset( "IMAGE", "images/names_renko.tex" ),
    Asset( "ATLAS", "images/names_renko.xml" ),
	
	Asset( "IMAGE", "images/saveslot_portraits/merry.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/merry.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/merry.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/merry.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/merry_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/merry_silho.xml" ),

    Asset( "IMAGE", "bigportraits/merry.tex" ),
    Asset( "ATLAS", "bigportraits/merry.xml" ),
	
	Asset( "IMAGE", "images/map_icons/merry.tex" ),
	Asset( "ATLAS", "images/map_icons/merry.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_merry.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_merry.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_merry.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_merry.xml" ),
	
	Asset( "IMAGE", "bigportraits/merry_none.tex" ),
    Asset( "ATLAS", "bigportraits/merry_none.xml" ),
	
	Asset( "IMAGE", "images/names_merry.tex" ),
    Asset( "ATLAS", "images/names_merry.xml" ),

	Asset( "IMAGE", "images/inventoryimages/air_freshener.tex" ),
    Asset( "ATLAS", "images/inventoryimages/air_freshener.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/gears_hifuu.tex" ),
    Asset( "ATLAS", "images/inventoryimages/gears_hifuu.xml" ),
	
	Asset( "IMAGE", "images/hud/hifuutab.tex" ),
    Asset( "ATLAS", "images/hud/hifuutab.xml" ),

}

local require = GLOBAL.require
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local TECH = GLOBAL.TECH
local Recipe = GLOBAL.Recipe
local EventHandler = GLOBAL.EventHandler
local Action = GLOBAL.Action
local ACTIONS = GLOBAL.ACTIONS
local ActionHandler = GLOBAL.ActionHandler
local TUNING = GLOBAL.TUNING
local STRINGS = GLOBAL.STRINGS
local Lerp = GLOBAL.Lerp
local SpawnPrefab = GLOBAL.SpawnPrefab
local FindWalkableOffset = GLOBAL.FindWalkableOffset
local PI = GLOBAL.PI
local Vector3 = GLOBAL.Vector3
--local debug = GLOBAL.debug
local GetPlayer = GLOBAL.GetPlayer
local IsHUDPaused = GLOBAL.IsPaused
local TheInput = GLOBAL.TheInput
local TheFrontEnd = GLOBAL.TheFrontEnd
local TheSim = GLOBAL.TheSim
local IsServer = GLOBAL.TheNet:GetIsServer()

AddClassPostConstruct("cameras/followcamera", function(Camera)
	Camera.old = Camera.SetDefault
	function Camera:SetDefault()
		if Camera.target~=nil and Camera.target.entity and Camera.target.entity:GetParent()~=nil and Camera.target.entity:GetParent().prefab=="renko" then
			if GLOBAL.TheWorld.state.isnight then
				Camera.maxdist = 120
			else
				Camera.maxdist = 50
			end
			Camera.target.entity:GetParent():ListenForEvent("newstate", function()
				if GLOBAL.TheWorld.state.isnight and not GLOBAL.TheWorld:HasTag("cave") then
					Camera.maxdist = 120
				else
					Camera.maxdist = 50
				end
			end)
		end
	end
end)

local function IsDefaultScreen() 
	if GLOBAL.TheFrontEnd:GetActiveScreen() and GLOBAL.TheFrontEnd:GetActiveScreen().name and type(GLOBAL.TheFrontEnd:GetActiveScreen().name) == "string" and GLOBAL.TheFrontEnd:GetActiveScreen().name == "HUD" then
		return true
	else
		return false
	end
end

AddModRPCHandler("merry_rpc", "Slicing", function (player, target)
	if player.prefab == "merry" and not player.sg:HasStateTag("busy") and not player.sg:HasStateTag("sleeping") then
		player:slice(target)
	end
end)

GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_Z, function()
	local player = GLOBAL.ThePlayer
	if player 
		and player.prefab == "merry"
		and not player:HasTag("busy") 
		and not player.sg:HasStateTag("busy") 
		and not player.HUD:IsChatInputScreenOpen() 
		and not player.HUD:IsConsoleScreenOpen() 
		and IsDefaultScreen() then
			local target = GLOBAL.TheInput:GetWorldEntityUnderMouse()
			if target then
				if not GLOBAL.TheWorld.ismastersim then 
					local x, y, z = target.Transform:GetWorldPosition()
					player:FacePoint(x, y, z)
					SendModRPCToServer(MOD_RPC["merry_rpc"]["Slicing"], target)
				else
					player:slice(target)
				end
			end
	end
end)

do
	local dodgechance = TUNING.DODGE
	local inventory = GLOBAL.require "components/inventory"
	local old_ApplyDamage = inventory.ApplyDamage
	function inventory:ApplyDamage(damage,...)
		--local player = GLOBAL.ThePlayer
		--if player and player.prefab=="merry" and math.random() < dodgechance then
		local armor = self:GetEquippedItem(GLOBAL.EQUIPSLOTS.HEAD)
		if armor and armor.prefab=="hat_merry" and armor.components.inventoryitem.owner.prefab == "merry" and math.random() < dodgechance then
			local player= armor.components.inventoryitem.owner
			local x, y, z = player.Transform:GetWorldPosition()
			local a = 0
			local b = 0
			repeat
				a = math.random(-20, 20)
				b = math.random(-20, 20)
			until(GLOBAL.TheWorld.Map:IsAboveGroundAtPoint(x+a, y, z+b))

			SpawnPrefab("sukima").Transform:SetPosition(x, y, z, 0)
			SpawnPrefab("sukima").Transform:SetPosition(x+a, y, z+b, 0)
			player:DoTaskInTime(0.1, function()
				player.Transform:SetPosition(x+a, y, z+b)
			end)
			return 0	
		end
		return  old_ApplyDamage(self,damage,...)
	end	
end

local hifuutab = AddRecipeTab( "Hifuu Tab", 129, "images/hud/hifuutab.xml", "hifuutab.tex", "hifuu_builder")

AddRecipe("gears", 
{GLOBAL.Ingredient("goldnugget", 3)}, 
hifuutab, TECH.SCIENCE_TWO, nil, nil, nil, nil, "hifuu_builder", 
"images/inventoryimages/gears_hifuu.xml", "gears_hifuu.tex" )

AddRecipe("air_freshener", 
{GLOBAL.Ingredient("gears", 5), GLOBAL.Ingredient("redgem", 1), GLOBAL.Ingredient("transistor", 3)}, 
hifuutab, TECH.SCIENCE_TWO, nil, nil, nil, nil, "hifuu_builder", 
"images/inventoryimages/air_freshener.xml", "air_freshener.tex" )

--local air_freshener = GLOBAL.Recipe("air_freshener",
	--{ 
		--Ingredient("gears", 5), 
		--Ingredient("redgem", 1),         
		--Ingredient("transistor", 3) 
    --},                     
    --GLOBAL.RECIPETABS.TOWN, TECH.SCIENCE_TWO, "air_freshener_placer" ) 
    --air_freshener.atlas = "images/inventoryimages/air_freshener.xml"

AddRecipe("medkit", 
{GLOBAL.Ingredient("papyrus", 4), GLOBAL.Ingredient("silk", 4), GLOBAL.Ingredient("healingsalve", 1)}, 
hifuutab, TECH.SCIENCE_TWO, nil, nil, nil, nil, "hifuu_builder", 
"images/inventoryimages/medkit.xml", "medkit.tex" )

AddRecipe("hat_renko", 
{GLOBAL.Ingredient("silk", 5), GLOBAL.Ingredient("moonrocknugget", 1), GLOBAL.Ingredient("tentaclespots", 1)}, 
hifuutab, TECH.SCIENCE_TWO, nil, nil, nil, nil, "hifuu_builder", 
"images/inventoryimages/hat_renko.xml", "hat_renko.tex" )

AddRecipe("hat_merry", 
{GLOBAL.Ingredient("silk", 8), GLOBAL.Ingredient("petals", 10), GLOBAL.Ingredient("beefalowool", 2)}, 
hifuutab, TECH.MAGIC_ONE, nil, nil, nil, nil, "hifuu_builder", 
"images/inventoryimages/hat_merry.xml", "hat_merry.tex" )

-- The character select screen lines
if TUNING.LANG == 1 then
	STRINGS.CHARACTER_TITLES.renko = "Maiden of the Scientific Era"
	STRINGS.CHARACTER_NAMES.renko = "Renko Usami"
	STRINGS.CHARACTER_DESCRIPTIONS.renko = "*Quite Active\n*Totally Trusts Merry\n*Knows Her Position when Looking at the Moon"
	STRINGS.CHARACTER_QUOTES.renko = "\"LET'S TURN THE DREAMS INTO REALITY TOGETHER!\""

	STRINGS.CHARACTER_TITLES.merry = "Merry the Magician"
	STRINGS.CHARACTER_NAMES.merry = "Maribel Hearn"
	STRINGS.CHARACTER_DESCRIPTIONS.merry = "*Not Good at Fighting\n*Totally Trusts Renko\n*Can Use the Power of Boundary."
	STRINGS.CHARACTER_QUOTES.merry = "\"Like I'm able to see more than I should.\""
else
	STRINGS.CHARACTER_TITLES.renko = "科学世纪的少女"
	STRINGS.CHARACTER_NAMES.renko = "宇佐见莲子"
	STRINGS.CHARACTER_DESCRIPTIONS.renko = "*充满活力与行动力\n*完全信任着梅莉\n*看见月亮便知晓目前的位置"
	STRINGS.CHARACTER_QUOTES.renko = "\"来吧，睁开双眼吧。让我们一起把梦境变成现实吧！\""

	STRINGS.CHARACTER_TITLES.merry = "魔术师梅莉"
	STRINGS.CHARACTER_NAMES.merry = "玛艾露贝莉·赫恩"
	STRINGS.CHARACTER_DESCRIPTIONS.merry = "*比较文静\n*完全信任着莲子\n*操纵境界的能力"
	STRINGS.CHARACTER_QUOTES.merry = "\"状态有点儿好过头，看见了些多余的东西。\""
end

if TUNING.LANG == 1 then
	STRINGS.CHARACTERS.RENKO = require "speech_renko"
	STRINGS.CHARACTERS.MERRY = require "speech_merry"
else
	STRINGS.CHARACTERS.RENKO = require "speech_renko_cn"
	STRINGS.CHARACTERS.MERRY = require "speech_merry_cn"
end

if TUNING.LANG == 1 then
	STRINGS.NAMES.RENKO = "Renko"
	STRINGS.NAMES.MERRY = "Merry"
else
	STRINGS.NAMES.RENKO = "莲子"
	STRINGS.NAMES.MERRY = "梅莉"
end
	
if TUNING.LANG == 1 then
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.RENKO = 
	{
		GENERIC = "It's Renko!",
		ATTACKER = "That girl doesn't look good...",
		MURDERER = "Murderer!",
		REVIVER = "Great thanks for reviving me!",
		GHOST = "Renko could use a heart.",
	}
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.MERRY = 
	{
		GENERIC = "It's Merry!",
		ATTACKER = "That girl doesn't look good...",
		MURDERER = "Murderer!",
		REVIVER = "Great thanks for reviving me!",
		GHOST = "Merry could use a heart.",
	}
else	
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.RENKO = 
	{
		GENERIC = "是秘封俱乐部的莲子！",
		ATTACKER = "那姑娘看起来不太正常...",
		MURDERER = "杀人啦！",
		REVIVER = "谢谢你救了我，莲子！",
		GHOST = "莲子还可以抢救一下.",
	}
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.MERRY = 
	{
		GENERIC = "是秘封俱乐部的梅莉！",
		ATTACKER = "那姑娘看起来不太正常...",
		MURDERER = "杀人啦！",
		REVIVER = "谢谢你救了我，梅莉！",
		GHOST = "梅莉还可以抢救一下.",
	}
end

AddMinimapAtlas("images/map_icons/renko.xml")
AddMinimapAtlas("images/map_icons/merry.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("renko", "FEMALE")
AddModCharacter("merry", "FEMALE")
