require "prefabutil"

local assets =
{
    Asset("ANIM", "anim/air_freshener.zip"),
}

local prefabs =
{
    "collapse_small",
}

local function TurnOff(inst, instant)
    inst.on = false
	inst:AddTag("fueldepleted")

    inst.components.fueled:StopConsuming()
end

local function CanInteract(inst)
    return not inst.components.fueled:IsEmpty()
end

local function TurnOn(inst, instant)
    inst.on = true
    inst.components.fueled:StartConsuming()
    inst:RemoveTag("fueldepleted")
end
	
local function OnFuelEmpty(inst)
    inst.components.machine:TurnOff()
end

local function sooth(inst, data)
	local x,y,z = inst.Transform:GetWorldPosition() 
	local ents = TheSim:FindEntities(x, y, z, 10)
	for k,v in pairs(ents) do	
		if v.components.sanity and v.components.sanity:GetPercent() < 1 and not v:HasTag("koishi") then
			v.components.sanity:DoDelta(1)
		end
	end
end

local function OnAddFuel(inst)
    inst.SoundEmitter:PlaySound("dontstarve_DLC001/common/machine_fuel")
    if inst.on == false then
        inst.components.machine:TurnOn()
    end
end

local function onhammered(inst, worker)
    inst.components.lootdropper:DropLoot()
    local fx = SpawnPrefab("collapse_small")
    fx.Transform:SetPosition(inst.Transform:GetWorldPosition())
    fx:SetMaterial("metal")
    inst:Remove()
end

local function getstatus(inst, viewer)
        return inst.components.fueled ~= nil
            and inst.components.fueled.currentfuel / inst.components.fueled.maxfuel <= .25
            and "LOWFUEL"
            or "ON"
end

local function onhit(inst, worker)
	inst.AnimState:PlayAnimation("idle", true)
end

local function onbuilt(inst)
    inst.AnimState:PlayAnimation("idle")
    inst.SoundEmitter:PlaySound("dontstarve/common/lightning_rod_craft")
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState() 
    inst.entity:AddMiniMapEntity()
    inst.entity:AddLight()
    inst.entity:AddSoundEmitter()
    inst.entity:AddDynamicShadow()
    inst.entity:AddNetwork()
    inst:AddTag("structure")
    inst.DynamicShadow:Enable(true)
	inst.DynamicShadow:SetSize(2.2, 1.4)

    inst.AnimState:SetBank("air_freshener")
    inst.AnimState:SetBuild("air_freshener")
    inst.AnimState:PlayAnimation("idle", true)
    MakeObstaclePhysics(inst, 0.7)
    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	
    inst:AddComponent("fueled")
    inst.components.fueled:SetDepletedFn(OnFuelEmpty)
    inst.components.fueled:SetTakeFuelFn(OnAddFuel)
    inst.components.fueled.accepting = true
    inst.components.fueled:SetSections(10)
    inst.components.fueled:InitializeFuelLevel(TUNING.FIRESUPPRESSOR_MAX_FUEL_TIME)
    inst.components.fueled.bonusmult = 5
    inst.components.fueled.secondaryfueltype = FUELTYPE.CHEMICAL
    inst:AddComponent("lootdropper")
    inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(4)
    inst.components.workable:SetOnFinishCallback(onhammered)
    inst.components.workable:SetOnWorkCallback(onhit)     
	
    inst:AddComponent("machine")
    inst.components.machine.turnonfn = TurnOn
    inst.components.machine.turnofffn = TurnOff
    inst.components.machine.caninteractfn = CanInteract
    inst.components.machine.cooldowntime = 0.5
	
    inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = getstatus

    inst:ListenForEvent("onbuilt", onbuilt)
	inst:DoPeriodicTask(2, function() sooth(inst, 2) end)
    MakeHauntableWork(inst)

    return inst
end

if TUNING.LANG == 1 then
	STRINGS.NAMES.AIR_FRESHENER = "Air Freshener"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.AIR_FRESHENER = 		
	{	
		ON = "It's so nice and comfy just smelling it!",
		OFF = "No more fresh air.",
		LOWFUEL = "It seems to need some fuel.",
	}
	STRINGS.RECIPE_DESC.AIR_FRESHENER = "Give Your World Some Fresh Air!" 
else
	STRINGS.NAMES.AIR_FRESHENER = "空气清新器"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.AIR_FRESHENER = 		
	{	
		ON = "光是闻一闻就感觉心旷神怡！",
		OFF = "现在关机了.",
		LOWFUEL = "它似乎需要点燃料?",
	}
	STRINGS.RECIPE_DESC.AIR_FRESHENER = "给你的世界带来一点清新空气！" 
end

return Prefab("air_freshener", fn, assets, prefabs)
    --MakePlacer("common/air_freshener_placer", "air_freshener", "air_freshener", "idle")