local assets=
{   
	Asset("ANIM", "anim/bomb.zip"),
	Asset("ATLAS", "images/inventoryimages/bomb.xml"),    
	Asset("IMAGE", "images/inventoryimages/bomb.tex"),
}

local function ShouldAcceptItem(inst, item)
    if item.prefab == "goldnugget" then
       return true
    end
    return false
end

local function OnGetItemFromPlayer(inst, giver, item)
    inst.components.finiteuses.current = inst.components.finiteuses.current + 1
    if inst.components.finiteuses.current > inst.components.finiteuses.total then
       inst.components.finiteuses.current = inst.components.finiteuses.total
    end
	inst.components.finiteuses:SetPercent(inst.components.finiteuses:GetPercent(inst.components.finiteuses.condition))
end

local function canuse()
		return true
end

local function bomb(staff, target, pos, inst)
	local owner = staff.components.inventoryitem.owner
	if owner.prefab == "renko" then
		if staff.components.finiteuses.current == staff.components.finiteuses.total then
			staff.components.finiteuses:Use(TUNING.BOMBCHARGE)
			if TUNING.BOMBDAMAGE > 0 then	
				local x, y, z = owner.Transform:GetWorldPosition()
				SpawnPrefab("bomb_sinkhole").Transform:SetPosition(x, y, z, 0)
				SpawnPrefab("bomb_sinkhole").Transform:SetPosition(x, y, z, 0)
				local fx = SpawnPrefab("collapse_big")
				fx.Transform:SetPosition(x, y, z, 0)
				fx.Transform:SetScale(6, 6, 6)
				for i, v in ipairs(AllPlayers) do
					v:ShakeCamera(CAMERASHAKE.FULL, .9, .1, 4)
				end
				local ents = TheSim:FindEntities(x, y, z, 25)
				for k,v in pairs(ents) do
					if v.components.health then
						if TUNING.BOMBDAMAGE == 1 then
							if v.components.combat and not v:HasTag("player") then
								v.components.health:SetVal(0, "Mini Quatic Positron Bomb", owner)
								owner:PushEvent("killed", { victim = v })
							elseif v:HasTag("player") and TheNet:GetPVPEnabled() and not (v.prefab == "renko" or v.prefab == "merry") then
								v.components.health:SetVal(0, "Mini Quatic Positron Bomb", owner)
								owner:PushEvent("killed", { victim = v })
							end
						else
							if v.components.combat and not v:HasTag("player") then
								v.components.combat:GetAttacked(owner, TUNING.BOMBDAMAGE)
							elseif v:HasTag("player") and TheNet:GetPVPEnabled() and not (v.prefab == "renko" or v.prefab == "merry") then
								v.components.combat:GetAttacked(owner, TUNING.BOMBDAMAGE)
							end
						end
					else				
						if v.components.pickable then
							v:Remove()
							SpawnPrefab("collapse_big").Transform:SetPosition(v.Transform:GetWorldPosition())
						end
						if v.components.crop then
							v:Remove()
							SpawnPrefab("collapse_big").Transform:SetPosition(v.Transform:GetWorldPosition())
						end	
						if v:HasTag("birchnut")
							or v:HasTag("mole")	
							or v.prefab == "carrot_planted" then
							v:Remove()
							SpawnPrefab("collapse_big").Transform:SetPosition(v.Transform:GetWorldPosition())
						end
						if v.components.workable and v.components.workable.workleft > 0 then
							v:Remove()
							SpawnPrefab("collapse_big").Transform:SetPosition(v.Transform:GetWorldPosition())
						end
					end
				end
			else
				if TUNING.LANG == 1 then
					owner.components.talker:Say("Oh! Doctor Okazaki tricked me! It's a fake bomb!", 3, false)
				else
					owner.components.talker:Say("冈崎教授你坑我啊！这是个假货啊！", 3, false)
				end			
			end
		else
			if TUNING.LANG == 1 then
				owner.components.talker:Say("The bomb is not fully charged yet.", 3, false)
			else
				owner.components.talker:Say("炸弹还没有充能完毕呢.", 3, false)
			end
		end
	else
		if TUNING.LANG == 1 then
			owner.components.talker:Say("I don't know how to operate this.", 3, false)	
		else
			owner.components.talker:Say("我不会操作这个东西.", 3, false)	
		end
	end
end

local function onsave(inst, data)
	data.con = inst.components.finiteuses:GetPercent(inst.components.finiteuses.condition)
end

local function onload(inst, data)
	if data then
		inst.components.finiteuses:SetPercent(data.con or 0)
	end
end

local function fn()  

	local inst = CreateEntity()    
	local trans = inst.entity:AddTransform()    
	local anim = inst.entity:AddAnimState()    
	inst.entity:AddNetwork()
	
	MakeInventoryPhysics(inst)     	
	inst.AnimState:SetBank("bomb")    
	inst.AnimState:SetBuild("bomb")    
	inst.AnimState:PlayAnimation("idle")
	inst.entity:SetPristine()
	inst.Transform:SetScale(0.3, 0.3, 0.3)
	

    	if not TheWorld.ismastersim then
        	return inst
    	end
	
	inst.entity:SetPristine()
	inst:AddComponent("inspectable")       
	
	inst:AddComponent("inventoryitem") 
	inst.components.inventoryitem.imagename = "bomb"    
	inst.components.inventoryitem.atlasname = "images/inventoryimages/bomb.xml"  
	inst.components.inventoryitem.keepondeath = true
	
	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetMaxUses(TUNING.BOMBCHARGE)
	inst.components.finiteuses:SetUses(0)
	
    inst:AddComponent("trader")
    inst.components.trader.onaccept = OnGetItemFromPlayer
    inst.components.trader:SetAcceptTest(ShouldAcceptItem)
	
	inst:AddComponent("spellcaster")
	inst.components.spellcaster:SetSpellFn(bomb)
    inst.components.spellcaster.CanCast = canuse
    inst.components.spellcaster.canusefrominventory = true
	inst.OnSave = onsave
	inst.OnLoad = onload

	return inst
end
if TUNING.LANG == 1 then
	STRINGS.NAMES.BOMB = "Mini Quatic Positron Bomb"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.BOMB = "Handle it very, very, very carefully."
else
	STRINGS.NAMES.BOMB = "迷你四次元阳电子炸弹"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.BOMB = "小心，小心，再小心."
end

return Prefab("common/inventory/bomb", fn, assets, prefabs)