local assets =
{
    Asset("ANIM", "anim/antlion_sinkhole.zip"),
    Asset("MINIMAP_IMAGE", "sinkhole"),
}

local prefabs =
{
    "sinkhole_spawn_fx_1",
    "sinkhole_spawn_fx_2",
    "sinkhole_spawn_fx_3",
    "mining_ice_fx",
    "mining_fx",
}

local function dull1(inst)
	inst.AnimState:SetMultColour(0.9,0.9,0.9,0.9)
end
local function dull2(inst)
	inst.AnimState:SetMultColour(0.8,0.8,0.8,0.8)
end
local function dull3(inst)
	inst.AnimState:SetMultColour(0.7,0.7,0.7,0.7)
end
local function dull4(inst)
	inst.AnimState:SetMultColour(0.6,0.6,0.6,0.6)
end
local function dull5(inst)
	inst.AnimState:SetMultColour(0.5,0.5,0.5,0.5)
end
local function dull6(inst)
	inst.AnimState:SetMultColour(0.4,0.4,0.4,0.4)
end
local function dull7(inst)
	inst.AnimState:SetMultColour(0.3,0.3,0.3,0.3)
end
local function dull8(inst)
	inst.AnimState:SetMultColour(0.2,0.2,0.2,0.2)
end
local function dull9(inst)
	inst.AnimState:SetMultColour(0.1,0.1,0.1,0.1)
end

-------------------------------------------------------------------------------

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    inst.AnimState:SetBank("sinkhole")
    inst.AnimState:SetBuild("antlion_sinkhole")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround)
    inst.AnimState:SetLayer(LAYER_BACKGROUND)
    inst.AnimState:SetSortOrder(1)
	inst.Transform:SetScale(3, 3, 3)
	inst.AnimState:SetMultColour(1,1,1,1)
    inst.Transform:SetEightFaced()

    inst:AddTag("antlion_sinkhole")
    inst:AddTag("antlion_sinkhole_blocker")
    inst:AddTag("NOCLICK")

    inst:SetDeployExtraSpacing(4)
    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:DoTaskInTime(60.1, dull1)
	inst:DoTaskInTime(60.2, dull2)
	inst:DoTaskInTime(60.3, dull3)
	inst:DoTaskInTime(60.4, dull4)	
    inst:DoTaskInTime(60.5, dull5)
	inst:DoTaskInTime(60.6, dull6)
	inst:DoTaskInTime(60.7, dull7)
	inst:DoTaskInTime(60.8, dull8)
	inst:DoTaskInTime(60.9, dull9)
    inst:DoTaskInTime(61, inst.Remove)
    return inst
end

return Prefab("bomb_sinkhole", fn, assets, prefabs)
