local assets=
{
	Asset("ANIM", "anim/hat_merry.zip"),    
	Asset("ATLAS", "images/inventoryimages/hat_merry.xml"),  
}


local function onequip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_hat", "hat_merry", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAT_HAIR")
	
end

local function onunequip(inst, owner) 
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")

end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	inst.entity:AddNetwork()
    
    inst:AddTag("hat")
    
	inst.isWeared = false
	inst.isDropped = false
	
    anim:SetBank("strawhat")
    anim:SetBuild("hat_merry")
    anim:PlayAnimation("anim")    
        
    inst:AddComponent("inspectable")
    
	if not TheWorld.ismastersim then
        return inst
    end
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/hat_merry.xml"  

	inst:AddComponent("insulator")
    inst.components.insulator:SetInsulation(TUNING.INSULATION_LARGE)
	inst.components.insulator:SetWinter()
	
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.equippable.dapperness = 0.2
	
    
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )	
	
    return inst
end
if TUNING.LANG == 1 then
	STRINGS.NAMES.HAT_MERRY = "Merry's Hat"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.HAT_MERRY = "It's so soft and nice!" 
	STRINGS.RECIPE_DESC.HAT_MERRY = "Make your life even more comforting！" 
else
	STRINGS.NAMES.HAT_MERRY = "梅莉的帽子"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.HAT_MERRY = "超舒服！超暖和！你值得拥有！" 
	STRINGS.RECIPE_DESC.HAT_MERRY = "让你的生活更加惬意！" 
end

return Prefab( "common/inventory/hat_merry", fn, assets) 
