local assets=
{
	Asset("ANIM", "anim/hat_renko.zip"),
	Asset("ATLAS", "images/inventoryimages/hat_renko.xml")
}

local function OnAttacked(inst)
    inst.components.armor.condition = inst.components.armor.maxcondition

end

local function onequip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_hat", "hat_renko", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAT_HAIR")
		inst:ListenForEvent("armordamaged", OnAttacked, inst)	
end

local function onunequip(inst, owner) 
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")
		inst:RemoveEventCallback("armordamaged", OnAttacked, inst)
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	inst.entity:AddNetwork()
    
    inst:AddTag("hat")
    
	inst.isWeared = false
	inst.isDropped = false
	
    anim:SetBank("strawhat")
    anim:SetBuild("hat_renko")
    anim:PlayAnimation("anim")    
        
    inst:AddComponent("inspectable")
    
	if not TheWorld.ismastersim then
        return inst
    end
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/hat_renko.xml"
	
	inst:AddComponent("armor")
    inst.components.armor:InitCondition(2500, 0.6)   

	inst:AddComponent("insulator")
    inst.components.insulator:SetInsulation(TUNING.INSULATION_MED)
    inst.components.insulator:SetSummer()
	
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
	
	inst:AddComponent("waterproofer")
	inst.components.waterproofer:SetEffectiveness(1)
    
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )	
	
    return inst
end
if TUNING.LANG == 1 then
	STRINGS.NAMES.HAT_RENKO = "Renko's Hat"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.HAT_RENKO = "Why can a hat be so hard and waterproof? It's future technology!"
	STRINGS.RECIPE_DESC.HAT_RENKO = "I have no idea why it's so tough!" 	
else
	STRINGS.NAMES.HAT_RENKO = "莲子的帽子"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.HAT_RENKO = "为什么一顶帽子可以这么耐用又防水？这是未来科技！"
	STRINGS.RECIPE_DESC.HAT_RENKO = "我也不知道它为什么这么硬！" 
end
	
return Prefab( "common/inventory/hat_renko", fn, assets) 
