local assets=
{   
	Asset("ANIM", "anim/medkit.zip"),
	Asset("ATLAS", "images/inventoryimages/medkit.xml"),    
	Asset("IMAGE", "images/inventoryimages/medkit.tex"),
}

local function ShouldAcceptItem(inst, item)
    if item.prefab == "spidergland" or item.prefab == "papyrus" or item.prefab == "ash" then
       return true
    end
    return false
end

local function OnGetItemFromPlayer(inst, giver, item)
	if item.prefab == "ash" then
		inst.components.finiteuses.current = inst.components.finiteuses.current + 2
	end
	if item.prefab == "papyrus" then
		inst.components.finiteuses.current = inst.components.finiteuses.current + 4
	end	
	if item.prefab == "spidergland" then
		inst.components.finiteuses.current = inst.components.finiteuses.current + 5
	end	
	inst.components.finiteuses:SetPercent(inst.components.finiteuses:GetPercent(inst.components.finiteuses.condition))
    if inst.components.finiteuses.current > inst.components.finiteuses.total then
       inst.components.finiteuses.current = inst.components.finiteuses.total
    end
end

local function canuse()
		return true
end

local function medkit(staff, target, pos, inst)
	local owner = staff.components.inventoryitem.owner
	if staff.components.finiteuses.current > 0 then
		local amount = owner.components.health:GetMaxWithPenalty() * staff.components.finiteuses:GetPercent(staff.components.finiteuses.condition)
		owner.components.health:DoDelta(amount)
		staff.components.finiteuses:SetPercent(0)
	else
		owner.components.talker:Say("这个医疗包是空的.", 3, false)
	end
end

local function onsave(inst, data)
	data.con = inst.components.finiteuses:GetPercent(inst.components.finiteuses.condition)
end

local function onload(inst, data)
	if data then
		inst.components.finiteuses:SetPercent(data.con or 0)
	end
end

local function fn()  

	local inst = CreateEntity()    
	local trans = inst.entity:AddTransform()    
	local anim = inst.entity:AddAnimState()    
	inst.entity:AddNetwork()
	
	MakeInventoryPhysics(inst)     	
	inst.AnimState:SetBank("medkit")    
	inst.AnimState:SetBuild("medkit")    
	inst.AnimState:PlayAnimation("idle")
	inst.entity:SetPristine()
	inst.Transform:SetScale(0.5, 0.5, 0.5)
	

    	if not TheWorld.ismastersim then
        	return inst
    	end
	
	inst.entity:SetPristine()
	inst:AddComponent("inspectable")       
	
	inst:AddComponent("inventoryitem") 
	inst.components.inventoryitem.imagename = "medkit"    
	inst.components.inventoryitem.atlasname = "images/inventoryimages/medkit.xml"  
	inst.components.inventoryitem.keepondeath = true
	
	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetMaxUses(40)
	inst.components.finiteuses:SetUses(0)
	
    inst:AddComponent("trader")
    inst.components.trader.onaccept = OnGetItemFromPlayer
    inst.components.trader:SetAcceptTest(ShouldAcceptItem)
	
	inst:AddComponent("spellcaster")
	inst.components.spellcaster:SetSpellFn(medkit)
    inst.components.spellcaster.CanCast = canuse
    inst.components.spellcaster.canusefrominventory = true
	inst.OnSave = onsave
	inst.OnLoad = onload

	return inst
end
if TUNING.LANG == 1 then
	STRINGS.NAMES.MEDKIT = "High-tech Medkit"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.MEDKIT = "Incredibly efficient at healing wounds."
	STRINGS.RECIPE_DESC.MEDKIT = "Healing time!" 
else
	STRINGS.NAMES.MEDKIT = "高科技医疗包"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.MEDKIT = "它的治疗效果简直不可思议！"
	STRINGS.RECIPE_DESC.MEDKIT = "包扎时间到！" 
end

return Prefab("common/inventory/medkit", fn, assets, prefabs)