
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
}
local prefabs = {}

-- Custom starting items
local start_inv = {
	"hat_merry",
}

-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when loading or reviving from ghost (optional)
	inst.components.locomotor.walkspeed = 1.1 * TUNING.WILSON_WALK_SPEED
	inst.components.locomotor.runspeed = 1.1 * TUNING.WILSON_RUN_SPEED
end

local function slice(inst, target)
	if target ~= nil then
		if target.components.health and not target.components.health:IsDead()and target.components.combat and not inst:HasTag("sliced") and not (inst.sg:HasStateTag("busy") or inst:HasTag("busy")) then
			if target ~= inst and not inst:HasTag("sliced") then 
				if not (target:HasTag("player")
						or target:HasTag("wall") 
						or target:HasTag("structure")
						or target:HasTag("eyeplant")) then
					local sanityCost = target.components.health:GetMaxWithPenalty() / 5
					local mincost = 50
					if sanityCost < mincost  then 
						sanityCost = mincost 
					end		
					inst:FacePoint(target.Transform:GetWorldPosition())
					inst.sg:GoToState("castspell")
					inst:AddTag("busy")
					if 200 - sanityCost > 0 then
						inst:DoTaskInTime(2, function()
							if inst.components.sanity.current > sanityCost then	
								inst.components.sanity:DoDelta(-1 * sanityCost)
							else
								local hppenalty = (inst.components.sanity.current - sanityCost)/2
								inst.components.sanity:DoDelta(-1 * inst.components.sanity.current)
								inst.components.health:DoDelta(hppenalty)
							end
							SpawnPrefab("slice").Transform:SetPosition(target.Transform:GetWorldPosition())
							target.components.health:SetVal(0, "boundary slice", inst)
							inst:PushEvent("killed", { victim = target })
							target = nil
							inst:RemoveTag("busy")
						end)
						return true
					else
						inst:DoTaskInTime(2, function()
							if inst.components.sanity.current >= 250 then	
								inst.components.sanity:DoDelta(-200)
							else
								local hppenalty = (inst.components.sanity.current - 200)/2
								inst.components.sanity:DoDelta(-1 * inst.components.sanity.current)
								inst.components.health:DoDelta(hppenalty)
							end
							SpawnPrefab("slice").Transform:SetPosition(target.Transform:GetWorldPosition())
							target.components.health:DoDelta(-1000)
							target.components.combat:GetAttacked(inst, 0.01)
							inst:RemoveTag("busy")
						end)
					end
				end
			end
		end
	else
		print("No target")
	end
	return false
end

local function coop(inst)
	local n =0
    local x, y, z = inst.Transform:GetWorldPosition()
    local ents = TheSim:FindEntities(x, y, z, 15)
    for k,v in pairs(ents) do
		if v:HasTag("renko") then
			n = n+1
		end
	end
	if n > 0 then
		inst.components.locomotor.walkspeed = 1.3 * TUNING.WILSON_WALK_SPEED
		inst.components.locomotor.runspeed = 1.3 * TUNING.WILSON_RUN_SPEED
		inst.components.combat.damagemultiplier = 1.0
		inst.components.sanity.dapperness = (TUNING.DAPPERNESS_LARGE)
	else
		inst.components.locomotor.walkspeed = 1.1 * TUNING.WILSON_WALK_SPEED
		inst.components.locomotor.runspeed = 1.1 * TUNING.WILSON_RUN_SPEED
		inst.components.combat.damagemultiplier = 0.7
		inst.components.sanity.dapperness = 0
	end
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)

    if not inst:HasTag("playerghost") then
        onbecamehuman(inst)
    end
end


-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "merry.tex" )
	inst.slice = slice
	inst:AddTag("hifuu_builder")
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "willow"
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
	inst.components.health:SetMaxHealth(100)
	inst.components.hunger:SetMax(90)
	inst.components.sanity:SetMax(250)
	inst.components.sanity.neg_aura_mult = 0

	inst:AddTag("merry")	
	inst:AddTag("hifuu_builder")
	inst.components.locomotor.walkspeed = 1.1 * TUNING.WILSON_WALK_SPEED
	inst.components.locomotor.runspeed = 1.1 * TUNING.WILSON_RUN_SPEED
	inst.components.combat.damagemultiplier = 0.7
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 0.9 * TUNING.WILSON_HUNGER_RATE
	
    local rt = 4
    inst:DoPeriodicTask(rt, function() coop(inst, rt) end)
	
	inst.components.builder.science_bonus = 1
	inst.components.builder.magic_bonus = 1
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
	
end

return MakePlayerCharacter("merry", prefabs, assets, common_postinit, master_postinit, start_inv)
