
local MakePlayerCharacter = require "prefabs/player_common"
local CameraFollow = require "cameras/followcamera"


local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
}
local prefabs = {}

-- Custom starting items
local start_inv = {
	"hat_renko", "bomb"
}

-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when loading or reviving from ghost (optional)
	inst.components.locomotor.walkspeed = 1.1 * TUNING.WILSON_WALK_SPEED
	inst.components.locomotor.runspeed = 1.1 * TUNING.WILSON_RUN_SPEED
end

local function vision(inst)
	if TheWorld.state.isnight and not TheWorld:HasTag("cave") then
		inst.components.playervision:ForceNightVision(true)
        inst.components.playervision:SetCustomCCTable("images/colour_cubes/purple_moon_cc.tex")
    else
        inst.components.playervision:ForceNightVision(false)
        inst.components.playervision:SetCustomCCTable(nil)
	end
end

local function coop(inst)
	local n =0
    local x, y, z = inst.Transform:GetWorldPosition()
    local ents = TheSim:FindEntities(x, y, z, 15)
    for k,v in pairs(ents) do
		if v:HasTag("merry") then
			n = n+1
		end
	end
	if n > 0 then
		inst.components.locomotor.walkspeed = 1.3 * TUNING.WILSON_WALK_SPEED
		inst.components.locomotor.runspeed = 1.3 * TUNING.WILSON_RUN_SPEED
		inst.components.combat.damagemultiplier = 1.3
		inst.components.sanity.dapperness = (TUNING.DAPPERNESS_LARGE) + (TUNING.DAPPERNESS_MED)
	else
		inst.components.locomotor.walkspeed = 1.1 * TUNING.WILSON_WALK_SPEED
		inst.components.locomotor.runspeed = 1.1 * TUNING.WILSON_RUN_SPEED
		inst.components.combat.damagemultiplier = 1.15
		inst.components.sanity.dapperness = (TUNING.DAPPERNESS_MED)
	end
		
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)

    if not inst:HasTag("playerghost") then
        onbecamehuman(inst)
    end
end


-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "renko.tex" )
	inst:AddTag("hifuu_builder")
    local rt = 2
    inst:DoPeriodicTask(rt, function() vision(inst, rt) end)
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "willow"
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
	inst.components.health:SetMaxHealth(125)
	inst.components.hunger:SetMax(100)
	inst.components.sanity:SetMax(150)

	inst:AddTag("renko")
	inst:AddTag("hifuu_builder")
	inst.components.sanity.dapperness = (TUNING.DAPPERNESS_MED)
	
	inst.components.locomotor.walkspeed = 1.1 * TUNING.WILSON_WALK_SPEED
	inst.components.locomotor.runspeed = 1.1 * TUNING.WILSON_RUN_SPEED
	inst.components.combat.damagemultiplier = 1.15
	inst.components.combat:SetRange(2.5, 2.5)
	inst.components.combat.min_attack_period = 0.35
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1.1 * TUNING.WILSON_HUNGER_RATE
	
    local rt = 2
    inst:DoPeriodicTask(rt, function() coop(inst, rt) end)
		
	inst.components.builder.science_bonus = 2
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
end

return MakePlayerCharacter("renko", prefabs, assets, common_postinit, master_postinit, start_inv)
