local assets =
{
    Asset("ANIM", "anim/slice.zip"),
}

local prefabs =
{
}

local function dull1(inst)
	inst.AnimState:SetMultColour(0.9,0.9,0.9,0.9)
end
local function dull2(inst)
	inst.AnimState:SetMultColour(0.8,0.8,0.8,0.8)
end
local function dull3(inst)
	inst.AnimState:SetMultColour(0.7,0.7,0.7,0.7)
end
local function dull4(inst)
	inst.AnimState:SetMultColour(0.6,0.6,0.6,0.6)
end
local function dull5(inst)
	inst.AnimState:SetMultColour(0.5,0.5,0.5,0.5)
end
local function dull6(inst)
	inst.AnimState:SetMultColour(0.4,0.4,0.4,0.4)
end
local function dull7(inst)
	inst.AnimState:SetMultColour(0.3,0.3,0.3,0.3)
end
local function dull8(inst)
	inst.AnimState:SetMultColour(0.2,0.2,0.2,0.2)
end
local function dull9(inst)
	inst.AnimState:SetMultColour(0.1,0.1,0.1,0.1)
end
-------------------------------------------------------------------------------

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    inst.AnimState:SetBank("slice")
    inst.AnimState:SetBuild("slice")
    inst.AnimState:PlayAnimation("idle")
	inst.Transform:SetScale(1.5, 1.5, 1.5)
	inst.AnimState:SetMultColour(1,1,1,1)
    inst.Transform:SetEightFaced()

    inst:AddTag("FX")
    inst:AddTag("NOCLICK")
	
    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
    inst:DoTaskInTime(1.35, dull1)
	inst:DoTaskInTime(1.4, dull2)
	inst:DoTaskInTime(1.45, dull3)
	inst:DoTaskInTime(1.5, dull4)	
    inst:DoTaskInTime(1.55, dull5)
	inst:DoTaskInTime(1.6, dull6)
	inst:DoTaskInTime(1.65, dull7)
	inst:DoTaskInTime(1.7, dull8)
	inst:DoTaskInTime(1.75, dull9)
    inst:DoTaskInTime(1.8, inst.Remove)
    return inst
end

return Prefab("slice", fn, assets, prefabs)
