require = GLOBAL.require
GetPlayer = GLOBAL.GetPlayer
STRINGS = GLOBAL.STRINGS
RECIPETABS = GLOBAL.RECIPETABS
Recipe = GLOBAL.Recipe
Ingredient = GLOBAL.Ingredient
TECH = GLOBAL.TECH
ACTIONS = GLOBAL.ACTIONS
Vector3 = GLOBAL.Vector3
distsq = GLOBAL.distsq
GetWorld = GLOBAL.GetWorld
TUNING=GLOBAL.TUNING

PrefabFiles = {
	"beatrice",
	"honeywall",
	"stickystinger",
	"wasphiveplacer",
	"cloneegg",
}

Assets = {
    Asset( "IMAGE", "minimap/beatrice.tex" ),
    Asset( "ATLAS", "minimap/beatrice.xml" ),
    Asset( "IMAGE", "images/saveslot_portraits/beatrice.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/beatrice.xml" ),
    Asset( "IMAGE", "images/selectscreen_portraits/beatrice.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/beatrice.xml" ),
    Asset( "IMAGE", "images/selectscreen_portraits/beatrice_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/beatrice_silho.xml" ),
    Asset( "IMAGE", "bigportraits/beatrice.tex" ),
    Asset( "ATLAS", "bigportraits/beatrice.xml" ),
    Asset( "IMAGE", "images/inventoryimages/honeywall.tex" ),
    Asset( "ATLAS", "images/inventoryimages/honeywall.xml" ),
    Asset( "IMAGE", "images/inventoryimages/stickystinger.tex" ),
    Asset( "ATLAS", "images/inventoryimages/stickystinger.xml" ),
    Asset( "ANIM", "anim/beebadge.zip" ),
    Asset( "ATLAS", "images/inventoryimages/wasphiveinvent.xml" ),
    Asset( "IMAGE", "images/inventoryimages/wasphiveinvent.tex" ),
	Asset( "ANIM", "anim/cloneegg.zip" ),
    Asset( "ATLAS", "images/inventoryimages/cloneegginvent.xml" ),
    Asset( "IMAGE", "images/inventoryimages/cloneegginvent.tex" ),
    Asset( "IMAGE", "minimap/cloneegginvent.tex" ),
    Asset( "ATLAS", "minimap/cloneegginvent.xml" ),
}

AddMinimapAtlas("minimap/cloneegginvent.xml")
AddMinimapAtlas("minimap/beatrice.xml")

-- The character select screen lines
-- note: these are lower-case character name
STRINGS.CHARACTER_TITLES.beatrice = "۷Ů"
STRINGS.CHARACTER_NAMES.beatrice = "˹"

STRINGS.CHARACTER_DESCRIPTIONS.beatrice = "Buzz buzz buzz?\nBuzz.\nBuzz buzz buzz, buzz!"
STRINGS.CHARACTER_QUOTES.beatrice = "\"Buzz!\""

STRINGS.CHARACTERS.BEATRICE = require "speech_beatrice"

-- Possible genders here are MALE, FEMALE, or ROBOT
table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "beatrice")

AddModCharacter("beatrice")

STRINGS.NAMES.HONEYWALL = "䳲ǽ"
STRINGS.NAMES.HONEYWALL_ITEM = "䳲ǽ"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.HONEYWALL = "Buzz buzz, buzz."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.HONEYWALL_ITEM = "Buzz buzz, buzz."
STRINGS.RECIPE_DESC.HONEYWALL_ITEM = "Buzz buzz buzz, buzz!"

STRINGS.NAMES.STICKYSTINGER = "Ĵ"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.STICKYSTINGER = "Buzz buzz, buzz."
STRINGS.RECIPE_DESC.STICKYSTINGER = "Buzz buzz buzz, buzz!"

STRINGS.RECIPE_DESC.WASPHIVE = "Buzz!!! Buzz buzz!!!"

STRINGS.NAMES.CLONEEGG="¡"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CLONEEGG = "Buzz buzz, buzz."
STRINGS.RECIPE_DESC.CLONEEGG = "Buzz buzz buzz, buzz!"

AddSimPostInit(function(inst)
if GLOBAL.GetPlayer().prefab == "beatrice" then
local honeywall_item = Recipe( "honeywall_item", { Ingredient("honeycomb", 1), Ingredient("papyrus", 1), Ingredient("wall_hay_item", 4) }, RECIPETABS.TOWN, TECH.SCIENCE_ONE, nil,nil,nil,6 )
honeywall_item.atlas = GLOBAL.resolvefilepath("images/inventoryimages/honeywall.xml")
honeywall_item.image = "honeywall_item.tex"

local stickystinger = Recipe( "stickystinger", { Ingredient("cutreeds", 4), Ingredient("papyrus", 2), Ingredient("honey", 2) }, RECIPETABS.WAR, TECH.SCIENCE_TWO )
stickystinger.atlas = GLOBAL.resolvefilepath("images/inventoryimages/stickystinger.xml")
stickystinger.image = "stickystinger.tex"

local wasphive = Recipe("wasphive", {Ingredient("honeycomb", 2), Ingredient("honey", 6), Ingredient("bee", 6)}, RECIPETABS.WAR, TECH.SCIENCE_TWO, "wasphive_placer")
wasphive.atlas=GLOBAL.resolvefilepath("images/inventoryimages/wasphiveinvent.xml")
wasphive.image="wasphiveinvent.tex"

local cloneegg = Recipe("cloneegg", {Ingredient("honeycomb", 5), Ingredient("honey", 40), Ingredient("monstermeat", 10)}, RECIPETABS.SURVIVAL, TECH.MAGIC_TWO, "cloneegg_placer")
cloneegg.atlas=GLOBAL.resolvefilepath("images/inventoryimages/cloneegginvent.xml")
cloneegg.image="cloneegginvent.tex"
end
end)

--beatrice's bee hud:
AddSimPostInit(function(inst)
	if GetPlayer().prefab=="beatrice" and GetModConfigData("hudmode")>0 then
		local Widget = require "widgets/widget"
		local Badge = require "widgets/badge"
		local Text = require "widgets/text"
		local UIAnim = require "widgets/uianim"
		local easing = require "easing"
		local ImageButton = require "widgets/imagebutton"
	    Asset( "ANIM", "anim/beebadge.zip" )
		local beebadge = Class(Badge, function(self, owner)
			Badge._ctor(self, "beebadge", owner)
		end)
		local status = GLOBAL.GetPlayer().HUD.controls.status
		status.beebadge = status:AddChild(beebadge(owner))
--gui:
		if GetModConfigData("hudmode")==2 then

--button: call children home
		status.beebadge.bbcallhome = status:AddChild(ImageButton())
		status.beebadge.bbcallhome:SetHAnchor(GLOBAL.ANCHOR_MIDDLE)
		status.beebadge.bbcallhome:SetVAnchor(GLOBAL.ANCHOR_TOP)
		status.beebadge.bbcallhome:SetPosition(150,-25,0)
		status.beebadge.bbcallhome:SetScaleMode(GLOBAL.SCALEMODE_PROPORTIONAL)
		status.beebadge.bbcallhome:Enable()
		status.beebadge.bbcallhome:Show()
		status.beebadge.bbcallhome:SetClickable(true)
		status.beebadge.bbcallhome:SetTextSize(22)
		status.beebadge.bbcallhome:SetText("Ůؼ")
		status.beebadge.bbcallhome.image:SetScale(.75,.5,.5)
		status.beebadge.bbcallhome:SetOnClick(function(inst)
			for k,v in pairs(GetPlayer().components.childspawner.childrenoutside) do
				if v and v:IsValid() then
					v.components.homeseeker:GoHome()
				end
			end
		end)

--button: release children
		status.beebadge.bbrelease = status:AddChild(ImageButton())
		status.beebadge.bbrelease:SetHAnchor(GLOBAL.ANCHOR_MIDDLE)
		status.beebadge.bbrelease:SetVAnchor(GLOBAL.ANCHOR_TOP)
		status.beebadge.bbrelease:SetPosition(-142.5,-75,0)
		status.beebadge.bbrelease:SetScaleMode(GLOBAL.SCALEMODE_PROPORTIONAL)
		status.beebadge.bbrelease:Enable()
		status.beebadge.bbrelease:Show()
		status.beebadge.bbrelease:SetClickable(true)
		status.beebadge.bbrelease:SetTextSize(22)
		status.beebadge.bbrelease:SetText("ͷŮ")
		status.beebadge.bbrelease.image:SetScale(.75,.5,.5)
		status.beebadge.bbrelease:SetOnClick(function(inst)
			GetPlayer().disablespawning=false
			GetPlayer().components.childspawner:StartSpawning()
			if GLOBAL.GetClock():IsDay()==true or GLOBAL.GetClock():IsDusk()==true then
				GetPlayer().components.childspawner:ReleaseAllChildren()
			end
		end)

--button: pull in all bees
--disabled because too op
--[[
		status.beebadge.bbpullin = status:AddChild(ImageButton())
		status.beebadge.bbpullin:SetHAnchor(GLOBAL.ANCHOR_MIDDLE)
		status.beebadge.bbpullin:SetVAnchor(GLOBAL.ANCHOR_TOP)
		status.beebadge.bbpullin:SetPosition(150,-25,0)
		status.beebadge.bbpullin:SetScaleMode(GLOBAL.SCALEMODE_PROPORTIONAL)
		status.beebadge.bbpullin:Enable()
		status.beebadge.bbpullin:Show()
		status.beebadge.bbpullin:SetClickable(true)
		status.beebadge.bbpullin:SetTextSize(22)
		status.beebadge.bbpullin:SetText("Pull In All Bees")
		status.beebadge.bbpullin.image:SetScale(.75,.5,.5)
		status.beebadge.bbpullin:SetOnClick(function(inst)
			local pt=Vector3(GetPlayer().Transform:GetWorldPosition())
			if pt then
				local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, 30, function(inst) end)
				for i,ent in ipairs(ents) do
					if ent.prefab=="bee" or ent.prefab=="killerbee" then
						ent.components.locomotor:ResetPath()
						ent.components.locomotor:GoToEntity(GetPlayer())
					end
				end
			end
		end)
--]]

--button: stop spawning
		status.beebadge.bbstopspawning = status:AddChild(ImageButton())
		status.beebadge.bbstopspawning:SetHAnchor(GLOBAL.ANCHOR_MIDDLE)
		status.beebadge.bbstopspawning:SetVAnchor(GLOBAL.ANCHOR_TOP)
		status.beebadge.bbstopspawning:SetPosition(150,-75,0)
		status.beebadge.bbstopspawning:SetScaleMode(GLOBAL.SCALEMODE_PROPORTIONAL)
		status.beebadge.bbstopspawning:Enable()
		status.beebadge.bbstopspawning:Show()
		status.beebadge.bbstopspawning:SetClickable(true)
		status.beebadge.bbstopspawning:SetTextSize(22)
		status.beebadge.bbstopspawning:SetText("Ů")
		status.beebadge.bbstopspawning.image:SetScale(.75,.5,.5)
		status.beebadge.bbstopspawning:SetOnClick(function(inst)
			GetPlayer().disablespawning=true
			GetPlayer().components.childspawner:StopSpawning()
		end)

--button: push out all bees
		status.beebadge.bbpushout = status:AddChild(ImageButton())
		status.beebadge.bbpushout:SetHAnchor(GLOBAL.ANCHOR_MIDDLE)
		status.beebadge.bbpushout:SetVAnchor(GLOBAL.ANCHOR_TOP)
		status.beebadge.bbpushout:SetPosition(-142.5,-25,0)
		status.beebadge.bbpushout:SetScaleMode(GLOBAL.SCALEMODE_PROPORTIONAL)
		status.beebadge.bbpushout:Enable()
		status.beebadge.bbpushout:Show()
		status.beebadge.bbpushout:SetClickable(true)
		status.beebadge.bbpushout:SetTextSize(22)
		status.beebadge.bbpushout:SetText("ƿ۷")
		status.beebadge.bbpushout.image:SetScale(.75,.5,.5)
		status.beebadge.bbpushout:SetOnClick(function(inst)
			local pt=Vector3(GetPlayer().Transform:GetWorldPosition())
			if pt then
				local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, 15, function(inst) end)
				for i,ent in ipairs(ents) do
					if ent.prefab=="bee" or ent.prefab=="killerbee" then
						local angle = ent:GetAngleToPoint(pt.x,pt.y,pt.z)
						ent.components.locomotor:ResetPath()
						ent.components.locomotor:WalkInDirection(-angle-30)
--						ent.components.locomotor:GoToPoint(angle+50)
					end
				end
			end
		end)

--badge:
--		status.beebadge:SetTooltip("Bees Outside - Bees Inside\nTotal Bees")
		status.beebadge.num = status.beebadge:AddChild(Text(GLOBAL.BODYTEXTFONT, 26))
		status.beebadge.num:SetPosition(4, 0, 0)
		if not status.beebadge.num2 then
			status.beebadge.num2 = status.beebadge:AddChild(Text(GLOBAL.BODYTEXTFONT, 26))
			status.beebadge.num2:SetHAlign(GLOBAL.ANCHOR_MIDDLE)
			status.beebadge.num2:SetPosition(4, 0, 0)
			status.beebadge.num2:Hide()
		end
		GetPlayer():DoPeriodicTask(0, function(inst)
			local badgebgpercent=GetPlayer().components.childspawner.timetonextregen
			local totalchildren=GetPlayer().components.childspawner.numchildrenoutside+GetPlayer().components.childspawner.childreninside
			if totalchildren==GetPlayer().components.childspawner.maxchildren then
				badgebgpercent=GetPlayer().components.childspawner.timetonextregen/GetPlayer().components.childspawner.regenperiod
			else
				badgebgpercent=badgebgpercent-GetPlayer().components.childspawner.regenperiod
				badgebgpercent=badgebgpercent*-1
				badgebgpercent=badgebgpercent/GetPlayer().components.childspawner.regenperiod
			end
		    status.beebadge:SetPercent(badgebgpercent,GetPlayer().components.childspawner.regenperiod)
		    status.beebadge.num:SetString(tostring(GetPlayer().components.childspawner.numchildrenoutside.."\183"..GetPlayer().components.childspawner.childreninside))
			status.beebadge.num2:SetString(tostring(GetPlayer().components.childspawner.maxchildren))
		end)
	    status.beebadge.anim:GetAnimState():SetBank("health")
    	status.beebadge.anim:GetAnimState():SetBuild("beebadge")
    	status.beebadge.anim:GetAnimState():PlayAnimation("anim")
		status.beebadge.anim:SetHAnchor(GLOBAL.ANCHOR_MIDDLE)
		status.beebadge.anim:SetVAnchor(GLOBAL.ANCHOR_TOP)
		status.beebadge.anim:SetPosition(0,-50,0)
		status.beebadge.anim:SetScaleMode(GLOBAL.SCALEMODE_PROPORTIONAL)
		status.beebadge:SetHAnchor(GLOBAL.ANCHOR_MIDDLE)
		status.beebadge:SetVAnchor(GLOBAL.ANCHOR_TOP)
		status.beebadge:SetPosition(0,-50,0)
		status.beebadge:SetScaleMode(GLOBAL.SCALEMODE_PROPORTIONAL)
		function status.beebadge:OnGainFocus()
		    Badge._base.OnGainFocus(self)
			status.beebadge.isfocused=true
		    self.num:Hide()
			self.num2:Show()
		end
		function status.beebadge:OnLoseFocus()
		    Badge._base.OnLoseFocus(self)
			status.beebadge.isfocused=false
		    self.num:Show()
			self.num2:Hide()
		end
		status.beebadge.num:Show()
		status.beebadge.anim:Show()
		end


--text:
		if GetModConfigData("hudmode")==1 then
--inside:
		status.beebadge.inside=status:AddChild(Text(GLOBAL.BODYTEXTFONT,24))
		status.beebadge.inside:SetHAnchor(GLOBAL.ANCHOR_MIDDLE)
		status.beebadge.inside:SetVAnchor(GLOBAL.ANCHOR_TOP)
		status.beebadge.inside:SetPosition(0,-20,0)
		status.beebadge.inside:SetScaleMode(GLOBAL.SCALEMODE_PROPORTIONAL)
--outside:
		status.beebadge.outside=status:AddChild(Text(GLOBAL.BODYTEXTFONT,24))
		status.beebadge.outside:SetScaleMode(GLOBAL.SCALEMODE_PROPORTIONAL)
		status.beebadge.outside:SetHAnchor(GLOBAL.ANCHOR_MIDDLE)
		status.beebadge.outside:SetVAnchor(GLOBAL.ANCHOR_TOP)
		status.beebadge.outside:SetPosition(0,-50,0)
--respawn counter:
		status.beebadge.respawnin=status:AddChild(Text(GLOBAL.BODYTEXTFONT,20))
		status.beebadge.respawnin:SetHAnchor(GLOBAL.ANCHOR_MIDDLE)
		status.beebadge.respawnin:SetVAnchor(GLOBAL.ANCHOR_TOP)
		status.beebadge.respawnin:SetPosition(0,-77.5,0)
		status.beebadge.respawnin:SetScaleMode(GLOBAL.SCALEMODE_PROPORTIONAL)

--updater:
		GetPlayer():DoPeriodicTask(0, function(inst)
			local inside=tostring(GetPlayer().components.childspawner.childreninside)
			local total=tostring(GetPlayer().components.childspawner.maxchildren)
			local outside=tostring(GetPlayer().components.childspawner.numchildrenoutside)
			status.beebadge.inside:SetString("BEES INSIDE BEATRICE: "..inside.."/"..total)
			status.beebadge.outside:SetString("BEES OUTSIDE: "..outside)
			local totalchildren=GetPlayer().components.childspawner.numchildrenoutside+GetPlayer().components.childspawner.childreninside
			if totalchildren<GetPlayer().components.childspawner.maxchildren then
				status.beebadge.respawnin:Show()
				local progresspercent=GetPlayer().components.childspawner.timetonextregen/GetPlayer().components.childspawner.regenperiod
				progresspercent=progresspercent*100
				if progresspercent>90 then
					status.beebadge.respawnin:SetString("NEW BEE PROGRESS: (..........)")
				end
				if progresspercent<90 and progresspercent>80 then
					status.beebadge.respawnin:SetString("NEW BEE PROGRESS: (:.........)")
				end
				if progresspercent<80 and progresspercent>70 then
					status.beebadge.respawnin:SetString("NEW BEE PROGRESS: (::........)")
				end
				if progresspercent<70 and progresspercent>60 then
					status.beebadge.respawnin:SetString("NEW BEE PROGRESS: (:::.......)")
				end
				if progresspercent<60 and progresspercent>50 then
					status.beebadge.respawnin:SetString("NEW BEE PROGRESS: (::::......)")
				end
				if progresspercent<50 and progresspercent>40 then
					status.beebadge.respawnin:SetString("NEW BEE PROGRESS: (:::::.....)")
				end
				if progresspercent<40 and progresspercent>30 then
					status.beebadge.respawnin:SetString("NEW BEE PROGRESS: (::::::....)")
				end
				if progresspercent<30 and progresspercent>20 then
					status.beebadge.respawnin:SetString("NEW BEE PROGRESS: (:::::::...)")
				end
				if progresspercent<20 and progresspercent>10 then
					status.beebadge.respawnin:SetString("NEW BEE PROGRESS: (::::::::..)")
				end
				if progresspercent<10 then
					status.beebadge.respawnin:SetString("NEW BEE PROGRESS: (:::::::::.)")
				end
			else
				status.beebadge.respawnin:Hide()
			end
		end)
		end
	end
end)
--/beatrice's hud

--make waspnests target more than just the player:
AddPrefabPostInit("wasphive", function(inst)
	if GLOBAL.GetPlayer().prefab == "beatrice" then
		inst.components.lootdropper:SetLoot({})
		inst.components.playerprox:SetOnPlayerNear(function() end)
		inst:DoPeriodicTask(.5, function(inst)
		local pt=Vector3(inst.Transform:GetWorldPosition())
			if pt then
				local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, 8, function(inst) end)
				for i,ent in ipairs(ents) do
					if ent.components.combat and ent.components.health and not ent:HasTag("structure") and ent.prefab~="bee" and ent.prefab~="killerbee" and ent.prefab~="beatrice" and ent.prefab~="butterfly" then
						if (ent.components.inventoryitem and ent.components.inventoryitem:IsHeld()==true) or (ent.components.follower and ent.components.follower.leader and ent.components.follower.leader.prefab=="beatrice") or (ent.components.follower and ent.components.follower.leader and ent.components.follower.leader.components.inventoryitem.owner.prefab=="beatrice") then
						else
							if inst.components.childspawner then
--print("targeting "..ent.prefab)
								inst.components.childspawner:ReleaseAllChildren(ent, "killerbee")
							end
						end
					end
				end
			end
		end)
	end
end)

local function makehoneyrepairable(inst)
	inst:AddComponent("repairable")
	inst.components.repairable.repairmaterial = "honey"
	inst.components.repairable.onrepaired = function(inst)
		if data and data.buildsound then
			inst.SoundEmitter:PlaySound(data.buildsound)		
		end
	end
end
AddPrefabPostInit("wasphive", makehoneyrepairable)
AddPrefabPostInit("beehive", makehoneyrepairable)
AddPrefabPostInit("beebox", makehoneyrepairable)

AddSimPostInit(function(inst)
	if GetPlayer().prefab=="beatrice" then
		STRINGS.RECIPE_DESC.BUTTERFLY = "Pull it's wings off, it becomes a butterwalk!"
		Recipe("butterfly", {Ingredient("petals", 3)}, RECIPETABS.REFINE, TECH.SCIENCE_ONE)
		Recipe("beemine", {Ingredient("log", 3),Ingredient("bee", 2),Ingredient("flint", 1)}, RECIPETABS.WAR, TECH.SCIENCE_ONE)
	end
end)

AddPrefabPostInit("honey", function(inst)
	if GetPlayer().prefab=="beatrice" then
		inst.components.edible.hungervalue=15
		inst.components.edible.healthvalue=5
		inst:AddComponent("repairer")
	    inst.components.repairer.repairmaterial = "honey"
--default is health/6:
		inst.components.repairer.healthrepairvalue = GLOBAL.TUNING.HAYWALL_HEALTH/12
	end
end)
AddPrefabPostInit("honeycomb", function(inst)
	if GetPlayer().prefab=="beatrice" then
		inst:AddComponent("edible")
		inst.components.edible.hungervalue=40
		inst.components.edible.healthvalue=25
	end
end)

local function winterspawner(inst)
	if GetPlayer().prefab=="beatrice" then
		inst:DoPeriodicTask(1, function(inst)
			if inst.components.childspawner and GetClock():IsDay() then
				inst.components.childspawner:StartSpawning()
			end
		end)
	end
end
AddPrefabPostInit("beebox", winterspawner)
AddPrefabPostInit("beehive", winterspawner)
AddPrefabPostInit("cave_entrance", function(inst) if GetPlayer().prefab=="beatrice" and GetModConfigData("nocaves")==false then inst:Remove() end end)
AddPrefabPostInit("bee", function(inst)
	if GetPlayer().prefab=="beatrice" then
		local function beeonsave(inst,data)
			data.xdefaultwalkspeed=inst.components.locomotor.xdefaultwalkspeed or TUNING.WILSON_WALK_SPEED
			data.walkspeed=inst.components.locomotor.walkspeed
		end
		local function beeonload(inst,data)
			if data and data.xdefaultwalkspeed and data.walkspeed then
				inst.components.locomotor.xdefaultwalkspeed=data.xdefaultwalkspeed or TUNING.WILSON_WALK_SPEED
				inst.components.locomotor.walkspeed=data.walkspeed or TUNING.WILSON_WALK_SPEED
			end
		end
		inst.OnSave=beeonsave
		inst.OnLoad=beeonload
		inst.components.health.canmurder=false
		inst:AddComponent("sanityaura")
		inst.components.sanityaura.aura = TUNING.SANITYAURA_TINY*.7
		inst:DoTaskInTime(1, function(inst)
			if inst.components.homeseeker and inst.components.homeseeker.home == GetPlayer() then
				inst.xwalkspeedsetup=true
				inst.components.locomotor.xdefaultwalkspeed=8
			end
		end)
		inst:DoPeriodicTask(.5, function(inst)
			if inst.components.homeseeker and inst.components.homeseeker.home == GetPlayer() then
				local playerpos=GetPlayer():GetPosition()
				local beepos=inst:GetPosition()
				if playerpos and beepos then
					if distsq(playerpos, beepos) > 900 and distsq(playerpos, beepos) < 1400 then
						inst.components.locomotor:ResetPath()
						inst.components.homeseeker:GoHome()
					end
					if distsq(playerpos, beepos) >= 1400 then
						GetPlayer().components.childspawner:GoHome(inst)
					end
				end
				if GetPlayer():HasTag("beatriceinwormhole") then
					GetPlayer().components.childspawner:GoHome(inst)
				end
			end
		end)
		if inst.components.homeseeker and inst.components.homeseeker.home.prefab == GetPlayer().prefab then
			inst.components.locomotor.xdefaultwalkspeed=8
			inst.components.locomotor.walkspeed=8
			inst:ListenForEvent("worked", function(inst)
				if child.components.homeseeker then
					child.components.homeseeker:SetHome(nil)
					child:RemoveComponent("homeseeker")
					GetPlayer().components.childspawner:OnChildKilled(child)
				end
				inst.components.locomotor.xdefaultwalkspeed=TUNING.WILSON_WALK_SPEED
				inst.components.locomotor.walkspeed=TUNING.WILSON_WALK_SPEED
			end)
		else
			inst.components.locomotor.xdefaultwalkspeed=TUNING.WILSON_WALK_SPEED
			inst.components.locomotor.walkspeed=TUNING.WILSON_WALK_SPEED
		end
	end
end)
AddPrefabPostInit("killerbee", function(inst)
	if GetPlayer().prefab=="beatrice" then
		inst.components.health.canmurder=false
		inst.components.locomotor.xdefaultwalkspeed=8
		inst:AddComponent("sanityaura")
		inst.components.sanityaura.aura = TUNING.SANITYAURA_SMALL
	end
end)

--disabled cause it's kinda dumb:
function stingerproj(inst)
	if GetPlayer().prefab=="beatrice" then
    inst:AddComponent("equippable")
--    inst.components.equippable:SetOnEquip(onequip)
--    inst.components.equippable:SetOnUnequip(onunequip)
    inst.components.equippable.equipstack = true

	inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(10)
	inst.components.weapon:SetRange(8, 10)

	inst:AddComponent("projectile")
	inst.components.projectile:SetSpeed(60)
	inst.components.projectile:SetOnHitFn(function(inst, attacker, target)
		local impactfx = GLOBAL.SpawnPrefab("impact")
		if impactfx and attacker then
			local follower = impactfx.entity:AddFollower()
			follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
			impactfx:FacePoint(attacker.Transform:GetWorldPosition())
		end
		inst:Remove()
	end)
	inst:ListenForEvent("onthrown", function(inst, data)
		inst.AnimState:SetOrientation(1)
		local tarpos=data.target:GetPosition()
		local angle = inst:GetAngleToPoint(tarpos)
		inst.Transform:SetRotation(-angle)
	end)
	end
end
--AddPrefabPostInit("stinger", stingerproj)


local GetPlayer = GLOBAL.GetPlayer
local Combat = require "components/combat"
local ccanattack = Combat.CanAttack
function Combat.CanAttack(self, target)
	local asdf = ccanattack(self, target)
if GetPlayer().prefab=="beatrice" and target and self.inst then
		if target.prefab=="beatrice" then
			local pt=Vector3(GetPlayer().Transform:GetWorldPosition())
			local ents = GLOBAL.TheSim:FindEntities(pt.x, pt.y, pt.z, 17, function() end)
			for i,ent in ipairs(ents) do
				if ent.prefab=="bee" or ent.prefab=="killerbee" then
					ent.components.combat:SuggestTarget(self.inst)
				end
			end
		end
		if self.inst.prefab=="beatrice" then
			local pt=Vector3(GetPlayer().Transform:GetWorldPosition())
			local ents = GLOBAL.TheSim:FindEntities(pt.x, pt.y, pt.z, 17, function() end)
			for i,ent in ipairs(ents) do
				if ent.prefab=="bee" or ent.prefab=="killerbee" then
					ent.components.combat:SuggestTarget(target)
				end
			end
		end
--beatrice can't attack bees
		if self.inst.prefab=="beatrice" and (target.prefab=="bee" or target.prefab=="killerbee") then
			self.inst.components.combat:GiveUp()
			return false
		end
--prevent bees from attacking things
	if (self.inst.prefab=="bee" or self.inst.prefab=="killerbee") and GetPlayer().prefab=="beatrice" then
		if target.prefab=="beatrice" or target.prefab=="bee" or target.prefab=="killerbee" then
			self.inst.components.combat:GiveUp()
			return false
		end
		if target.components.follower and target.components.follower.leader and target.components.follower.leader==GetPlayer() then
			self.inst.components.combat:GiveUp()
			return false
		end
--finally got this if working:
		if target.components.follower and target.components.follower.leader and target.components.follower.leader.components.inventoryitem.owner.prefab=="beatrice" then
--old fallback if:
--		if target.prefab=="chester" or target.prefab=="glommer" then
			self.inst.components.combat:GiveUp()
			return false
		end
	end
--works great but op:
--	if self.inst.prefab=="beatrice" and target~=GetPlayer() then
--		self.inst.components.childspawner:ReleaseAllChildren(target, "bee")
--	end
end
	return asdf
end
local ccalcdamage = Combat.CalcDamage
function Combat.CalcDamage(self, target, weapon, multiplier)
	local asdf = ccalcdamage(self, target, weapon, multiplier)
	if GetPlayer().prefab=="beatrice" then
		if (self.inst.prefab=="bee" or self.inst.prefab=="killerbee") and target.prefab=="beatrice" then
			return 0
		end
		if (target.prefab=="bee" or target.prefab=="killerbee") and self.inst.prefab=="beatrice" then
			return 0
		end
		if (self.inst.prefab=="bee" or self.inst.prefab=="killerbee") and (target.prefab=="bee" or target.prefab=="killerbee") then

			return 0
		end
	end
	return asdf
end


local canbeeattacked = Combat.CanBeAttacked
function Combat.CanBeAttacked(self, attacker)
local asdf = canbeeattacked(self, attacker)
	if GetPlayer().prefab=="beatrice" then
		if attacker.prefab=="beatrice" and (self.inst.prefab=="bee" or self.inst.prefab=="killerbee") then
			return false
		end
--adding killer bees below used to make following guardian bees hostile to surrounding mobs, enabled for now
		if self.inst.prefab=="beatrice" and (attacker.prefab=="bee" or attacker.prefab=="killerbee") then
			return false
		end
		if (attacker.prefab=="bee" or attacker.prefab=="killerbee") and (self.inst.prefab=="bee" or self.inst.prefab=="killerbee") then
			return false
		end
	end
	return asdf
end

--[[
--trying to make the sticky stinger detect ammo
local forceattack = Combat.ForceAttack
function Combat.ForceAttack(self)
local asdf=forceattack(self)
	if self.attacker==GetPlayer() and GetPlayer().components.inventory.equipslots.hands and GetPlayer().components.inventory.equipslots.hands.prefab=="stickstinger" then
		if self.attacker.components.inventory:Has("honey", 1) and self.attacker.components.inventory:Has("stinger", 1) then
		else
			return false
		end
	end
	return asdf
end
--]]

--makes bees work in winter, made by me, gifted to Afro1967, got a "thanks"
require=GLOBAL.require
require "behaviours/chaseandattack"
require "behaviours/runaway"
require "behaviours/wander"
require "behaviours/doaction"
require "behaviours/findflower"
require "behaviours/panic"
BT=GLOBAL.BT
PriorityNode=GLOBAL.PriorityNode
Wander=GLOBAL.Wander
FindFlower=GLOBAL.FindFlower
IfNode=GLOBAL.IfNode
DoAction=GLOBAL.DoAction
RunAway=GLOBAL.RunAway
ChaseAndAttack=GLOBAL.ChaseAndAttack
WhileNode=GLOBAL.WhileNode
Panic=GLOBAL.Panic
GetClock=GLOBAL.GetClock
GetSeasonManager=GLOBAL.GetSeasonManager
local beecommon=require"brains/beecommon"
local BeeBrain=require"brains/beebrain"
AddBrainPostInit("beebrain", function(self, inst, data)
--
if GetPlayer().prefab=="beatrice" then
--
function BeeBrain.OnStart(self, inst, data)
	local MAX_CHASE_DIST = 15
	local MAX_CHASE_TIME = 8
	local RUN_AWAY_DIST = 6
	local STOP_RUN_AWAY_DIST = 10
    local clock = GetClock()
    local seasonmanager = GetSeasonManager()
    
    local root =
        PriorityNode(
        {
            WhileNode( function() return self.inst.components.health.takingfiredamage end, "OnFire", Panic(self.inst)),
            
            WhileNode( function() return self.inst.components.combat.target == nil or not self.inst.components.combat:InCooldown() end, "AttackMomentarily", ChaseAndAttack(self.inst, SpringMod(MAX_CHASE_TIME), SpringMod(MAX_CHASE_DIST)) ),
            WhileNode( function() return self.inst.components.combat.target and self.inst.components.combat:InCooldown() end, "Dodge", RunAway(self.inst, function() return self.inst.components.combat.target end, RUN_AWAY_DIST, STOP_RUN_AWAY_DIST) ),
            
            --ChaseAndAttack(self.inst, beecommon.MAX_CHASE_TIME),
            IfNode(function() return clock and not clock:IsDay() end, "IsNight",
                DoAction(self.inst, function() return beecommon.GoHomeAction(self.inst) end, "go home", true )),
            IfNode(function() return self.inst.components.pollinator:HasCollectedEnough() end, "IsFullOfPollen",
                DoAction(self.inst, function() return beecommon.GoHomeAction(self.inst) end, "go home", true )),
            IfNode(function() return seasonmanager and seasonmanager:IsWinter() end, "IsWinter",
                DoAction(self.inst, function() return end, "go home", true )),

            FindFlower(self.inst),
            Wander(self.inst, function() return self.inst.components.knownlocations:GetLocation("home") end, beecommon.MAX_WANDER_DIST)            
        },1)
    
    
    self.bt = BT(self.inst, root)
    
end
--
end
--
end)
function SpringMod(amt)
	if (GLOBAL.IsDLCEnabled(1)) then
		if GetSeasonManager() and GetSeasonManager():IsSpring() then
			return amt * TUNING.SPRING_COMBAT_MOD
		end
	else
		return amt
	end
end
AddPrefabPostInit("bee", function(inst)
	inst:RestartBrain()
end)


--debug tools
--[[
GetPlayer = GLOBAL.GetPlayer
GLOBAL.require("debugkeys")
local function spawnt(player)
	GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_T, function(down)
		GLOBAL.DebugSpawn("honey")
--		GLOBAL.DebugSpawn("deerclops")
	end)
end
AddSimPostInit(spawnt)
GetPlayer = GLOBAL.GetPlayer
GLOBAL.require("debugkeys")
local function spawnr(player)
	GLOBAL.TheInput:AddKeyDownHandler(GLOBAL.KEY_R, function(down)
--		print("children outside: " .. GetPlayer().components.childspawner.numchildrenoutside .. " children inside: " .. GetPlayer().components.childspawner.childreninside)
		GLOBAL.DebugSpawn("cloneegg")
	end)
end
AddSimPostInit(spawnr)
--]]
