local MakePlayerCharacter = require "prefabs/player_common"

local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/beatrice.zip" )
}
local prefabs =
{
}

start_inv =
{
	"honeycomb",
	"beebox_blueprint",
	"boards_blueprint",
	"bugnet_blueprint",
	"rope",
	"butterfly",
	"butterfly",
	"butterfly",
	"bee",
	"bee",
--	"bugnet",
}

local function OnLoad(inst, data)
	if data and data.pollencounter then
		inst.pollencounter=data.pollencounter
	else
		inst.pollencounter=0
	end
end
local function OnSave(inst, data)
		data.pollencounter=inst.pollencounter
end

local fn = function(inst)
	inst.name="Beatrice"
	inst.components.sanity:SetMax(50)
	inst.components.health:SetMaxHealth(75)
	inst.components.hunger:SetMax(100)

	inst.soundsname = "wendy"

	inst.MiniMapEntity:SetIcon( "beatrice.tex" )

	inst.components.combat.damagemultiplier=.34
    inst.components.eater.foodprefs = { "VEGGIE", "INSECT", "SEEDS", "GENERIC" }

	inst:ListenForEvent("doattack", function(inst)
		local pt=Vector3(GetPlayer().Transform:GetWorldPosition())
		local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, 15, function() end)
		for i,ent in ipairs(ents) do
			if ent.prefab=="bee" or ent.prefab=="killerbee" then
				ent.components.combat:SuggestTarget(inst.components.combat.target)
			end
		end
	end)

	inst:ListenForEvent("wormholespit", function(inst)
		inst:AddTag("beatriceinwormhole")
		inst:DoTaskInTime(2, function(inst)
			inst:RemoveTag("beatriceinwormhole")
		end)
	end)

	inst:AddComponent("childspawner")
	inst.components.childspawner:SetMaxChildren(13)
	inst.components.childspawner.childname="bee"
	inst.components.childspawner.spawnperiod=5
	inst.components.childspawner.regening=true
	inst.components.childspawner:SetRegenPeriod(45,0)
	inst.components.childspawner.regenvariance=.01
	inst.components.childspawner.spawnoffscreen=false
	inst.components.childspawner:SetSpawnedFn(function(inst, child)
--print(tostring(child.components.homeseeker.home).." "..tostring(GetPlayer()))
		child.components.locomotor.walkspeed=8
		child.components.locomotor.xdefaultwalkspeed=8
		child.xwalkspeedsetup=true
		child:ListenForEvent("worked", function(child)
			if child.components.homeseeker and child.components.homeseeker.home == GetPlayer() then
				child.components.homeseeker:SetHome(nil)
				child:RemoveComponent("homeseeker")
				child.components.locomotor.xdefaultwalkspeed=TUNING.WILSON_WALK_SPEED
				child.components.locomotor.walkspeed=TUNING.WILSON_WALK_SPEED
				GetPlayer().components.childspawner:OnChildKilled(child)
			end
		end)
		child:DoPeriodicTask(.5, function(child)
			if inst.components.homeseeker and inst.components.homeseeker.home == GetPlayer() then
				local playerpos=GetPlayer():GetPosition()
				local beepos=inst:GetPosition()
				if playerpos and beepos then
					if distsq(playerpos, beepos) > 900 and distsq(playerpos, beepos) < 1400 then
						inst.components.locomotor:ResetPath()
						inst.components.homeseeker:GoHome()
					end
					if distsq(playerpos, beepos) >= 1400 then
						GetPlayer().components.childspawner:GoHome(inst)
					end
				end
				if GetPlayer():HasTag("beatriceinwormhole") then
--				local pt = Vector3(GetPlayer().Transform:GetWorldPosition())
--				child.Transform:SetPosition(pt.x,pt.y,pt.z)
					GetPlayer().components.childspawner:GoHome(child)
				end
			end
		end)
	end)
	inst.disablespawning=false
	inst:DoPeriodicTask(1, function(inst)
		if GetClock():IsDay()==true and inst.disablespawning~=true then
--print("is spawning")
			inst.components.childspawner:StartSpawning()
		else
			inst.components.childspawner:StopSpawning()
		end
	end)
--    inst:ListenForEvent("dusktime", function() inst.components.childspawner:StopSpawning() end, GetWorld())
--    inst:ListenForEvent("daytime", function() inst.components.childspawner:StartSpawning() end , GetWorld())

	inst.components.combat:SetOnHit(function(inst, attacker)
		inst.components.childspawner:ReleaseAllChildren(attacker,"bee")
	end)

	inst.pollencooldown=0
	inst:DoPeriodicTask(1, function(inst)
		inst.pollencooldown=inst.pollencooldown-1
		if inst.pollencooldown<0 then
			inst.pollencooldown=0
		end
	end)
	inst:ListenForEvent("childgoinghome", function(inst, data)
		if data.child and data.child.components.pollinator and data.child.components.pollinator:HasCollectedEnough() then
			inst.pollencounter=inst.pollencounter+1
			inst.components.hunger:DoDelta(.2, true)
			inst.components.health:DoDelta(.5, true)
			inst.components.sanity:DoDelta(1, true)
			if inst.pollencounter>=5 and inst.pollencooldown<1 then
				if math.random(15)==1 then
					inst.components.inventory:GiveItem(SpawnPrefab("honeycomb"))
				else
					inst.components.inventory:GiveItem(SpawnPrefab("honey"))
				end
				inst.pollencooldown=45
				inst.pollencounter=0
			end
		end
	end)

	inst.warriorbees=0
	inst.maxwarriorbees=2
	inst.beespeedbuff=14
	inst:DoPeriodicTask(.25, function(inst)
		local pt=Vector3(inst.Transform:GetWorldPosition())
		if pt then
		local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, 11, function(inst) end)
		for i,ent in ipairs(ents) do
			if ent.prefab=="bee" or ent.prefab=="killerbee" then
--health regen:
				if ent.components.health and ent.components.health.currenthealth>0 then
					ent.components.health:DoDelta(.05)
				end

--speed boosts:
				if not ent.xwalkspeedsetup then
					ent.xwalkspeedsetup=true
					ent.components.locomotor.xdefaultwalkspeed=ent.components.locomotor.walkspeed
				end
				local playerpos=GetPlayer():GetPosition()
				local beepos=ent:GetPosition()
				if playerpos and beepos then
					if distsq(playerpos, beepos) <= 75 then
						ent.components.locomotor.walkspeed=GetPlayer().beespeedbuff
					end
				end
				ent:DoTaskInTime(.1, function(inst)
					local playerpos=GetPlayer():GetPosition()
					local beepos=inst:GetPosition()
					if playerpos and beepos then
						if distsq(playerpos, beepos) > 75 then
							if inst.components.locomotor.xdefaultwalkspeed then
								inst.components.locomotor.walkspeed=inst.components.locomotor.xdefaultwalkspeed
							end
						end
					end
				end)
--recruit guardians:
				if ent.prefab=="killerbee" and not ent.components.homeseeker then
					if inst.warriorbees<inst.maxwarriorbees then
						ent:AddComponent("homeseeker")
						ent.components.homeseeker:SetHome(inst)
--						ent:AddComponent("follower")
--						inst.components.leader:AddFollower(ent)
						inst.warriorbees=inst.warriorbees+1
						if not ent.warriorsetup then
							ent.warriorsetup=true
--make guardians passive:
							ent.components.combat.targetfn=nil
							ent.components.locomotor.walkspeed=8
							ent.components.locomotor.xdefaultwalkspeed=8
							ent:ListenForEvent("death", function(inst) GetPlayer().warriorbees=GetPlayer().warriorbees-1 end)
							ent:DoPeriodicTask(.5, function(inst)
								if GetPlayer():HasTag("beatriceinwormhole") then
									local pt=Vector3(GetPlayer().Transform:GetWorldPosition())
									inst.Transform:SetPosition(pt.x, pt.y, pt.z)
								end
							end)

--make guardians back off
							ent:DoPeriodicTask(.1, function(inst)
								local playerpos=GetPlayer():GetPosition()
								local beepos=inst:GetPosition()
								if playerpos and beepos then
									if distsq(playerpos, beepos)<10 then
--										local angle = inst:GetAngleToPoint(playerpos)
--										inst.components.locomotor:WalkInDirection(angle + 50)
										inst.components.homeseeker:SetHome(nil)
									else
--									inst:DoTaskInTime(.1, function(inst)
										inst.components.locomotor:ResetPath()
										inst.components.homeseeker:SetHome(GetPlayer())
--										end)
									end

--teleport guardians back to player if they go too far away
									if distsq(playerpos, beepos)>1400 then
										inst.Transform:SetPosition(playerpos.x,playerpos.y,playerpos.z)
									end
								end
							end)
						end
					else

--replace unrecruitable killer bees with normal
						local kb=SpawnPrefab("bee")
						local kbpt=Vector3(ent.Transform:GetWorldPosition())
						kb.Transform:SetPosition(kbpt:Get())
						ent:Remove()
					end
				end

--obsolete, only here as a reference
--[[
				if ent.components.follower then
					if not ent.leaderset or ent.leaderset==false then
						ent.leaderset=true
						ent.components.follower:SetLeader(inst)
						ent.xdefaultspeed=ent.components.locomotor.walkspeed
						ent.components.locomotor.walkspeed=inst.beespeedbuff
						if not ent.lfellsetup then
							ent.lfellsetup=true
							ent:ListenForEvent("loseloyalty", function(inst)
								ent.components.locomotor.walkspeed=ent.xdefaultspeed
								ent.leaderset=false
--								ent:DoTaskInTime(.1, function(inst)
--									ent:RemoveComponent("follower")
--								end)
							end)
						end
					end
					if ent.components.follower then
						ent.components.follower:AddLoyaltyTime(1)
					end
				else
--					ent:AddComponent("follower")
--					ent.components.follower.maxfollowtime=1
				end
--]]

			end
		end
	end
	end)

	inst.OnLoad=OnLoad
	inst.OnSave=OnSave

end

return MakePlayerCharacter("beatrice", prefabs, assets, fn, start_inv)
