require "prefabutil"

local assets=
{
	Asset("ANIM", "anim/cloneegg.zip"),
	Asset("ANIM", "anim/ui_chest_3x2.zip"),
	Asset("SOUND", "sound/chester.fsb"),
}

local function OnOpen(inst, opener)
    if not inst.components.health:IsDead() then
		inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/open")
		inst.AnimState:PlayAnimation("cocoon_small_hit")
    end
end 
local function OnClose(inst) 
    if not inst.components.health:IsDead() then
		inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/close")
		inst.AnimState:PlayAnimation("cocoon_small_hit")
    end
end

local function itemtest(inst, item, slot)
	return item.prefab == "honey" or item.prefab == "honey_crystal"
end
local function itemtest2(inst, item, slot)
	return item.prefab == "honey" or item.prefab == "honey_crystal" or item.prefab == "honeycomb"
end

local slotpos = {}
--one dead center:
--for y = 1, 1, -1 do
--    for x = 1, 1 do
--3 across dead center:
for y = 1, 1, -1 do
    for x = 0, 2 do
        table.insert(slotpos, Vector3(80*x-80*2+80, 80*y-80*2+80,1))
    end
end

local function makeused(inst)
	inst.AnimState:PlayAnimation("debris")
	inst.components.resurrector.penalty = 0	
end

local function doresurrect(inst, dude)
	inst:AddTag("busy")	
	inst.MiniMapEntity:SetEnabled(false)
    inst:RemoveComponent("inspectable")
    if inst.Physics then
		RemovePhysicsColliders(inst)
    end

	GetClock():MakeNextDay()
    dude.Transform:SetPosition(inst.Transform:GetWorldPosition())
    dude:Hide()
    TheCamera:SetDistance(12)
	dude.components.hunger:Pause()
	
    scheduler:ExecuteInTime(3, function()
        dude:Show()

        GetSeasonManager():DoLightningStrike(Vector3(inst.Transform:GetWorldPosition()))

        inst.components.container:DropEverything()
		inst.components.container.itemtestfn = itemtest2
        inst.components.container:GiveItem(SpawnPrefab("honeycomb"),2)
        inst.components.container:GiveItem(SpawnPrefab("honey"),3)
        inst.components.container:GiveItem(SpawnPrefab("honey"),3)
        inst.components.container:GiveItem(SpawnPrefab("honey"),3)
        inst.components.container:GiveItem(SpawnPrefab("honey"),3)
        inst.components.container:GiveItem(SpawnPrefab("honey"),3)
        inst.components.container:DropEverything()

		SpawnPrefab("collapse_big").Transform:SetPosition(inst.Transform:GetWorldPosition())
		inst.SoundEmitter:PlaySound("dontstarve/common/resurrectionstone_break")
        inst.components.container:DropEverything()
        inst:Remove()

        if dude.components.hunger then
            dude.components.hunger:SetPercent(2/3)
        end

        if dude.components.health then
            dude.components.health:Respawn(TUNING.RESURRECT_HEALTH)
        end
        
        if dude.components.sanity then
			dude.components.sanity:SetPercent(.5)
        end
        
        dude.components.hunger:Resume()
        
        dude.sg:GoToState("wakeup")

        dude:DoTaskInTime(3, function(inst) 
		            if dude.HUD then
		                dude.HUD:Show()
		            end
		            TheCamera:SetDefault()
		            inst:RemoveTag("busy")
        end)
	end)
end

local function onbuilt(inst)
	inst.AnimState:PlayAnimation("grow_sac_to_small")
	inst.AnimState:PushAnimation("cocoon_small", false)
end

local function fn(Sim)
	local inst = CreateEntity()
	
    inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddMiniMapEntity()
	inst.entity:AddSoundEmitter()
    
    MakeObstaclePhysics(inst, .5)

	inst.MiniMapEntity:SetIcon( "cloneegginvent.tex" )
    inst:AddTag("structure")
    
    inst.AnimState:SetBank("spider_cocoon")
    inst.AnimState:SetBuild("cloneegg")
    inst.AnimState:PlayAnimation("cocoon_small")

	inst.name="Clone Egg"

    inst:AddComponent("inspectable")
    inst:AddComponent("resurrector")
    inst.components.resurrector.active = true
	inst.components.resurrector.doresurrect = doresurrect
	inst.components.resurrector.makeusedfn = makeused
	inst.components.resurrector.penalty = 0

	inst:AddComponent("hunger")
	inst.components.hunger:SetMax(100)
    inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE*1.5)
    inst.components.hunger:SetKillRate(100/TUNING.STARVE_KILL_TIME)
--	inst.components.hunger.current=1

	inst:AddComponent("health")
	inst.components.health:SetMaxHealth(50)
    inst.components.health.nofadeout = true

	inst:DoPeriodicTask(1, function(inst)
--if hungry and have honey then eat it
--print("hunger: "..inst.components.hunger.current.."/"..inst.components.hunger.max)
		if inst.components.hunger.current<=inst.components.hunger.max-20 and inst.components.container:Has("honey",1) then
			inst.components.container:ConsumeByName("honey", 1)
			inst.components.hunger:DoDelta(15)
			inst.components.health:DoDelta(5)
		end
--health watcher
--print("health: "..inst.components.health.currenthealth.."/"..inst.components.health.maxhealth)
		if inst.components.health.currenthealth > 0 and inst.components.hunger.current > 0 then
			inst.components.health:DoDelta(1)
		end
		if inst.components.health.currenthealth <= 0 and inst.components.hunger.current <= 0 then
--print("death detected")
			SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
			inst.SoundEmitter:PlaySound("dontstarve/rain/thunder_close")
			inst.SoundEmitter:PlaySound("dontstarve/common/resurrectionstone_break")
	        inst.components.container:DropEverything()
			inst.components.container.itemtestfn = itemtest2
	        inst.components.container:GiveItem(SpawnPrefab("honeycomb"),2)
	        inst.components.container:GiveItem(SpawnPrefab("honey"),3)
	        inst.components.container:GiveItem(SpawnPrefab("honey"),3)
	        inst.components.container:GiveItem(SpawnPrefab("honey"),3)
	        inst.components.container:GiveItem(SpawnPrefab("honey"),3)
	        inst.components.container:GiveItem(SpawnPrefab("honey"),3)
	        inst.components.container:DropEverything()
			inst:Remove()
		end
--animate near death:
		if inst.components.health.currenthealth/inst.components.health.maxhealth<.33 and inst.components.hunger.current<=1 then
			inst.AnimState:PlayAnimation("cocoon_small_hit")
		end
	end)
--hunger indicator:
	inst:DoPeriodicTask(.1, function(inst)
		local hungerpercent=inst.components.hunger.current/inst.components.hunger.max
		if hungerpercent>.66 then
		    inst.AnimState:SetAddColour(0,0,0,0)
			inst.Transform:SetScale(1,1,1)
		end
		if hungerpercent<.66 and hungerpercent>.33 then
		    inst.AnimState:SetAddColour(.25,0,0,0)
			inst.Transform:SetScale(.9,.9,.9)
		end
		if hungerpercent<.33 then
		    inst.AnimState:SetAddColour(.5,0,0,0)
			inst.Transform:SetScale(.8,.8,.8)
		end
		if inst.components.health.currenthealth/inst.components.health.maxhealth<.33 and inst.components.hunger.current<=1 then
			inst:DoTaskInTime(.066, function(inst)
			    inst.AnimState:SetAddColour(0,.2,.2,0)
			end)
		end
	end)

    inst:AddComponent("container")
    inst.components.container:SetNumSlots(#slotpos)
    inst.components.container.widgetslotpos = slotpos
    inst.components.container.widgetanimbank = "ui_chest_3x2"
    inst.components.container.widgetanimbuild = "ui_chest_3x2"
	inst.components.container.widgetpos = Vector3(0,150,0)
    inst.components.container.side_align_tip = 160
    inst.components.container.itemtestfn = itemtest

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose

--shitty attempt to find and scale the widget bg
--[[
	inst:ListenForEvent("onopen", function(inst, data)
		if data.doer and data.doer.HUD then
print("\ndata.doer.HUD:")
for k,v in pairs(data.doer.HUD) do print(k,v) end
print("\ninst.components:")
for k,v in pairs(inst.components) do print(k,v) end
print("\ninst.components.container:")
for k,v in pairs(inst.components.container) do print(k,v) end
print("\ndata.doer.HUD.controls.containerroot:")
for k,v in pairs(data.doer.HUD.controls.containerroot) do print(k,v) end
--if 			data.doer.HUD.controls.containers.Container then
			data.doer.HUD.controls.containerroot.children.container:SetScale(1,.5,1)
--end
		end
	end)
	inst:ListenForEvent("onclose", function(inst, data)
		if data.doer and data.doer.HUD then
			data.doer.HUD.controls.containerroot:SetScale(1,1,1)
		end
	end)
--inst.components.container.widgetpos.transform:SetScale(.5,.5,.5)
--]]


    inst:AddComponent("lootdropper")

--	MakeSnowCovered(inst, .01)
	inst:ListenForEvent( "onbuilt", onbuilt)

    return inst
end

return Prefab( "cloneegg", fn, assets),
		MakePlacer( "cloneegg_placer", "spider_cocoon", "cloneegg", "cocoon_small" ) 
