local assets=
{
	Asset("ANIM", "anim/stickystinger.zip"),
	Asset("ANIM", "anim/swap_blowdart.zip"),
	Asset("ANIM", "anim/swap_blowdart_pipe.zip"),
}

local prefabs = 
{
    "impact",
}

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_blowdart", "swap_blowdart")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
	inst:AddTag("equipped")
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_object")
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
	inst:RemoveTag("equipped")
	GetPlayer().components.combat.canattack=true
end

local function onhit(inst, attacker, target)
    local impactfx = SpawnPrefab("impact")
    if impactfx and attacker then
	    local follower = impactfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
        impactfx:FacePoint(attacker.Transform:GetWorldPosition())
    end
    inst:Remove()
end

local function onthrown(inst, data)
    inst.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
end

local function stickyattack(inst, attacker, target)
--enable for ammo mod:
	attacker.components.inventory:ConsumeByName("honey", 1)
	attacker.components.inventory:ConsumeByName("stinger", 1)
    target:PushEvent("attacked", {attacker = attacker, damage = 0})
	if not target.stickiness then
		target.stickiness={}
		if target.components.locomotor and target.components.locomotor.runspeed then
			target.stickiness.xdefaultrunspeed=target.components.locomotor.runspeed
		end
		if target.components.locomotor and target.components.locomotor.walkspeed then
			target.stickiness.xdefaultwalkspeed=target.components.locomotor.walkspeed
		end
		if target.components.combat then
			target.stickiness.xdefaultmin_attack_period=target.components.combat.min_attack_period or 4
			target.stickiness.modmin_attack_period=target.components.combat.min_attack_period*3
		end
		target.stickiness.timeleft=30
		target:DoPeriodicTask(.2, function(target)
			target.stickiness.timeleft=target.stickiness.timeleft-.2
			if target.stickiness.timeleft >= 5 then
				if target.components.locomotor and target.components.locomotor.runspeed then
					target.components.locomotor.runspeed=target.components.locomotor.runspeed*.975
				end
				if target.components.locomotor and target.components.locomotor.walkspeed then
					target.components.locomotor.walkspeed=target.components.locomotor.walkspeed*.975
				end
				if target.components.combat then
					target.components.combat.min_attack_period=target.stickiness.modmin_attack_period
				end
				local color = Vector3(.75,.75,.25)
				target.AnimState:SetAddColour(color.x, color.y, color.z ,0)
			end
			if target.stickiness.timeleft <= 4 and target.stickiness.timeleft > 3 then
				local color = Vector3(0,0,0)
				target.AnimState:SetAddColour(color.x, color.y, color.z ,0)
			end
			if target.stickiness.timeleft <= 3 and target.stickiness.timeleft > 2 then
				local color = Vector3(.75,.75,.25)
				target.AnimState:SetAddColour(color.x, color.y, color.z ,0)
			end
			if target.stickiness.timeleft <= 2 and target.stickiness.timeleft > 1 then
				local color = Vector3(0,0,0)
				target.AnimState:SetAddColour(color.x, color.y, color.z ,0)
			end
			if target.stickiness.timeleft <= 1 and target.stickiness.timeleft > 0 then
				local color = Vector3(.75,.75,.25)
				target.AnimState:SetAddColour(color.x, color.y, color.z ,0)
			end
			if target.stickiness.timeleft < 0 then
				target.stickiness.timeleft=0
				if target.components.locomotor then
					if target.components.locomotor.runspeed then
						target.components.locomotor.runspeed=target.stickiness.xdefaultrunspeed
					end
					if target.components.locomotor.walkspeed then
						target.components.locomotor.walkspeed=target.stickiness.xdefaultwalkspeed
					end
				end
				if target.components.combat then
					target.components.combat.min_attack_period=target.stickiness.xdefaultmin_attack_period
				end
				local color = Vector3(0,0,0)
				target.AnimState:SetAddColour(color.x, color.y, color.z ,0)
			end
	    end)
	else
		target.stickiness.timeleft=target.stickiness.timeleft+30
	end
    if target.sg and target.sg.sg.states.hit then
        target.sg:GoToState("hit")
    end
end

local function pipeequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_blowdart_pipe", "swap_blowdart_pipe")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function pipethrown(inst)
    inst.AnimState:PlayAnimation("dart_pipe")
end
local function setcanattack(inst)
	if GetPlayer().components.inventory:Has("honey", 1) and GetPlayer().components.inventory:Has("stinger", 1) then
		return true
	else
		return false
	end
end

local function sticky()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("blow_dart")
    anim:SetBuild("stickystinger")
    
    inst:AddTag("blowdart")
    inst:AddTag("sharp")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(0)
    inst.components.weapon:SetRange(8, 10)

--disable for ammo mod:
--    inst:AddComponent("projectile")
--    inst.components.projectile:SetSpeed(60)
--    inst.components.projectile:SetOnHitFn(onhit)
--    inst:ListenForEvent("onthrown", onthrown)
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    
--    inst:AddComponent("stackable")

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
--disable for ammo mod:
    inst.components.equippable.equipstack = false

    inst.components.inventoryitem.atlasname = "images/inventoryimages/stickystinger.xml"
    inst.AnimState:PlayAnimation("idle_pipe")
    inst.components.weapon:SetOnAttack(stickyattack)
--disable for ammo mod:
--    inst.components.projectile:SetOnThrownFn(pipethrown)

--	inst.components.weapon:SetCanAttack(setcanattack)
--
	inst:DoPeriodicTask(.1, function(inst)
		if GetPlayer().prefab ~= "beatrice" then
			inst:Remove()
		end
		if inst:HasTag("equipped") then
			if GetPlayer().components.inventory:Has("honey", 1) and GetPlayer().components.inventory:Has("stinger", 1) then
				inst.components.weapon.canattack=function(inst) return true end
				GetPlayer().components.combat.canattack=true
			else
				inst.components.weapon.canattack=function(inst) return false end
				GetPlayer().components.combat.canattack=false
			end
		end
	end)
--]]
    return inst
end

return Prefab( "stickystinger", sticky, assets, prefabs)
