local assets=
{
    Asset("ANIM", "anim/a1.zip"),
    Asset("ANIM", "anim/swap_a1.zip"),
    Asset("IMAGE", "images/inventoryimages/a1.tex"),
    Asset("ATLAS", "images/inventoryimages/a1.xml"),

}
local prefabs =
{
    "impact",
}

local function fireattack(inst, attacker, target)
    target:PushEvent("attacked", {attacker = attacker, damage = 0})
SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
           SpawnPrefab("explode_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
           local pos = Vector3(inst.Transform:GetWorldPosition())
           GetClock():DoLightningLighting()
           GetPlayer().components.playercontroller:ShakeCamera(inst, "FULL", 0.7, 0.02, .5, 40)
           
   
    if target.components.freezable then
        target.components.freezable:Freeze(7)
    end
    if target.components.combat then
        target.components.combat:SuggestTarget(attacker)
    end
    if target.sg and target.sg.sg.states.hit then
        target.sg:GoToState("hit")
    end
end

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_a1", "swap_speargun")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner)
    owner.AnimState:ClearOverrideSymbol("swap_object")
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function onhit(inst, attacker, target)
    local impactfx = SpawnPrefab("impact")
    if impactfx and attacker then
	    local follower = impactfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
        impactfx:FacePoint(attacker.Transform:GetWorldPosition())
    end
    inst:Remove()
end

local function onthrown(inst, data)
    inst.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
    inst.AnimState:PlayAnimation("speargun")
end

local function poisonattack(inst, attacker, target)
    if target.components.poisonable then
        target.components.poisonable:Poison()
    end
    if target.components.combat then
        target.components.combat:SuggestTarget(attacker)
    end
    if target.sg and target.sg.sg.states.hit then
        target.sg:GoToState("hit")
    end
end


local function commonfn()


	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    --inst.Transform:SetFourFaced()
    anim:SetBank("speargun")
    anim:SetBuild("a1")

    inst:AddTag("speargun")
    inst:AddTag("sharp")
    inst:AddTag("projectile")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(30)
    inst.components.weapon:SetRange(12, 14)

    inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(30)
    inst.components.projectile:SetOnHitFn(onhit)
    inst:ListenForEvent("onthrown", onthrown)
    -------

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
inst.components.inventoryitem.imagename = "a1"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/a1.xml"
    inst:AddComponent("stackable")

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
    inst.components.equippable.equipstack = true

    inst.AnimState:PlayAnimation("idle")

    MakeInventoryFloatable(inst, "idle_water", "idle")

inst.entity:AddSoundEmitter()

    inst.components.floatable:SetOnHitWaterFn(function(inst)
        inst.SoundEmitter:PlaySound("dontstarve_DLC002/common/obsidian_wetsizzles")
    end)



    
    inst:AddTag("notslippery")
	inst.no_wet_prefix = true

    inst.components.weapon:SetOnAttack(fireattack)

    return inst
end






return Prefab( "common/inventory/a1", commonfn, assets, prefabs)