
local MakePlayerCharacter = require "prefabs/player_common"
local assets = {
        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wendy.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/h02.zip" ), --character anim
}
local prefabs = {} --no special items in mod

local start_inv = 
{
		"killersword","pickleheart"--starts with fishing rod
}

local function updatestats(inst)

    if GetClock():IsDusk() then
		inst.components.combat:AddDamageModifier("wigfrid", TUNING.WATHGRITHR_DAMAGE_MULT)
		

    elseif GetClock():IsNight() then
		inst.components.combat:AddDamageModifier("wigfrid", TUNING.WATHGRITHR_DAMAGE_MULT)
		
	end
	end

local function applyupgrades(inst) --level up handling
	local max_upgrades = 20
	local upgrades = math.min(inst.level, max_upgrades)
	local hunger_percent = inst.components.hunger:GetPercent()
	local health_percent = inst.components.health:GetPercent()
	local sanity_percent = inst.components.sanity:GetPercent()
	inst.components.hunger.max = math.ceil (150 + upgrades * 5)
	inst.components.health.maxhealth = math.ceil (100 + upgrades * 3)
	inst.components.sanity.max = math.ceil (90 + upgrades * 3)
	
	inst.components.talker:Say("ȼ : ".. (inst.level))	
	if inst.level >19 then
		inst.components.talker:Say("ȼ")
	end
	inst.components.hunger:SetPercent(hunger_percent)
	inst.components.health:SetPercent(health_percent)
	inst.components.sanity:SetPercent(sanity_percent)	
end
local function oneat(inst, food)
if food and food.components.edible and food.components.edible.foodtype == "GEARS" then
		--give an upgrade! 
inst.components.sanity:DoDelta(-25)
		inst.components.health:DoDelta(-45)
inst.components.hunger:DoDelta(-65)
		inst.level = inst.level + 1
inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")
		applyupgrades(inst)
                
		inst.HUD.controls.status.heart:PulseGreen()
		inst.HUD.controls.status.stomach:PulseGreen()
		inst.HUD.controls.status.brain:PulseGreen()		
		inst.HUD.controls.status.brain:ScaleTo(1.3,1,.7)
		inst.HUD.controls.status.heart:ScaleTo(1.3,1,.7)
		inst.HUD.controls.status.stomach:ScaleTo(1.3,1,.7)
	end
end


local function onpreload(inst, data) 
	if data then
		if data.level then
			inst.level = data.level
			applyupgrades(inst)
			if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
			if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
			if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
			inst.components.health:DoDelta(0)
			inst.components.hunger:DoDelta(0)
			inst.components.sanity:DoDelta(0)
		end
	end
end
local function onsave(inst, data)
	data.level = inst.level
	data.charge_time = inst.charge_time
end
local fn = function(inst)
        
	inst.soundsname = "h02"
	inst.MiniMapEntity:SetIcon( "h02.tex" )
	inst.level = 0
        inst.components.eater.ignoresspoilage = true
        table.insert(inst.components.eater.foodprefs, "GEARS")
	table.insert(inst.components.eater.ablefoods, "GEARS")
	
	inst.components.eater:SetOnEatFn(oneat)
	applyupgrades(inst)
	inst.components.health:SetMaxHealth(100)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(90)
	inst.components.locomotor.walkspeed = 6
	inst.components.locomotor.runspeed = 7	
        
     
        inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE)
	inst.OnSave = onsave
	inst.OnPreLoad = onpreload

        inst:ListenForEvent( "dusktime", function() updatestats(inst) end , GetWorld())

	inst:ListenForEvent( "nighttime", function() updatestats(inst) end , GetWorld())
	updatestats(inst)
     
	
end

return MakePlayerCharacter("h02", prefabs, assets, fn, start_inv)