local assets=
{ 
    Asset("ANIM", "anim/hat_bee_bw.zip"),
    Asset("ANIM", "anim/hat_bee_bw_swap.zip"), 

    Asset("ATLAS", "images/inventoryimages/hat_bee_bw.xml"),
    Asset("IMAGE", "images/inventoryimages/hat_bee_bw.tex"),
}

local prefabs = 
{
}

local function generic_perish(inst)
		inst:Remove()
		end

local function fn()

    local function OnEquip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_hat", "hat_bee_bw_swap", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAT_HAIR")
        owner.AnimState:Hide("HAIR_NOHAT")
        owner.AnimState:Hide("HAIR")
       
        if owner:HasTag("player") then
          
            owner.AnimState:Hide("HEAD")
            owner.AnimState:Show("HEAD_HAIR")
        end
        if inst.components.fueled then
			inst.components.fueled:StartConsuming()        
		end
    end

    local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")

        if owner:HasTag("player") then
            owner.AnimState:Show("HEAD")
            owner.AnimState:Hide("HEAD_HAIR")
        end
            if inst.components.fueled then
			inst.components.fueled:StopConsuming()        
		end

		
    end

    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("hat_bee_bw")
    anim:SetBuild("hat_bee_bw")
    anim:PlayAnimation("idle")


    inst:AddComponent("fueled")
		inst.components.fueled.fueltype = "USAGE"
		inst.components.fueled:InitializeFuelLevel(TUNING.TOPHAT_PERISHTIME)
		inst.components.fueled:SetDepletedFn(generic_perish)
    
    
    inst:AddComponent("waterproofer")
    inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_SMALL)
        

		

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "hat_bee_bw"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/hat_bee_bw.xml"
    
    inst:AddComponent("equippable")
    
        

    inst.components.equippable.walkspeedmult = 1.2
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.equippable:SetOnEquip(OnEquip)
inst.components.equippable.dapperness = TUNING.DAPPERNESS_SMALL
    inst.components.equippable:SetOnUnequip(OnUnequip)
 
   
    return inst
end

return  Prefab("common/inventory/hat_bee_bw", fn, assets, prefabs)