local assets=
{
	Asset("ANIM", "anim/killersword.zip"),
	Asset("ANIM", "anim/swap_killersword.zip"),
    Asset("IMAGE", "images/inventoryimages/killersword.tex"),
	Asset("ATLAS", "images/inventoryimages/killersword.xml"),

}

local prefabs = 
{
    "ice_projectile", 
}


local function onfinished(inst)
    inst:Remove()
end

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_killersword", "swap_nightmaresword")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
    
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
    
end

local function onattack(inst, owner, target)

    if owner.components.hunger and owner.components.hunger:GetPercent() < 1 and not target:HasTag("wall") then
        owner.components.hunger:DoDelta(-5)
    end
	
    if owner.components.hunger and owner.components.hunger:GetPercent() < 0.1 and not target:HasTag("wall") then
        owner.components.health:DoDelta(-5)
    end
	
	if owner.components.sanity and owner.components.sanity:GetPercent() < 1.1 and not target:HasTag("wall") then
        owner.components.sanity:DoDelta(2)
    end

	if owner.components.sanity and owner.components.sanity:GetPercent() < 0.05 and not target:HasTag("wall") then
        owner.components.health:DoDelta(2)
    end
	

end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("nightmaresword")
    inst.AnimState:SetBuild("killersword")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:SetMultColour(1, 1, 1, 1)

	inst:AddTag("shadow")
    inst:AddTag("sharp")
    inst:AddTag("icestaff")
	inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(60)
    inst.components.weapon:SetRange(7, 8)
    inst.components.weapon:SetOnAttack(onattack)
    inst.components.weapon:SetProjectile("brsh_projectile")
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(60)
    inst.components.finiteuses:SetUses(60)


    inst.components.finiteuses:SetOnFinished( onfinished )

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/killersword.xml"
	inst:AddComponent("dapperness")
	inst.components.dapperness.dapperness = TUNING.DAPPERNESS_MED

    inst:AddComponent("equippable")
   
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
        
    return inst
end

return Prefab( "common/inventory/killersword", fn, assets)
