--------------------------------------------------------------------------------------------------------------------------JINYE
require "prefabutil"

local WAKE_TO_FOLLOW_DISTANCE = 2000
local SLEEP_NEAR_LEADER_DISTANCE = 2

local assets =
{
    Asset( "ANIM", "anim/oichan.zip" ),
	
	Asset( "SOUNDPACKAGE" , "sound/oichan.fev" ),
	Asset( "SOUND" , "sound/oichan_bank00.fsb" ),
	Asset( "SOUND" , "sound/chester.fsb" ),
	
	Asset("ANIM", "anim/ui_chester_shadow_3x4.zip"),
}

local prefabs =
{
	"die_fx","pickleheart"
}


local function ShouldKeepTarget(inst, target)
    return false
end


local function OnOpen(inst)
        inst.sg:GoToState("open")
end 

local function OnClose(inst) 
        inst.sg:GoToState("close")
end 

local function OnStopFollowing(inst) 
    inst:RemoveTag("companion")
end

local function OnStartFollowing(inst) 
    inst:AddTag("companion")
end


local slotpos_3x4 = {}

for y = 2.5, -0.5, -1 do
    for x = 0, 2 do
        table.insert(slotpos_3x4, Vector3(75*x-75*2+75, 75*y-75*2+75,0))
    end
end

local function create_oichan()

    local inst = CreateEntity()
    
    inst:AddTag("companion")
    inst:AddTag("scarytoprey")
	inst:AddTag("noauradamage")
	
	inst:AddTag("character")
	inst:AddTag("oifriends")
    inst:AddTag("oichan")
	
    inst:AddTag("notraptrigger")
	
	
	inst:AddTag("light")
	
    inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon("oichan.tex")

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.AnimState:SetBank("oichan")
    inst.AnimState:SetBuild("oichan")
	inst.AnimState:PlayAnimation("idle_loop")
	---inst.Transform:SetScale(.8,.8,.8)

    inst.entity:AddSoundEmitter()
	
    inst.entity:AddDynamicShadow()
    inst.DynamicShadow:SetSize( 1, .5 )

    MakeCharacterPhysics(inst, 75, .5)
    
    inst.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
    inst.Physics:ClearCollisionMask()
    inst.Physics:CollidesWith(COLLISION.WORLD)
    inst.Physics:CollidesWith(COLLISION.OBSTACLES)
    inst.Physics:CollidesWith(COLLISION.CHARACTERS)

    inst.Transform:SetFourFaced()

inst:RemoveTag("fridge")

    inst:AddComponent("inspectable")
	inst.components.inspectable:RecordViews()
	
    inst:AddComponent("locomotor")
    inst.components.locomotor.walkspeed = 12
    inst.components.locomotor.runspeed = 15
	
    inst:AddComponent("follower")
    inst:ListenForEvent("stopfollowing", OnStopFollowing)
    inst:ListenForEvent("startfollowing", OnStartFollowing)

    inst:AddComponent("knownlocations")
    MakeSmallBurnableCharacter(inst)
	
    inst:AddComponent("container")

    inst.components.container.onopenfn = OnOpen
    inst.components.container.onclosefn = OnClose

	inst.components.container:SetNumSlots(#slotpos_3x4)
    inst.components.container.widgetslotpos = slotpos_3x4
    inst.components.container.widgetanimbank = "ui_chester_shadow_3x4"
    inst.components.container.widgetanimbuild = "ui_chester_shadow_3x4"
    inst.components.container.widgetpos = Vector3(0,200,0)
    inst.components.container.widgetpos_controller = Vector3(0,200,0)
    inst.components.container.side_align_tip = 160
	inst.components.container.widgetbgimagetint = {r=.44,g=.74,b=1,a=1}
	
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(9999999999) 
    inst.components.health:StartRegen(9999999999,1 )
	
    local light = inst.entity:AddLight()
    inst.Light:Enable(true)
	inst.Light:SetRadius(1)
    inst.Light:SetFalloff(.5)
    inst.Light:SetIntensity(.35)
    inst.Light:SetColour(150/255,150/255,150/255)
	
    inst:SetStateGraph("SGoichan")
    inst.sg:GoToState("idle")

    if IsDLCEnabled(CAPY_DLC) then
		MakeAmphibiousCharacterPhysics(inst, 75, .5)
	else
		MakeCharacterPhysics(inst, 75, .5)
		inst.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
		inst.Physics:ClearCollisionMask()
		inst.Physics:CollidesWith(COLLISION.WORLD)
		inst.Physics:CollidesWith(COLLISION.OBSTACLES)
		inst.Physics:CollidesWith(COLLISION.CHARACTERS)
	end
    

	local brain = require "brains/oichanbrain"
    inst:SetBrain(brain)
    return inst
end

return Prefab( "common/oichan", create_oichan, assets, prefabs) 
--------------------------------------------------------------------------------------------------------------------------JINYE