
local Dsskins = Class(function(self,inst)
    self.inst = inst
    self.skin = nil
	self.build = nil
	self.fx = nil
end)

function Dsskins:OnSave()
	return {
	skin = self.skin,
	build = self.build,
	fx = self.fx,
	}
end
local function fly_do_trail(inst)
    local owner = inst.components.inventoryitem:GetGrandOwner() or inst
    if not owner.entity:IsVisible() then
        return
    end

    local x, y, z = owner.Transform:GetWorldPosition()
    if owner.sg ~= nil and owner.sg:HasStateTag("moving") then
        local theta = -owner.Transform:GetRotation() * DEGREES
        local speed = owner.components.locomotor:GetRunSpeed() * .1
        x = x + speed * math.cos(theta)
        z = z + speed * math.sin(theta)
    end
	local map = GetWorld().Map
    local offset = FindValidPositionByFan(
        math.random() * 2 * PI,
         .5 + math.random() * .5,
        4,
        function(offset)
            local pt = Vector3(x + offset.x, 0, z + offset.z)
            return map:GetTileAtPoint(pt:Get())	
                and #TheSim:FindEntities(pt.x, 0, pt.z, .7, { "shadowtrail" }) <= 0 
        end
    )
    if offset ~= nil then
		SpawnPrefab("cane_ancient_fx").Transform:SetPosition(x + offset.x, 0, z + offset.z)
    end
end
local function cane_equipped(inst)
    if inst._trailtask == nil then
        inst._trailtask = inst:DoPeriodicTask(6 * FRAMES, fly_do_trail, 2 * FRAMES)
    end
end
local function cane_unequipped(inst)
    if inst._trailtask ~= nil then
        inst._trailtask:Cancel()
        inst._trailtask = nil
    end
end
function Dsskins:Changeskin()
	if self.skin ~= nil  then
		if self.inst:HasTag("player") then
			self.inst.AnimState:SetBuild(self.skin)
			self.inst.AnimState:OverrideSymbol("torso", self.skin ,"torso" )	
			self.inst.AnimState:OverrideSymbol("torso_pelvis", self.skin ,"torso_pelvis" )
			if  IsDLCEnabled(CAPY_DLC)  then
			    self.inst.AnimState:OverrideSymbol("droplet", self.inst.prefab, "droplet")
				self.inst.AnimState:OverrideSymbol("paddle", self.inst.prefab, "paddle")
				self.inst.AnimState:OverrideSymbol("wake_paddle", self.inst.prefab, "wake_paddle")
			end
			self.inst._xiaoqiangbianshen = true	
		else
			self.inst.AnimState:SetBuild(self.skin)
			if self.inst.components.inventoryitem then	
					if self.inst.prefab == "backpack" or self.inst.prefab == "krampus_sack" or self.inst.prefab == "armorwood" or self.inst.prefab == "armorgrass" or self.inst.prefab == "armordragonfly" or self.inst.prefab == "armulet" then
						self.inst.AnimState:SetBank(self.skin)
						self.inst.AnimState:PlayAnimation("idle")
						if IsDLCEnabled(CAPY_DLC) then
							MakeInventoryFloatable(self.inst, "idle_water", "idle")
						end
					end
				self.inst.components.inventoryitem.imagename = self.skin
				self.inst.components.inventoryitem.atlasname = "images/inventoryimages/"..self.skin..".xml"
					if self.inst.components.equippable then
						self.inst:ListenForEvent("equipped", function(inst,data)
							if data.owner ~= nil then
								if inst.components.equippable.equipslot == EQUIPSLOTS.HANDS then
									if self.build ~= nil then
										data.owner.AnimState:OverrideSymbol("swap_object", "swap_"..self.skin, self.build)
									end
									if self.fx ~= nil then
										cane_equipped(inst)
										inst:ListenForEvent("unequipped", cane_unequipped)
									end
								end
								if inst.components.equippable.equipslot == EQUIPSLOTS.BACK  then ---for  other mods
									data.owner.AnimState:OverrideSymbol("swap_body", self.skin, "swap_body")
								end
								if inst.components.equippable.equipslot == EQUIPSLOTS.BODY  then
									data.owner.AnimState:OverrideSymbol("swap_body", self.skin, "swap_body")
								end
								if inst.components.equippable.equipslot == EQUIPSLOTS.PACK then
									data.owner.AnimState:OverrideSymbol("swap_body", self.skin, "swap_body")
								end
                                if inst.components.equippable.equipslot == EQUIPSLOTS.NECK then
									data.owner.AnimState:OverrideSymbol("swap_body", self.skin, "swap_body") 
								end	
								if inst.components.equippable.equipslot == EQUIPSLOTS.HEAD then
									data.owner.AnimState:OverrideSymbol("swap_hat", self.skin, "swap_hat")								
								end
							end
						end)
					end
			end
		end
    end
end

function Dsskins:OnLoad(data)
	if data.skin ~= nil  then
        self.skin = data.skin
		if data.build ~= nil then
		self.build = data.build
		end
		if data.fx ~= nil then
		self.fx = data.fx
		end
		self:Changeskin()
	end
end
return Dsskins