require "prefabutil"

local assets=
{
	Asset("ANIM", "anim/grill.zip"),
        Asset("SOUND", "sound/wilson.fsb"),	
}


local function turnon(inst)
    if not inst.components.fueled:IsEmpty() then
        if not inst.components.machine.ison then
            if inst.components.fueled then
                inst.components.fueled:StartConsuming()        
	inst:AddComponent("heater")
        
        inst.components.heater.heat = 70
            end
       if not inst.components.cooker then
       inst:AddComponent("cooker")
end

            inst.Light:Enable(true)
            inst.components.machine.ison = true
            inst.AnimState:PlayAnimation("idle_on")
            inst.SoundEmitter:PlaySound("dontstarve/wilson/lantern_on")
            inst.SoundEmitter:PlaySound("dontstarve/wilson/lantern_LP", "loop")
        end
    end
end




        
 


local function turnoff(inst)
    if inst.components.fueled then
        inst.components.fueled:StopConsuming()        
        inst:RemoveComponent("heater")
 end
       if inst.components.cooker then
       inst:RemoveComponent("cooker")
end
    inst.Light:Enable(false)
    inst.components.machine.ison = false
    inst.AnimState:PlayAnimation("idle")
    inst.SoundEmitter:KillSound("loop")
    inst.SoundEmitter:PlaySound("dontstarve/wilson/lantern_off")
    end






local function OnLoad(inst, data)
    if inst.components.machine and inst.components.machine.ison then
        turnon(inst)
    else
        turnoff(inst)
    end
end

local function onpickup(inst)
	turnoff(inst)
end

local function onputininventory(inst)

    turnoff(inst)
end

local function fuelupdate(inst)
    local fuelpercent = inst.components.fueled:GetPercent()
    inst.Light:SetIntensity(Lerp(0.6, 0.8, fuelpercent))
    inst.Light:SetRadius(Lerp(1, .8, fuelpercent))
    inst.Light:SetFalloff(1)
end


local function nofuel(inst)
    local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
    if owner then
        owner:PushEvent("torchranout", {torch = inst})
    end

    turnoff(inst)
end

local function ondropped(inst, owner)
    turnon(inst)
end





local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
        MakeInventoryPhysics(inst)


   

	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon( "grill.tex" )
	
    inst.AnimState:SetBank("grill")
    inst.AnimState:SetBuild("grill")
    inst.AnimState:PlayAnimation("idle")
    inst.Transform:SetScale(2.5,2.5,2.5)


    local light = inst.entity:AddLight()
    inst.Light:Enable(false)
    inst.Light:SetRadius(.6)
    inst.Light:SetFalloff(1)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(255/255, 0/0, 0/0)    


    



    inst:AddComponent("machine")
    inst.components.machine.turnonfn = turnon
    inst.components.machine.turnofffn = turnoff

    inst.components.machine.cooldowntime = 0
    inst.components.machine.caninteractfn = function() return not inst.components.fueled:IsEmpty() end

    inst:AddComponent("fueled")
    --inst.components.fueled.fueltype = "CHARCOAL"
    inst.components.fueled:InitializeFuelLevel(TUNING.FIREPIT_FUEL_MAX)
    inst.components.fueled:SetDepletedFn(nofuel)
    inst.components.fueled:SetUpdateFn(fuelupdate)
    --inst.components.fueled.ontakefuelfn = takefuel
    inst.components.fueled.accepting = true
    inst.components.fueled.rate = .5

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.cangoincontainer = true
    inst.components.inventoryitem:SetOnPutInInventoryFn(onputininventory)
    inst.components.inventoryitem.atlasname = "images/inventoryimages/grill.xml"

    inst.OnLoad = OnLoad

    inst:AddComponent("inspectable")

	
    inst.components.inventoryitem:SetOnDroppedFn(ondropped)
    


    return inst
end

return Prefab( "common/grill", fn, assets)
