local require = GLOBAL.require

local ItemTile = require "widgets/itemtile" --   
local Image = require "widgets/image" -- 
local UIAnim = require "widgets/uianim" -- 

PrefabFiles = {
    --"hat_witch", "broom", "hat_pumpkin",
}

Assets = 
{
	Asset("ATLAS", "images/inventoryimages.xml"),
	Asset("ANIM", "anim/cook_pot.zip"),
	Asset("ANIM", "anim/cook_pot_food.zip"),
	Asset("ANIM", "anim/rock_hw1.zip"),
	Asset("ANIM", "anim/rock_hw2.zip"),
	Asset("ANIM", "anim/rock_hw3.zip"),
	Asset("ANIM", "anim/rock2_hw1.zip"),
	--Asset("ANIM", "anim/pig_house.zip"), --SW
	--
	Asset("ANIM", "anim/hw_title_shield.zip"),	
	Asset("ANIM", "anim/corner_dude_hw.zip"),	
}

local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local STRINGS = GLOBAL.STRINGS
local TECH = GLOBAL.TECH
local _G = GLOBAL

--star:
AddPrefabPostInit("rock1", function(inst)
	local result = math.random()
	if result < 0.25 then
		inst.AnimState:SetBuild("rock_hw1")
	elseif result < 0.5 then
		inst.AnimState:SetBuild("rock_hw2")
	elseif result < 0.75 then
		inst.AnimState:SetBuild("rock_hw3")		
	end
end)

AddPrefabPostInit("rock2", function(inst)
	local result = math.random()
	if result < 0.5 then
		inst.AnimState:SetBuild("rock2_hw1")
	end
end)
--[[
AddPrefabPostInit("wildborehouse", function(inst)
	local result = math.random()
	if result < 0.95 then
		inst.AnimState:SetBuild("pig_house")
	end
end)


AddPrefabPostInit("prefab_name", function(inst)
	if math.random() < 0.5 then
		inst.AnimState:SetBuild("mybuild")
	end
end)
]]


--MrM:
----    
--Assets = {}
function InvIcon(prefab)
	table.insert(Assets, Asset("ATLAS", "images/inventoryimages/" .. prefab .. ".xml"))

	AddPrefabPostInit(prefab, function(inst)
		inst.components.inventoryitem.atlasname = "images/inventoryimages/"..prefab..".xml"
		---        ,   
		--inst.components.inventoryitem.imagename = "flowersalad"
	end)
end

----  
arr = {
	--"guano",
	"beefalohat",
	"horn",
	"goldenaxe",
	"goldenpickaxe",
	"goldenshovel",
	"spear",
	"tophat",
	"minerhat",
	"strawhat",
	"cane",
}

----  
for k,v in pairs(arr) do
	InvIcon(v)
end

----   2 [  ]
--Assets = {}
function InvIconn(prefab)
	table.insert(Assets, Asset("ATLAS", "images/inventoryimages/" .. prefab .. ".xml"))
	
	----    
	local pref = _G.GetRecipe(prefab)
	if pref  then
	pref.atlas = "images/inventoryimages/"..prefab..".xml"
	end
end

----  
arrr = {
	--"guano",
	"beefalohat",
	"horn",
	"goldenaxe",
	"goldenpickaxe",
	"goldenshovel",
	"spear",
	"tophat",
	"minerhat",
	"strawhat",
	"cane",

	"cookpot",
	"firepit",
	"researchlab4",
}

----  
for k,v in pairs(arrr) do
	InvIconn(v)
end

--   ---------------------------------
local function UpdateMainScreen(self,...)
    if(self.shield) then self.shield:Kill() end
    self.shield = self.fixed_root:AddChild(UIAnim())
    self.shield:GetAnimState():SetBank("hw_title_shield")
    self.shield:GetAnimState():SetBuild("hw_title_shield")
    self.shield:GetAnimState():PlayAnimation("idle", true)
    self.shield:SetPosition(0, -50, 0)
    self.shield:SetScale(0.75)

    if(self.wilson) then self.wilson:Kill() end
    --self.shield = self.fixed_root:AddChild(UIAnim())
    --self.wilson = self.fixed_root:AddChild(UIAnim())
	self.wilson = self.left_col:AddChild(UIAnim())
    self.wilson:GetAnimState():SetBank("corner_dude_hw")
    self.wilson:GetAnimState():SetBuild("corner_dude_hw")
    self.wilson:GetAnimState():PlayAnimation("idle", true)
    self.wilson:SetPosition(-1,-370,0)
	

end

AddClassPostConstruct("screens/mainscreen",UpdateMainScreen)
-------------------------------------------------------------]]