local assets=
{
    Asset("ANIM", "anim/katana.zip"),
    Asset("ANIM", "anim/swap_katana.zip"),
 
    Asset("ATLAS", "images/inventoryimages/katana.xml"),
    Asset("IMAGE", "images/inventoryimages/katana.tex"),
}

local function OnEquip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_katana", "swap_katana")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
    end
 
    local function OnUnequip(inst, owner)
        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
    end
 local function fn()
	local inst = CreateEntity()
	
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)
     
    inst.AnimState:SetBank("katana")
    inst.AnimState:SetBuild("katana")
    inst.AnimState:PlayAnimation("idle")
 
 if not TheWorld.ismastersim then
        return inst
    end
 
    inst.entity:SetPristine()
    
    inst:AddTag("sharp")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(70)
    
 
    inst:AddComponent("inspectable")
	
     
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "katana"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/katana.xml"
     
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
 
    return inst
end
   
return  Prefab("common/inventory/katana", fn, assets, prefabs)
