local FiniteUses_Mauser = Class(function(self, inst)
    self.inst = inst
    self.current = {}
	self.total = {}
	self.onempty = nil
	self.onfinished = nil
end)

function FiniteUses_Mauser:OnSave()
	return self.current
end

function FiniteUses_Mauser:OnLoad(data)
	self.current = data
end

function FiniteUses_Mauser:GetMaxUses(target)
    return self.total[target] or 0
end

function FiniteUses_Mauser:SetMaxUses(target,value)
	if value < 0 then
		self.total[target] = 0
	else
		self.total[target] = value
	end
end

function FiniteUses_Mauser:GetUses(target)
    return self.current[target] or 0
end

function FiniteUses_Mauser:SetUses(target,value)
	if value < 0 then
		self.current[target] = 0
	elseif value > self:GetMaxUses(target) then
		self.current[target] = self:GetMaxUses(target)
	else
		self.current[target] = value
	end
end

function FiniteUses_Mauser:Uses(target,num)
    self:SetUses(target,self:GetUses(target) - (num or 1))
end

return FiniteUses_Mauser
