local assets =
{
	 Asset("ANIM", "anim/ammo.zip"),
}

local function onthrown(inst, data)
    inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround)
end

local function fn()
	local inst = CreateEntity()

   	inst.entity:AddTransform()
    inst.entity:AddAnimState()
	if TheSim:GetGameID() == "DST" then
		inst.entity:AddNetwork()
	end

    MakeInventoryPhysics(inst)
    RemovePhysicsColliders(inst)

    inst.AnimState:SetBank("ammo")
    inst.AnimState:SetBuild("ammo")
    inst.AnimState:PlayAnimation("idle")

	if TheSim:GetGameID() == "DST" then
		inst.entity:SetPristine()
		if not TheWorld.ismastersim then
			return inst
		end
	end
    inst:AddComponent("inspectable")   
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/ammo.xml"
	inst:AddComponent("tradable")
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
	if TheSim:GetGameID() == "DST" then
		MakeHauntableLaunch(inst)
	end
    return inst
end

STRINGS.NAMES.AMMO                             	= "Ammo"
STRINGS.RECIPE_DESC.AMMO                       	= "7.92 × 57 mm"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.AMMO		= "Ammo for Mauser 98k"

return Prefab( "common/inventory/ammo", fn, assets) 