local assets =
{
	Asset("ANIM", "anim/bayonet.zip"),
    Asset("ANIM", "anim/swap_bayonet.zip"), 
}

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_bayonet", "swap_bayonet")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

local function canrepairing(inst, item)
	if inst.components.finiteuses:GetUses() < TUNING.BAYONET_DURABILITY and item.prefab == "goldnugget" then
       return true
    end
    return false
end

local function repairing(inst, giver, item)
	local value = inst.components.finiteuses:GetUses() + TUNING.BAYONET_DURABILITY / 2
	if value > TUNING.BAYONET_DURABILITY then
		inst.components.finiteuses:SetUses(TUNING.BAYONET_DURABILITY)
	else
		inst.components.finiteuses:SetUses(value)
	end
end
	

local function fn()
	local inst = CreateEntity()
	
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
	if TheSim:GetGameID() == "DST" then
		inst.entity:AddNetwork()
	end

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("bayonet")
    inst.AnimState:SetBuild("bayonet")
    inst.AnimState:PlayAnimation("idle")
	inst:AddTag("spear")
	
	if TheSim:GetGameID() == "DST" then
		inst.entity:SetPristine()
		if not TheWorld.ismastersim then
			return inst
		end
	end
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/bayonet.xml"
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.BAYONET_DURABILITY)
    inst.components.finiteuses:SetUses(TUNING.BAYONET_DURABILITY)
	
	inst.components.finiteuses:SetOnFinished(inst.Remove)

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.BAYONET_DAMAGE * TUNING.SPEAR_DAMAGE * 0.75)
    inst.components.weapon:SetRange(0, 0)
	inst.components.weapon.quickAttack = true
	
	inst:AddComponent("trader")
    inst.components.trader.onaccept = repairing
    inst.components.trader:SetAcceptTest(canrepairing)
	
	inst:AddComponent("tradable")
	
	if TheSim:GetGameID() == "DST" then
		MakeHauntableLaunch(inst)
	end
    return inst
end

STRINGS.NAMES.BAYONET  = "Bayonet"
STRINGS.RECIPE_DESC.BAYONET  = "A Very Sharp Metal Weapon"

return Prefab( "common/inventory/bayonet", fn, assets) 