local assets =
{
	 Asset("ANIM", "anim/bullet.zip"),
}

local function onthrown(inst, data)
    inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround)
end

local function fn()
	local inst = CreateEntity()

   	inst.entity:AddTransform()
    inst.entity:AddAnimState()
	if TheSim:GetGameID() == "DST" then
		inst.entity:AddNetwork()
	end

    MakeInventoryPhysics(inst)
    RemovePhysicsColliders(inst)

    inst.AnimState:SetBank("bullet")
    inst.AnimState:SetBuild("bullet")
    inst.AnimState:PlayAnimation("idle")

	if TheSim:GetGameID() == "DST" then
		inst.entity:SetPristine()
		if not TheWorld.ismastersim then
			return inst
		end
	end

    inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(100)
    inst.components.projectile:SetOnHitFn(inst.Remove)
    inst.components.projectile:SetOnMissFn(inst.Remove)
    inst.components.projectile:SetOnThrownFn(onthrown)

    return inst
end

--STRINGS.NAMES.AMMO                               = "ammo"
--STRINGS.RECIPE_DESC.AMMO                       = "..."

return Prefab( "common/inventory/bullet", fn, assets) 