local assets =
{
	Asset("ANIM", "anim/rifle.zip"),
    Asset("ANIM", "anim/swap_rifle.zip"),
	Asset("SOUNDPACKAGE", "sound/rifle.fev"),	
	Asset("SOUND", "sound/rifle.fsb"),  
}

local prefabs =
{
	"impact",
}

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_rifle", "rifle")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

local function onattack(inst, attacker, target)
	if inst.mauser:GetUses("ammo") > 0 then
		attacker.SoundEmitter:PlaySound("rifle/fire/fire_1")
		inst.mauser:Uses("ammo")
	else		
		inst.mauser:Uses("rifle")
	end
end

local function onempty(inst)
	inst.components.weapon:SetDamage(0.5 * TUNING.SPEAR_DAMAGE)
	inst.components.weapon:SetProjectile(nil)
	inst.components.weapon:SetRange(0)
	inst:RemoveTag("blowdart")
	inst:AddTag("spear")
	inst.components.finiteuses:SetMaxUses(inst.mauser:GetMaxUses("rifle"))
	inst.components.finiteuses:SetUses(inst.mauser:GetUses("rifle"))
end

local function onrecharge(inst)
	inst.components.weapon:SetDamage(TUNING.RIFLE_DAMAGE * TUNING.SPEAR_DAMAGE)
	inst.components.weapon:SetProjectile("bullet")
	inst.components.weapon:SetRange(TUNING.RIFLE_RANGE,TUNING.RIFLE_RANGE * 1.5)
	inst:RemoveTag("spear")
	inst:AddTag("blowdart")
	inst.components.finiteuses:SetMaxUses(inst.mauser:GetMaxUses("ammo"))
	inst.components.finiteuses:SetUses(inst.mauser:GetUses("ammo"))
end

local function onfinished(inst)
	if inst.mauser:GetUses("rifle") == 0 then
		inst:Remove()
	else
		onempty(inst)
	end
end

local function onupdate(inst)
	if inst.mauser:GetUses("ammo") == 0 then
		onempty(inst)
	else
		onrecharge(inst)
	end
end

local function canreloading(inst, item)
	if item.prefab == "bayonet" then
		return true
	end
    if item.prefab == "ammo" and inst.mauser:GetUses("ammo") < inst.mauser:GetMaxUses("ammo") then
		return true
	end
    if item.prefab == "goldnugget" and inst.mauser:GetUses("rifle") < inst.mauser:GetMaxUses("rifle") then
		return true
    end
    return false
end

local function reloading(inst, giver, item)
	if item.prefab == "bayonet" then
		local rifleb = SpawnPrefab("rifleb")
		rifleb.mauser:SetUses("ammo",inst.mauser:GetUses("ammo"))
		rifleb.mauser:SetUses("rifle",inst.mauser:GetUses("rifle"))
		rifleb.mauser:SetUses("bayonet",item.components.finiteuses:GetUses())
		rifleb:onupdate()
		local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
		local holder = owner and (owner.components.inventory or owner.components.container)
		local slot = holder:GetItemSlot(inst)
		local x, y, z = inst.Transform:GetWorldPosition()
		inst:Remove()
        if holder then
			if slot then
				holder:GiveItem(rifleb, slot)
			else
				holder:Equip(rifleb)
			end
		else
			rifleb.Transform:SetPosition(x, y, z, 0)
		end
	elseif item.prefab == "ammo" then
		local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
		local holder = owner or giver
		holder.SoundEmitter:PlaySound("rifle/reload/reload_1")
		inst.mauser:SetUses("ammo",inst.mauser:GetUses("ammo") + 1)
		onrecharge(inst)
	else
		local value = inst.mauser:GetUses("rifle") + inst.mauser:GetMaxUses("rifle") / 10
		inst.mauser:SetUses("rifle",value)
		inst:onupdate()
	end
end

local function initialize( inst, owner )
	inst:RemoveEventCallback("percentusedchange", initialize)
	inst:onupdate()
end

local function fn()
	local inst = CreateEntity()
	
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
	if TheSim:GetGameID() == "DST" then
		inst.entity:AddNetwork()
	end

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("rifle")
    inst.AnimState:SetBuild("rifle")
    inst.AnimState:PlayAnimation("idle")
    --inst:AddTag("needssewing")
	inst:AddTag("sharp")
	inst:AddTag("spear")
	
	inst.onupdate = onupdate
	
	if TheSim:GetGameID() == "DST" then
		inst.entity:SetPristine()
		if not TheWorld.ismastersim then
			return inst
		end
	end
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/rifle.xml"
	
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetMaxUses(TUNING.RIFLE_DURABILITY)
	inst.components.finiteuses:SetUses(TUNING.RIFLE_DURABILITY)
	inst.components.finiteuses:SetOnFinished(onfinished)
	
    inst:AddComponent("finiteuses_mauser")
	inst.mauser = inst.components.finiteuses_mauser
	inst.mauser:SetMaxUses("ammo",TUNING.RIFLE_AMMO)
	inst.mauser:SetUses("ammo",0)
	inst.mauser:SetMaxUses("rifle",TUNING.RIFLE_DURABILITY)
	inst.mauser:SetUses("rifle",TUNING.RIFLE_DURABILITY)
	
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(0.5 * TUNING.SPEAR_DAMAGE)
    inst.components.weapon:SetRange(0,0)
    inst.components.weapon:SetProjectile(nil)
    inst.components.weapon:SetOnAttack(onattack)

	inst:AddComponent("trader")
    inst.components.trader.onaccept = reloading
    inst.components.trader:SetAcceptTest(canreloading)
	
	inst:ListenForEvent("percentusedchange", initialize)
	
	if TheSim:GetGameID() == "DST" then
		MakeHauntableLaunch(inst)
	end
    return inst
end

STRINGS.NAMES.RIFLE  = "Rifle"
STRINGS.RECIPE_DESC.RIFLE  = "Handmade Mauser 98k"

return Prefab( "common/inventory/rifle", fn, assets,prefabs) 