local assets =
{
	Asset("ANIM", "anim/rifleb.zip"),
    Asset("ANIM", "anim/swap_rifleb.zip"),
	Asset("SOUNDPACKAGE", "sound/rifle.fev"),	
	Asset("SOUND", "sound/rifle.fsb"),  
}

local prefabs =
{
	"impact",
}

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_rifleb", "rifleb")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

local function onattack(inst, attacker, target)
	if inst.mauser:GetUses("ammo") > 0 then
		attacker.SoundEmitter:PlaySound("rifle/fire/fire_1")
		inst.mauser:Uses("ammo")
	else		
		inst.mauser:Uses("bayonet")
	end
end

local function onempty(inst)
	inst.components.weapon:SetDamage(TUNING.BAYONET_DAMAGE * TUNING.SPEAR_DAMAGE * 1.5)
	inst.components.weapon:SetProjectile(nil)
	inst.components.weapon:SetRange(1.5,1.5)
	inst:RemoveTag("blowdart")
	inst:AddTag("spear")
	inst.components.finiteuses:SetMaxUses(inst.mauser:GetMaxUses("bayonet"))
	inst.components.finiteuses:SetUses(inst.mauser:GetUses("bayonet"))
end

local function onrecharge(inst)
	inst.components.weapon:SetDamage(TUNING.RIFLE_DAMAGE * TUNING.SPEAR_DAMAGE)
	inst.components.weapon:SetProjectile("bullet")
	inst.components.weapon:SetRange(TUNING.RIFLE_RANGE,TUNING.RIFLE_RANGE * 1.5)
	inst:RemoveTag("spear")
	inst:AddTag("blowdart")
	inst.components.finiteuses:SetMaxUses(inst.mauser:GetMaxUses("ammo"))
	inst.components.finiteuses:SetUses(inst.mauser:GetUses("ammo"))
end

local function onbroken(inst)
	local rifle = SpawnPrefab("rifle")
	rifle.mauser:SetUses("rifle",inst.mauser:GetUses("rifle"))
	rifle:onupdate()
	local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
	local holder = owner and owner.components.inventory
	inst:Remove()
	holder:Equip(rifle)
end

local function onfinished(inst)
	if inst.mauser:GetUses("bayonet") == 0 then
		onbroken(inst)
	else
		onempty(inst)
	end
end

local function onupdate(inst)
	if inst.mauser:GetUses("ammo") == 0 then
		onempty(inst)
	else
		onrecharge(inst)
	end
end

local function canreloading(inst, item)
    if item.prefab == "ammo" and inst.mauser:GetUses("ammo") < inst.mauser:GetMaxUses("ammo") then
		return true
	end
    if item.prefab == "goldnugget" and inst.mauser:GetUses("bayonet") < inst.mauser:GetMaxUses("bayonet") then
		return true
    end
    return false
end

local function reloading(inst, giver, item)
	if item.prefab == "ammo" then
		local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
		local holder = owner or giver
		holder.SoundEmitter:PlaySound("rifle/reload/reload_1")
		inst.mauser:SetUses("ammo",inst.mauser:GetUses("ammo") + 1)
		onrecharge(inst)
	else
		local value = inst.mauser:GetUses("bayonet") + inst.mauser:GetMaxUses("bayonet") / 2
		inst.mauser:SetUses("bayonet",value)
		inst:onupdate()
	end
end

local function initialize( inst, owner )
	inst:RemoveEventCallback("percentusedchange", initialize)
	inst:onupdate()
end

local function fn()
	local inst = CreateEntity()
	
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
	if TheSim:GetGameID() == "DST" then
		inst.entity:AddNetwork()
	end

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("rifleb")
    inst.AnimState:SetBuild("rifleb")
    inst.AnimState:PlayAnimation("idle")
    --inst:AddTag("needssewing")
	inst:AddTag("sharp")
	inst:AddTag("spear")
	
	inst.onupdate = onupdate
	
	if TheSim:GetGameID() == "DST" then
		inst.entity:SetPristine()
		if not TheWorld.ismastersim then
			return inst
		end
	end
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/rifleb.xml"
	
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetMaxUses(TUNING.BAYONET_DURABILITY)
	inst.components.finiteuses:SetUses(TUNING.BAYONET_DURABILITY)
	inst.components.finiteuses:SetOnFinished(onfinished)
	
    inst:AddComponent("finiteuses_mauser")
	inst.mauser = inst.components.finiteuses_mauser
	inst.mauser:SetMaxUses("ammo",TUNING.RIFLE_AMMO)
	inst.mauser:SetUses("ammo",0)
	inst.mauser:SetMaxUses("bayonet",TUNING.BAYONET_DURABILITY)
	inst.mauser:SetUses("bayonet",TUNING.BAYONET_DURABILITY)
	inst.mauser:SetMaxUses("rifle",TUNING.RIFLE_DURABILITY)
	inst.mauser:SetUses("rifle",TUNING.RIFLE_DURABILITY)
	
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.BAYONET_DAMAGE * TUNING.SPEAR_DAMAGE * 1.5)
    inst.components.weapon:SetRange(1.5,1.5)
    inst.components.weapon:SetProjectile(nil)
    inst.components.weapon:SetOnAttack(onattack)
	
	inst:AddComponent("trader")
    inst.components.trader.onaccept = reloading
    inst.components.trader:SetAcceptTest(canreloading)
	
	inst:ListenForEvent("percentusedchange", initialize)
	
	if TheSim:GetGameID() == "DST" then
		MakeHauntableLaunch(inst)
	end
    return inst
end

STRINGS.NAMES.RIFLEB  = "Rifle With Bayonet"
STRINGS.RECIPE_DESC.RIFLEB  = "Powerful Rifle & Bayonet"

return Prefab( "common/inventory/rifleb", fn, assets,prefabs) 